/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.net.URL;

public class FileDescriptor {
    private String name;
    private URL url;

    public FileDescriptor(String name, URL url) {
        this.name = name;
        this.url = url;
    }

    public FileDescriptor(String name, ClassLoader classLoader) {
        this.name = name;
        if (name == null) {
            throw new NullPointerException("Name cannot be null, loading from " + classLoader);
        }
        this.url = classLoader.getResource(name);
        if (this.url == null) {
            throw new NullPointerException("Cannot find URL from classLoader for " + name + ", loading from " + classLoader);
        }
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() {
        return this.url;
    }

    public String toString() {
        return this.url.getPath();
    }

    public boolean equals(Object other) {
        if (other instanceof FileDescriptor) {
            FileDescriptor that = (FileDescriptor)other;
            return this.getUrl().equals(that.getUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }
}

