/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Context.RunInputScript", category="Scripting", label="Run Input Script", description="Run a script from the input blob. A blob comtaining script result is returned.")
public class RunInputScript {
    public static final String ID = "Context.RunInputScript";
    @Context
    protected OperationContext ctx;
    @Param(name="type", required=false, values={"mvel", "groovy"}, widget="Option")
    protected String type = "mvel";

    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        if (!((NuxeoPrincipal)this.ctx.getPrincipal()).isAdministrator()) {
            throw new OperationException("Not allowed. You must be administrator to run scripts");
        }
        Object r = null;
        if (this.type.equals("mvel")) {
            r = Scripting.MvelScript.compile(blob.getString()).eval(this.ctx);
        } else if (this.type.equals("groovy")) {
            r = new Scripting.GroovyScript(blob.getString()).eval(this.ctx);
        } else {
            throw new OperationException("Unknown scripting language " + this.type);
        }
        if (r != null) {
            StringBlob b = new StringBlob(r.toString());
            b.setMimeType("text/plain");
            b.setFilename("result");
            return b;
        }
        return null;
    }
}

