/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Operation(id="Context.RunDocumentOperationInNewTx", category="Execution Flow", label="Run Document Chain in new Tx", description="Run an operation chain in a separate tx. The 'parameters' injected are accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.")
public class RunInNewTransaction {
    public static final String ID = "Context.RunDocumentOperationInNewTx";
    private static final Log log = LogFactory.getLog(RunInNewTransaction.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"false"})
    protected boolean isolate = false;
    @Param(name="rollbackGlobalOnError", required=false, values={"false"})
    protected boolean rollbackGlobalOnError = false;
    @Param(name="parameters", description="Accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", required=false)
    protected Properties chainParameters;
    @Param(name="timeout", required=false)
    protected Integer timeout = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public void run() throws Exception {
        if (TransactionHelper.isTransactionMarkedRollback()) {
            return;
        }
        Map<String, Object> vars = this.isolate ? new HashMap<String, Object>(this.ctx.getVars()) : this.ctx.getVars();
        RunnableOperation runOp = new RunnableOperation(this.ctx.getCoreSession().getRepositoryName(), this.chainId, vars);
        boolean failed = false;
        try {
            runOp.start();
            runOp.join((this.timeout + 1) * 1000);
            if (runOp.isAlive()) {
                failed = true;
            }
        }
        finally {
            if ((failed || runOp.isFailed()) && this.rollbackGlobalOnError) {
                TransactionHelper.setTransactionRollbackOnly();
            }
        }
        this.ctx.getCoreSession().save();
    }

    protected class RunnableOperation
    extends Thread {
        protected final Map<String, Object> vars;
        protected final String repo;
        protected final String opName;
        protected boolean failed;

        public RunnableOperation(String repo, String opName, Map<String, Object> vars) {
            super("Runner-for-" + opName);
            this.failed = false;
            this.vars = vars;
            this.repo = repo;
            this.opName = opName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TransactionHelper.startTransaction((int)RunInNewTransaction.this.timeout);
            try {
                new UnrestrictedSessionRunner(this.repo){

                    public void run() throws ClientException {
                        OperationContext subctx = new OperationContext(this.session, RunnableOperation.this.vars);
                        subctx.setInput(RunInNewTransaction.this.ctx.getInput());
                        try {
                            RunInNewTransaction.this.service.run(subctx, RunnableOperation.this.opName, RunInNewTransaction.this.chainParameters);
                        }
                        catch (Exception e) {
                            throw ClientException.wrap((Throwable)e);
                        }
                    }
                }.runUnrestricted();
            }
            catch (ClientException e) {
                TransactionHelper.setTransactionRollbackOnly();
                this.failed = true;
                log.error((Object)("Error while executing operation " + this.opName), (Throwable)e);
            }
            finally {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

