/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.dm.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteStep;
import org.nuxeo.ecm.platform.routing.dm.operation.CreateRoutingTask;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;

@Operation(id="Workflow.RemoveRoutingTask", category="Services", label="remove task", since="5.6", description=" This operation removes all the tasks created when a given step is run.", addToStudio=false)
public class RemoveRoutingTask {
    public static final String ID = "Workflow.RemoveRoutingTask";
    private static final Log log = LogFactory.getLog(RemoveRoutingTask.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession coreSession;
    @Context
    protected TaskService taskService;

    @OperationMethod
    public void removeTasks() throws Exception {
        List<Task> tasks = this.fetchTasks();
        for (Task task : tasks) {
            this.taskService.deleteTask(this.coreSession, task.getId());
        }
    }

    protected List<Task> fetchTasks() throws ClientException {
        List<Task> tasks = new ArrayList<Task>();
        DocumentModelList docList = (DocumentModelList)this.ctx.get((Object)CreateRoutingTask.OperationTaskVariableName.taskDocuments.name());
        if (docList != null) {
            for (DocumentModel documentModel : docList) {
                tasks.add((Task)documentModel.getAdapter(Task.class));
            }
        }
        if (tasks.isEmpty()) {
            tasks = this.fetchTasksFromStep();
        }
        return tasks;
    }

    protected List<Task> fetchTasksFromStep() throws ClientException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        DocumentRouteStep step = (DocumentRouteStep)this.ctx.get((Object)"document.routing.step");
        DocumentModelList list = this.coreSession.query(String.format("Select * from TaskDoc WHERE nt:task_variables/*/key like '%s' AND nt:task_variables/*/value like '%s'", "document.routing.step", step.getDocument().getId()));
        for (DocumentModel documentModel : list) {
            tasks.add((Task)documentModel.getAdapter(Task.class));
        }
        return tasks;
    }
}

