/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.InternalPackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.RecursiveDependencyResolver;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.Version;

public class DependencyResolver {
    protected InternalPackageManager pm;
    protected static final int MAX_DEPTH = 10;
    protected static Log log = LogFactory.getLog(DependencyResolver.class);

    public DependencyResolver(InternalPackageManager pm) {
        this.pm = pm;
    }

    public DependencyResolution resolve(String pkgId, String targetPlatform) throws DependencyException {
        log.debug((Object)"Computing possible dependency sets");
        RecursiveDependencyResolver choices = this.computeAvailableChoices(pkgId, targetPlatform);
        log.debug((Object)"Resulting choices : ");
        log.debug((Object)choices.toString());
        log.debug((Object)("Max possibilities : " + choices.getNaxPossibilities()));
        log.debug((Object)"Sorting choices");
        choices.sort(this.pm);
        log.debug((Object)"Sorted choices : ");
        log.debug((Object)choices.toString());
        DependencyResolution res = choices.tryResolve();
        if (res != null) {
            res.sort(this.pm);
            return res;
        }
        throw new DependencyException("Unable to resolve dependencies");
    }

    protected RecursiveDependencyResolver computeAvailableChoices(String pkgId, String targetPlatform) throws DependencyException {
        RecursiveDependencyResolver dc = new RecursiveDependencyResolver(pkgId, this.pm, targetPlatform);
        this.recurseOnAvailableChoices(pkgId, targetPlatform, dc, 1);
        return dc;
    }

    protected void recurseOnAvailableChoices(String pkgId, String targetPlatform, RecursiveDependencyResolver dc, int depth) throws DependencyException {
        DownloadablePackage pkg = this.pm.findPackageById(pkgId);
        if (pkg == null) {
            throw new DependencyException("Unable to find package " + pkgId);
        }
        for (PackageDependency dep : pkg.getDependencies()) {
            List<Version> versions = this.pm.getAvailableVersion(dep.getName(), dep.getVersionRange(), targetPlatform);
            if (versions.size() == 0) {
                throw new DependencyException("Unable to find a compatible version for package " + dep.getName() + " (" + dep.getVersionRange().toString() + ")");
            }
            dc.addDep(dep.getName(), versions);
            if (depth >= 10) {
                throw new DependencyException("Maximum depth reached, check that you don't have a loop in dependencies");
            }
            for (Version v : versions) {
                this.recurseOnAvailableChoices(dep.getName() + "-" + v.toString(), targetPlatform, dc, depth + 1);
            }
        }
    }
}

