/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.ConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.repository.RepositoryDescriptor;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepository;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionFactoryImpl;

public class PoolingRepositoryFactory
implements RepositoryFactory {
    private static final Log log = LogFactory.getLog(PoolingRepositoryFactory.class);
    private static final String[] CM_NAMES = new String[]{"java:comp/NuxeoConnectionManager", "java:comp/env/NuxeoConnectionManager", "java:NuxeoConnectionManager"};

    public Repository createRepository(RepositoryDescriptor descriptor) throws Exception {
        log.info((Object)("Creating pooling repository: " + descriptor.getName()));
        ManagedConnectionFactoryImpl managedConnectionFactory = new ManagedConnectionFactoryImpl(SQLRepository.getDescriptor((RepositoryDescriptor)descriptor));
        return (Repository)managedConnectionFactory.createConnectionFactory(PoolingRepositoryFactory.lookupConnectionManager());
    }

    protected static ConnectionManager lookupConnectionManager() throws NamingException {
        InitialContext context = new InitialContext();
        int i = 0;
        for (String name : CM_NAMES) {
            try {
                ConnectionManager connectionManager = (ConnectionManager)context.lookup(name);
                if (connectionManager != null) {
                    if (i != 0) {
                        PoolingRepositoryFactory.CM_NAMES[i] = CM_NAMES[0];
                        PoolingRepositoryFactory.CM_NAMES[0] = name;
                    }
                    return connectionManager;
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
            ++i;
        }
        throw new NamingException("NuxeoConnectionManager not found in JNDI");
    }
}

