/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.platform.ui.web.rest.StaticNavigationHandler;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;

public class FancyURLResponseWrapper
extends HttpServletResponseWrapper {
    private static final Log log = LogFactory.getLog(FancyURLResponseWrapper.class);
    protected HttpServletRequest request = null;
    protected StaticNavigationHandler navigationHandler;

    public FancyURLResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public FancyURLResponseWrapper(HttpServletResponse response, HttpServletRequest request, StaticNavigationHandler navigationHandler) {
        super(response);
        this.request = request;
        this.navigationHandler = navigationHandler;
    }

    protected String getViewId(String url, HttpServletRequest request) {
        return null;
    }

    protected String rewriteUrl(String url, DocumentView docView, URLPolicyService service) {
        String uriString;
        Map parameters;
        String newViewId = (String)this.request.getAttribute("PostOutcome");
        String baseUrl = BaseURL.getBaseURL((ServletRequest)this.request);
        if (newViewId != null) {
            docView.setViewId(newViewId);
        } else {
            String viewId = url;
            String webAppName = "/" + BaseURL.getWebAppName();
            if (viewId.startsWith(baseUrl)) {
                viewId = '/' + viewId.substring(baseUrl.length());
            } else if (viewId.startsWith(webAppName)) {
                viewId = viewId.substring(webAppName.length());
            }
            int index = viewId.indexOf(63);
            if (index != -1) {
                viewId = viewId.substring(0, index);
            }
            String jsfOutcome = this.navigationHandler.getOutcomeFromViewId(viewId);
            docView.setViewId(jsfOutcome);
        }
        int index = url.indexOf(63);
        if (index != -1 && (parameters = URIUtils.getRequestParameters((String)(uriString = url.substring(index + 1)))) != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                docView.addParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        url = service.getUrlFromDocumentView(docView, baseUrl);
        return url;
    }

    public void sendRedirect(String url) throws IOException {
        if (this.request != null) {
            try {
                DocumentView docView;
                URLPolicyService pservice = (URLPolicyService)Framework.getService(URLPolicyService.class);
                if (pservice.isCandidateForEncoding(this.request) && (docView = pservice.getDocumentViewFromRequest(this.request)) != null) {
                    url = this.rewriteUrl(url, docView, pservice);
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not redirect", (Throwable)e);
            }
        }
        super.sendRedirect(url);
    }
}

