/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.FeedProcessor;
import org.apache.shindig.gadgets.FetchResponseUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.rewrite.RequestRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.servlet.HttpRequestHandler;
import org.apache.shindig.gadgets.servlet.ProxyBase;

@Singleton
public class MakeRequestHandler
extends ProxyBase {
    public static final String UNPARSEABLE_CRUFT = "throw 1; < don't be evil' >";
    public static final String POST_DATA_PARAM = "postData";
    public static final String METHOD_PARAM = "httpMethod";
    public static final String HEADERS_PARAM = "headers";
    public static final String NOCACHE_PARAM = "nocache";
    public static final String CONTENT_TYPE_PARAM = "contentType";
    public static final String NUM_ENTRIES_PARAM = "numEntries";
    public static final String DEFAULT_NUM_ENTRIES = "3";
    public static final String GET_SUMMARIES_PARAM = "getSummaries";
    public static final String AUTHZ_PARAM = "authz";
    private final RequestPipeline requestPipeline;
    private final RequestRewriterRegistry contentRewriterRegistry;

    @Inject
    public MakeRequestHandler(RequestPipeline requestPipeline, RequestRewriterRegistry contentRewriterRegistry) {
        this.requestPipeline = requestPipeline;
        this.contentRewriterRegistry = contentRewriterRegistry;
    }

    protected void doFetch(HttpServletRequest request, HttpServletResponse response) throws GadgetException, IOException {
        HttpRequest rcr = this.buildHttpRequest(request);
        HttpResponse results = this.requestPipeline.execute(rcr);
        if (this.contentRewriterRegistry != null) {
            try {
                results = this.contentRewriterRegistry.rewriteHttpResponse(rcr, results);
            }
            catch (RewritingException e) {
                throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        String output = this.convertResponseToJson(rcr.getSecurityToken(), request, results);
        this.setResponseHeaders(request, response, results);
        response.setStatus(200);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(UNPARSEABLE_CRUFT + output);
    }

    protected HttpRequest buildHttpRequest(HttpServletRequest request) throws GadgetException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        Uri url = this.validateUrl(request.getParameter("url"));
        HttpRequest req = new HttpRequest(url).setMethod(this.getParameter(request, METHOD_PARAM, "GET")).setPostBody(this.getParameter(request, POST_DATA_PARAM, "").getBytes()).setContainer(this.getContainer(request));
        String headerData = this.getParameter(request, HEADERS_PARAM, "");
        if (headerData.length() > 0) {
            String[] headerList;
            for (String header : headerList = headerData.split("&")) {
                String[] parts = header.split("=");
                if (parts.length != 2) {
                    throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Malformed header specified,");
                }
                String headerName = Utf8UrlCoder.decode((String)parts[0]);
                if (HttpRequestHandler.BAD_HEADERS.contains(headerName.toUpperCase())) continue;
                req.addHeader(headerName, Utf8UrlCoder.decode((String)parts[1]));
            }
        }
        if ("POST".equals(req.getMethod()) && req.getHeader("Content-Type") == null) {
            req.addHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        req.setIgnoreCache("1".equals(request.getParameter(NOCACHE_PARAM)));
        if (request.getParameter("gadget") != null) {
            req.setGadget(Uri.parse((String)request.getParameter("gadget")));
        }
        if (request.getParameter("refresh") != null) {
            try {
                req.setCacheTtl(Integer.parseInt(request.getParameter("refresh")));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        req.setRewriteMimeType(request.getParameter("rewriteMime"));
        AuthType auth = AuthType.parse(this.getParameter(request, AUTHZ_PARAM, null));
        req.setAuthType(auth);
        if (auth != AuthType.NONE) {
            req.setSecurityToken(this.extractAndValidateToken(request));
            req.setOAuthArguments(new OAuthArguments(auth, request));
        }
        this.setRequestHeaders(request, req);
        return req;
    }

    protected String convertResponseToJson(SecurityToken authToken, HttpServletRequest request, HttpResponse results) throws GadgetException {
        String updatedAuthToken;
        String originalUrl = request.getParameter("url");
        String body = results.getResponseAsString();
        if (body.length() > 0 && "FEED".equals(request.getParameter(CONTENT_TYPE_PARAM))) {
            body = this.processFeed(originalUrl, request, body);
        }
        Map<String, Object> resp = FetchResponseUtils.getResponseAsJson(results, null, body);
        if (authToken != null && (updatedAuthToken = authToken.getUpdatedToken()) != null) {
            resp.put("st", updatedAuthToken);
        }
        return JsonSerializer.serialize(Collections.singletonMap(originalUrl, resp));
    }

    protected RequestPipeline getRequestPipeline() {
        return this.requestPipeline;
    }

    private SecurityToken extractAndValidateToken(HttpServletRequest request) throws GadgetException {
        SecurityToken token = new AuthInfo(request).getSecurityToken();
        if (token == null) {
            throw new GadgetException(GadgetException.Code.INVALID_SECURITY_TOKEN);
        }
        return token;
    }

    private String processFeed(String url, HttpServletRequest req, String xml) throws GadgetException {
        boolean getSummaries = Boolean.parseBoolean(this.getParameter(req, GET_SUMMARIES_PARAM, "false"));
        int numEntries = Integer.parseInt(this.getParameter(req, NUM_ENTRIES_PARAM, DEFAULT_NUM_ENTRIES));
        return new FeedProcessor().process(url, xml, getSummaries, numEntries).toString();
    }
}

