/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.render.SanitizingGadgetRewriter;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateLibrary;
import org.apache.shindig.gadgets.templates.TemplateParserException;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.TemplateResource;
import org.apache.shindig.gadgets.templates.tags.DefaultTagRegistry;
import org.apache.shindig.gadgets.templates.tags.TagHandler;
import org.apache.shindig.gadgets.templates.tags.TemplateBasedTagHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTemplateLibrary
implements TemplateLibrary {
    public static final String TAG_ATTRIBUTE = "tag";
    public static final String NAMESPACE_TAG = "Namespace";
    public static final String TEMPLATE_TAG = "Template";
    public static final String STYLE_TAG = "Style";
    public static final String JAVASCRIPT_TAG = "JavaScript";
    public static final String TEMPLATEDEF_TAG = "TemplateDef";
    private final Uri libraryUri;
    private final String source;
    private final boolean safe;
    private TagRegistry registry;
    private String nsPrefix;
    private String nsUri;
    private String style;
    private String javaScript;
    private Set<TemplateResource> libraryResources;

    public XmlTemplateLibrary(Uri uri, Element root, String source) throws GadgetException {
        this(uri, root, source, false);
    }

    public XmlTemplateLibrary(Uri uri, Element root, String source, boolean safe) throws GadgetException {
        this.libraryUri = uri;
        this.source = source;
        this.registry = new DefaultTagRegistry(this.parseLibraryDocument(root));
        this.safe = safe;
        ImmutableSet.Builder resources = ImmutableSet.builder();
        if (this.style != null) {
            resources.add((Object)TemplateResource.newStyleResource(this.style, this));
        }
        if (this.javaScript != null) {
            resources.add((Object)TemplateResource.newJavascriptResource(this.javaScript, this));
        }
        this.libraryResources = resources.build();
    }

    @Override
    public TagRegistry getTagRegistry() {
        return this.registry;
    }

    @Override
    public Uri getLibraryUri() {
        return this.libraryUri;
    }

    @Override
    public boolean isSafe() {
        return this.safe;
    }

    @Override
    public String serialize() {
        return this.source;
    }

    protected TagHandler createTagHandler(Element template, String namespaceUri, String localName) {
        return new TemplateBasedTagHandler(template, namespaceUri, localName);
    }

    private Set<TagHandler> parseLibraryDocument(Element root) throws GadgetException {
        ImmutableSet.Builder handlers = ImmutableSet.builder();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (NAMESPACE_TAG.equals(element.getLocalName())) {
                this.processNamespace(element);
                continue;
            }
            if (STYLE_TAG.equals(element.getLocalName())) {
                this.processStyle(element);
                continue;
            }
            if (JAVASCRIPT_TAG.equals(element.getLocalName())) {
                this.processJavaScript(element);
                continue;
            }
            if (TEMPLATE_TAG.equals(element.getLocalName())) {
                this.processTemplate((ImmutableSet.Builder<TagHandler>)handlers, element);
                continue;
            }
            if (!TEMPLATEDEF_TAG.equals(element.getLocalName())) continue;
            this.processTemplateDef((ImmutableSet.Builder<TagHandler>)handlers, element);
        }
        return handlers.build();
    }

    private void processTemplateDef(ImmutableSet.Builder<TagHandler> handlers, Element defElement) throws TemplateParserException {
        Element styleElement;
        Attr tagAttribute = defElement.getAttributeNode(TAG_ATTRIBUTE);
        if (tagAttribute == null) {
            throw new TemplateParserException("Missing tag attribute on TemplateDef");
        }
        ImmutableSet.Builder resources = ImmutableSet.builder();
        Element scriptElement = (Element)DomUtil.getFirstNamedChildNode((Node)defElement, (String)JAVASCRIPT_TAG);
        if (scriptElement != null) {
            resources.add((Object)TemplateResource.newJavascriptResource(scriptElement.getTextContent(), this));
        }
        if ((styleElement = (Element)DomUtil.getFirstNamedChildNode((Node)defElement, (String)STYLE_TAG)) != null) {
            resources.add((Object)TemplateResource.newStyleResource(styleElement.getTextContent(), this));
        }
        Element templateElement = (Element)DomUtil.getFirstNamedChildNode((Node)defElement, (String)TEMPLATE_TAG);
        TagHandler handler = this.createHandler(tagAttribute.getNodeValue(), templateElement, (Set<TemplateResource>)resources.build());
        if (handler != null) {
            handlers.add((Object)handler);
        }
    }

    private void processTemplate(ImmutableSet.Builder<TagHandler> handlers, Element templateElement) throws TemplateParserException {
        Attr tagAttribute = templateElement.getAttributeNode(TAG_ATTRIBUTE);
        if (tagAttribute == null) {
            throw new TemplateParserException("Missing tag attribute on Template");
        }
        TagHandler handler = this.createHandler(tagAttribute.getNodeValue(), templateElement, (Set<TemplateResource>)ImmutableSet.of());
        if (handler != null) {
            handlers.add((Object)handler);
        }
    }

    private void processStyle(Element element) {
        this.style = this.style == null ? element.getTextContent() : this.style + "\n" + element.getTextContent();
    }

    private void processJavaScript(Element element) {
        this.javaScript = this.javaScript == null ? element.getTextContent() : this.javaScript + "\n" + element.getTextContent();
    }

    private void processNamespace(Element namespaceNode) throws TemplateParserException {
        if (this.nsPrefix != null || this.nsUri != null) {
            throw new TemplateParserException("Duplicate Namespace elements");
        }
        this.nsPrefix = namespaceNode.getAttribute("prefix");
        if ("".equals(this.nsPrefix)) {
            throw new TemplateParserException("Missing prefix attribute on Namespace");
        }
        this.nsUri = namespaceNode.getAttribute("url");
        if ("".equals(this.nsUri)) {
            throw new TemplateParserException("Missing url attribute on Namespace");
        }
    }

    private TagHandler createHandler(String tagName, Element template, Set<TemplateResource> resources) throws TemplateParserException {
        String[] nameParts = tagName.split(":");
        if (nameParts.length != 2) {
            return null;
        }
        String namespaceUri = template.lookupNamespaceURI(nameParts[0]);
        if (!this.nsPrefix.equals(nameParts[0]) || !this.nsUri.equals(namespaceUri)) {
            throw new TemplateParserException("Can't create tags in undeclared namespace: " + nameParts[0]);
        }
        if (this.isSafe()) {
            this.bypassTemplateSanitization(template);
        }
        return new LibraryTagHandler(this.createTagHandler(template, namespaceUri, nameParts[1]), resources);
    }

    private void bypassTemplateSanitization(Element template) {
        SanitizingGadgetRewriter.bypassSanitization(template, false);
        NodeList children = template.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            this.bypassTemplateSanitization((Element)node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LibraryTagHandler
    implements TagHandler {
        private final TagHandler tagHandler;
        private final Set<TemplateResource> tagResources;

        public LibraryTagHandler(TagHandler tagHandler, Set<TemplateResource> resources) {
            this.tagHandler = tagHandler;
            this.tagResources = resources;
        }

        @Override
        public String getNamespaceUri() {
            return this.tagHandler.getNamespaceUri();
        }

        @Override
        public String getTagName() {
            return this.tagHandler.getTagName();
        }

        @Override
        public void process(Node result, Element tag, TemplateProcessor processor) {
            for (TemplateResource resource : this.tagResources) {
                processor.getTemplateContext().addResource(resource, resource);
            }
            for (TemplateResource resource : XmlTemplateLibrary.this.libraryResources) {
                processor.getTemplateContext().addResource(resource, resource);
            }
            this.tagHandler.process(result, tag, processor);
        }
    }
}

