/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.html;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.config.AllowedFileResolver;
import com.google.caja.config.ConfigUtil;
import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTextEscapingMode;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.LoaderType;
import com.google.caja.plugin.UriEffect;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.tools.BuildCommand;
import com.google.caja.util.Charsets;
import com.google.caja.util.Function;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlDefinitions {
    private static final AttribKey SCRIPT_SRC = AttribKey.forHtmlAttrib(ElKey.forHtmlElement("script"), "src");
    private static final Map<HTML.Attribute.Type, Integer> A_TYPE_MAP = new EnumMap<HTML.Attribute.Type, Integer>(HTML.Attribute.Type.class);
    private static final Map<UriEffect, Integer> A_UEFFECT_MAP;
    private static final Map<LoaderType, Integer> L_TYPE_MAP;

    private static <U> ExpressionStmt mapFromEnum(Iterable<U> entries, String key, Function<U, String> keyMaker, Function<U, Integer> valueMaker) {
        FilePosition unk = FilePosition.UNKNOWN;
        List<StringLiteral> keys = Lists.newArrayList();
        List<IntegerLiteral> values = Lists.newArrayList();
        for (U e : entries) {
            keys.add(StringLiteral.valueOf(unk, keyMaker.apply(e)));
            values.add(new IntegerLiteral(unk, valueMaker.apply(e).intValue()));
        }
        return new ExpressionStmt(unk, (Expression)QuasiBuilder.substV("html4.@i = { @k*: @v* };", "i", new Reference(new Identifier(unk, key)), "k", new ParseTreeNodeContainer(keys), "v", new ParseTreeNodeContainer(values)));
    }

    public static Block generateJavascriptDefinitions(HtmlSchema schema) {
        MessagePart key;
        FilePosition unk = FilePosition.UNKNOWN;
        Map<AttribKey, HTML.Attribute.Type> atypes = HtmlDefinitions.attributeTypes(schema);
        Map<ElKey, EnumSet<EFlag>> eflags = HtmlDefinitions.elementFlags(schema);
        Map<AttribKey, UriEffect> uriEffects = HtmlDefinitions.uriEffects(schema);
        Map<AttribKey, LoaderType> ltypes = HtmlDefinitions.loaderTypes(schema);
        Block definitions = new Block();
        definitions.appendChild(QuasiBuilder.substV("var html4 = {};", new Object[0]));
        definitions.appendChild(HtmlDefinitions.mapFromEnum(EnumSet.allOf(HTML.Attribute.Type.class), "atype", new Function<HTML.Attribute.Type, String>(){

            @Override
            public String apply(HTML.Attribute.Type f) {
                return f.name();
            }
        }, new Function<HTML.Attribute.Type, Integer>(){

            @Override
            public Integer apply(HTML.Attribute.Type f) {
                return (Integer)A_TYPE_MAP.get((Object)f);
            }
        }));
        ArrayList<StringLiteral> keys = new ArrayList<StringLiteral>();
        ArrayList<IntegerLiteral> values = new ArrayList<IntegerLiteral>();
        for (Map.Entry<AttribKey, HTML.Attribute.Type> entry : atypes.entrySet()) {
            key = entry.getKey();
            if (!ElKey.HTML_WILDCARD.equals(((AttribKey)key).el) && !schema.isElementAllowed(((AttribKey)key).el) && !SCRIPT_SRC.equals(key)) continue;
            keys.add(StringLiteral.valueOf(unk, ((AttribKey)key).toString()));
            values.add(new IntegerLiteral(unk, A_TYPE_MAP.get((Object)entry.getValue()).intValue()));
        }
        definitions.appendChild(new ExpressionStmt(unk, (Expression)QuasiBuilder.substV("html4.ATTRIBS = { @k*: @v* };", "k", new ParseTreeNodeContainer(keys), "v", new ParseTreeNodeContainer(values))));
        definitions.appendChild(HtmlDefinitions.mapFromEnum(EnumSet.allOf(EFlag.class), "eflags", new Function<EFlag, String>(){

            @Override
            public String apply(EFlag f) {
                return f.name();
            }
        }, new Function<EFlag, Integer>(){

            @Override
            public Integer apply(EFlag f) {
                return f.bitMask;
            }
        }));
        keys = new ArrayList();
        values = new ArrayList();
        for (Map.Entry<MessagePart, Object> entry : eflags.entrySet()) {
            key = (ElKey)entry.getKey();
            int value = 0;
            for (EFlag f : (EnumSet)entry.getValue()) {
                value |= f.bitMask;
            }
            keys.add(StringLiteral.valueOf(unk, ((ElKey)key).toString()));
            values.add(new IntegerLiteral(unk, value));
        }
        definitions.appendChild(new ExpressionStmt(unk, (Expression)QuasiBuilder.substV("html4.ELEMENTS = { @k*: @v* };", "k", new ParseTreeNodeContainer(keys), "v", new ParseTreeNodeContainer(values))));
        definitions.appendChild(HtmlDefinitions.mapFromEnum(EnumSet.allOf(UriEffect.class), "ueffects", new Function<UriEffect, String>(){

            @Override
            public String apply(UriEffect f) {
                return f.name();
            }
        }, new Function<UriEffect, Integer>(){

            @Override
            public Integer apply(UriEffect f) {
                return (Integer)A_UEFFECT_MAP.get((Object)f);
            }
        }));
        definitions.appendChild(HtmlDefinitions.mapFromEnum(uriEffects.entrySet(), "URIEFFECTS", new Function<Map.Entry<AttribKey, UriEffect>, String>(){

            @Override
            public String apply(Map.Entry<AttribKey, UriEffect> f) {
                return f.getKey().toString();
            }
        }, new Function<Map.Entry<AttribKey, UriEffect>, Integer>(){

            @Override
            public Integer apply(Map.Entry<AttribKey, UriEffect> f) {
                return (Integer)A_UEFFECT_MAP.get((Object)f.getValue());
            }
        }));
        definitions.appendChild(HtmlDefinitions.mapFromEnum(EnumSet.allOf(LoaderType.class), "ltypes", new Function<LoaderType, String>(){

            @Override
            public String apply(LoaderType f) {
                return f.name();
            }
        }, new Function<LoaderType, Integer>(){

            @Override
            public Integer apply(LoaderType f) {
                return (Integer)L_TYPE_MAP.get((Object)f);
            }
        }));
        definitions.appendChild(HtmlDefinitions.mapFromEnum(ltypes.entrySet(), "LOADERTYPES", new Function<Map.Entry<AttribKey, LoaderType>, String>(){

            @Override
            public String apply(Map.Entry<AttribKey, LoaderType> f) {
                return f.getKey().toString();
            }
        }, new Function<Map.Entry<AttribKey, LoaderType>, Integer>(){

            @Override
            public Integer apply(Map.Entry<AttribKey, LoaderType> f) {
                return (Integer)L_TYPE_MAP.get((Object)f.getValue());
            }
        }));
        return definitions;
    }

    public static int getJavascriptValueForAType(HTML.Attribute.Type atype) {
        return A_TYPE_MAP.get((Object)atype);
    }

    public static int getJavascriptValueForUEffect(UriEffect uEffect) {
        return A_UEFFECT_MAP.get((Object)uEffect);
    }

    public static int getJavascriptValueForLType(LoaderType ltype) {
        return L_TYPE_MAP.get((Object)ltype);
    }

    private static Map<AttribKey, HTML.Attribute.Type> attributeTypes(HtmlSchema schema) {
        SortedMap<AttribKey, HTML.Attribute.Type> attributeFlags = Maps.newTreeMap();
        for (AttribKey attribKey : schema.getAttributeNames()) {
            if (!schema.isAttributeAllowed(attribKey)) continue;
            HTML.Attribute a = schema.lookupAttribute(attribKey);
            HTML.Attribute.Type type = a.getType();
            attributeFlags.put(attribKey, type);
        }
        return attributeFlags;
    }

    private static <A> Map<AttribKey, A> deriveMapFromSchema(HtmlSchema schema, SchemaExtractor<A> extractor) {
        SortedMap<AttribKey, A> result = Maps.newTreeMap();
        for (AttribKey attribKey : schema.getAttributeNames()) {
            HTML.Attribute a;
            A type;
            if (!schema.isAttributeAllowed(attribKey) || null == (type = extractor.extract(a = schema.lookupAttribute(attribKey)))) continue;
            result.put(attribKey, type);
        }
        return result;
    }

    private static Map<AttribKey, UriEffect> uriEffects(HtmlSchema schema) {
        return HtmlDefinitions.deriveMapFromSchema(schema, new SchemaExtractor<UriEffect>(){

            @Override
            public UriEffect extract(HTML.Attribute attr) {
                return attr.getUriEffect();
            }
        });
    }

    private static Map<AttribKey, LoaderType> loaderTypes(HtmlSchema schema) {
        return HtmlDefinitions.deriveMapFromSchema(schema, new SchemaExtractor<LoaderType>(){

            @Override
            public LoaderType extract(HTML.Attribute attr) {
                return attr.getLoaderType();
            }
        });
    }

    private static Map<ElKey, EnumSet<EFlag>> elementFlags(HtmlSchema schema) {
        ElKey SCRIPT = ElKey.forHtmlElement("script");
        ElKey STYLE = ElKey.forHtmlElement("style");
        SortedMap<ElKey, EnumSet<EFlag>> elementFlags = Maps.newTreeMap();
        for (ElKey elementName : schema.getElementNames()) {
            HTML.Element el = schema.lookupElement(elementName);
            EnumSet<EFlag> flags = EnumSet.noneOf(EFlag.class);
            if (el.isEndTagOptional()) {
                flags.add(EFlag.OPTIONAL_ENDTAG);
            }
            if (el.isEmpty()) {
                flags.add(EFlag.EMPTY);
            }
            if (elementName.isHtml()) {
                switch (HtmlTextEscapingMode.getModeForTag(elementName.localName)) {
                    case CDATA: {
                        flags.add(EFlag.CDATA);
                        break;
                    }
                    case RCDATA: {
                        flags.add(EFlag.RCDATA);
                        break;
                    }
                }
            }
            if (!schema.isElementAllowed(elementName)) {
                flags.add(EFlag.UNSAFE);
                if (SCRIPT.equals(elementName)) {
                    flags.add(EFlag.SCRIPT);
                } else if (STYLE.equals(elementName)) {
                    flags.add(EFlag.STYLE);
                }
            }
            if (HtmlSchema.isElementFoldable(elementName)) {
                flags.add(EFlag.FOLDABLE);
            }
            elementFlags.put(elementName, flags);
        }
        return elementFlags;
    }

    public static void main(String[] args) {
        HtmlSchema schema = HtmlSchema.getDefault(new SimpleMessageQueue());
        Block node = HtmlDefinitions.generateJavascriptDefinitions(schema);
        RenderContext rc = new RenderContext(node.makeRenderer(System.out, null));
        for (Statement statement : node.children()) {
            statement.render(rc);
            if (statement.isTerminal()) continue;
            rc.getOut().consume(";");
        }
        rc.getOut().noMoreTokens();
    }

    static {
        A_TYPE_MAP.put(HTML.Attribute.Type.NONE, 0);
        A_TYPE_MAP.put(HTML.Attribute.Type.URI, 1);
        A_TYPE_MAP.put(HTML.Attribute.Type.SCRIPT, 2);
        A_TYPE_MAP.put(HTML.Attribute.Type.STYLE, 3);
        A_TYPE_MAP.put(HTML.Attribute.Type.ID, 4);
        A_TYPE_MAP.put(HTML.Attribute.Type.IDREF, 5);
        A_TYPE_MAP.put(HTML.Attribute.Type.IDREFS, 6);
        A_TYPE_MAP.put(HTML.Attribute.Type.GLOBAL_NAME, 7);
        A_TYPE_MAP.put(HTML.Attribute.Type.LOCAL_NAME, 8);
        A_TYPE_MAP.put(HTML.Attribute.Type.CLASSES, 9);
        A_TYPE_MAP.put(HTML.Attribute.Type.FRAME_TARGET, 10);
        A_TYPE_MAP.put(HTML.Attribute.Type.URI_FRAGMENT, 11);
        for (HTML.Attribute.Type type : HTML.Attribute.Type.values()) {
            if (A_TYPE_MAP.containsKey((Object)type)) continue;
            throw new IllegalStateException("Not all Attribute Types mapped");
        }
        A_UEFFECT_MAP = new EnumMap<UriEffect, Integer>(UriEffect.class);
        A_UEFFECT_MAP.put(UriEffect.NOT_LOADED, 0);
        A_UEFFECT_MAP.put(UriEffect.SAME_DOCUMENT, 1);
        A_UEFFECT_MAP.put(UriEffect.NEW_DOCUMENT, 2);
        for (Enum enum_ : UriEffect.values()) {
            if (A_UEFFECT_MAP.containsKey(enum_)) continue;
            throw new IllegalStateException("Not all UriEffects mapped");
        }
        L_TYPE_MAP = new EnumMap<LoaderType, Integer>(LoaderType.class);
        L_TYPE_MAP.put(LoaderType.DATA, 0);
        L_TYPE_MAP.put(LoaderType.SANDBOXED, 1);
        L_TYPE_MAP.put(LoaderType.UNSANDBOXED, 2);
        for (Enum enum_ : LoaderType.values()) {
            if (L_TYPE_MAP.containsKey(enum_)) continue;
            throw new IllegalStateException("Not all Loader Types mapped");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements BuildCommand {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean build(List<File> inputs, List<File> deps, Map<String, Object> options, File output) throws IOException {
            HtmlSchema schema;
            File elementsFile = null;
            File attrsFile = null;
            for (File input : inputs) {
                if (!input.getName().endsWith(".json")) continue;
                if (elementsFile == null) {
                    elementsFile = input;
                    continue;
                }
                if (attrsFile == null) {
                    attrsFile = input;
                    continue;
                }
                throw new IOException("Unused input " + input);
            }
            if (elementsFile == null) {
                throw new IOException("No JSON whitelist for HTML elements");
            }
            if (attrsFile == null) {
                throw new IOException("No JSON whitelist for HTML attributes");
            }
            FilePosition elements = FilePosition.startOfFile(new InputSource(elementsFile.getAbsoluteFile().toURI()));
            FilePosition attrs = FilePosition.startOfFile(new InputSource(attrsFile.getAbsoluteFile().toURI()));
            MessageContext mc = new MessageContext();
            mc.addInputSource(elements.source());
            mc.addInputSource(attrs.source());
            EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter((Writer)new OutputStreamWriter(System.err), true), mc, false);
            HashSet<File> inputsAndDeps = new HashSet<File>();
            for (File f : inputs) {
                inputsAndDeps.add(f.getAbsoluteFile());
            }
            for (File f : deps) {
                inputsAndDeps.add(f.getAbsoluteFile());
            }
            AllowedFileResolver resolver = new AllowedFileResolver(inputsAndDeps);
            try {
                schema = new HtmlSchema(ConfigUtil.loadWhiteListFromJson(elements.source().getUri(), resolver, mq), ConfigUtil.loadWhiteListFromJson(attrs.source().getUri(), resolver, mq));
            }
            catch (ParseException ex) {
                ex.toMessageQueue(mq);
                throw (IOException)new IOException("Failed to parse schema").initCause(ex);
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8.name());
            String currentDate = "" + new Date();
            if (currentDate.indexOf("*/") >= 0) {
                throw new SomethingWidgyHappenedError("Date should not contain '*/'");
            }
            out.write("/* Copyright Google Inc.\n");
            out.write(" * Licensed under the Apache Licence Version 2.0\n");
            out.write(" * Autogenerated at " + currentDate + "\n");
            out.write(" * @provides html4\n");
            out.write(" */\n");
            try {
                Block node = HtmlDefinitions.generateJavascriptDefinitions(schema);
                RenderContext rc = new RenderContext(node.makeRenderer(out, null));
                for (Statement statement : node.children()) {
                    statement.render(rc);
                    if (statement.isTerminal()) continue;
                    rc.getOut().consume(";");
                }
                rc.getOut().noMoreTokens();
            }
            finally {
                ((Writer)out).close();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SchemaExtractor<Result> {
        public Result extract(HTML.Attribute var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EFlag {
        OPTIONAL_ENDTAG(1),
        EMPTY(2),
        CDATA(4),
        RCDATA(8),
        UNSAFE(16),
        FOLDABLE(32),
        SCRIPT(64),
        STYLE(128);

        public final int bitMask;

        private EFlag(int bitMask) {
            this.bitMask = bitMask;
        }
    }
}

