/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import javax.annotation.Nullable;

public final class InputSource
implements MessagePart,
Serializable {
    private static final long serialVersionUID = 7244581658470949868L;
    private URI uri;
    private String uriStr;
    public static final InputSource PREDEFINED = new InputSource(URI.create("predefined:///predefined"));
    public static final InputSource UNKNOWN = new InputSource(URI.create("unknown:///unknown"));

    public InputSource(File f) {
        this(f.getAbsoluteFile().toURI());
    }

    public InputSource(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException(uri.toString());
        }
        this.uri = uri;
        this.uriStr = uri.toString();
    }

    public URI getUri() {
        return this.uri;
    }

    public void format(MessageContext context, Appendable out) throws IOException {
        out.append(context.abbreviate(this));
    }

    public String toString() {
        return this.uriStr;
    }

    public boolean equals(@Nullable Object o) {
        return o instanceof InputSource && this.uri.equals(((InputSource)o).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

