/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.Html5ElementStack;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Sets;
import java.util.List;
import java.util.Set;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.TreeBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CajaTreeBuilder
extends TreeBuilder<Node> {
    static final boolean DEBUG = false;
    private static final String HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private Token<HtmlTokenType> startTok;
    private Token<HtmlTokenType> endTok;
    private Token<HtmlTokenType> pendingText;
    private Element rootElement;
    private FilePosition fragmentBounds;
    private final Set<Element> unpoppedElements = Sets.newHashSet();
    private final Document doc;
    final boolean needsDebugData;
    private final MessageQueue mq;

    CajaTreeBuilder(Document doc, boolean needsDebugData, MessageQueue mq) {
        this.setNamePolicy(XmlViolationPolicy.ALLOW);
        this.doc = doc;
        this.needsDebugData = needsDebugData;
        this.mq = mq;
        this.setIgnoringComments(false);
        this.setScriptingEnabled(true);
    }

    Element getRootElement() {
        return this.rootElement;
    }

    FilePosition getFragmentBounds() {
        return this.fragmentBounds;
    }

    FilePosition getErrorLocation() {
        if (!this.needsDebugData) {
            return FilePosition.UNKNOWN;
        }
        return this.startTok.pos != this.endTok.pos ? FilePosition.span(this.startTok.pos, this.endTok.pos) : this.startTok.pos;
    }

    boolean wasOpened(String htmlLocalName) {
        for (Node child = this.rootElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !Namespaces.isHtml(child.getNamespaceURI()) || !htmlLocalName.equals(child.getLocalName())) continue;
            return true;
        }
        return false;
    }

    void setTokenContext(Token<HtmlTokenType> start, Token<HtmlTokenType> end) {
        this.startTok = start;
        this.endTok = end;
        switch ((HtmlTokenType)this.startTok.type) {
            case TEXT: 
            case UNESCAPED: 
            case CDATA: {
                this.pendingText = this.startTok;
                break;
            }
        }
        if (this.fragmentBounds == null) {
            this.fragmentBounds = start.pos;
        }
    }

    void finish(FilePosition pos) {
        Token<HtmlTokenType> eofToken = Token.instance("", HtmlTokenType.IGNORABLE, pos);
        this.setTokenContext(eofToken, eofToken);
        if (this.needsDebugData) {
            this.fragmentBounds = FilePosition.span(this.fragmentBounds, pos);
        }
        try {
            this.eof();
        }
        catch (SAXException ex) {
            throw new SomethingWidgyHappenedError("Unexpected parsing error", (Throwable)ex);
        }
    }

    protected void appendCommentToDocument(char[] buf, int start, int length) {
        Node el = this.doc.getDocumentElement();
        if (null == el) {
            el = this.doc.createDocumentFragment();
            this.doc.appendChild(el);
        }
        this.appendComment(el, buf, start, length);
    }

    protected void appendComment(Node el, char[] buf, int start, int length) {
        Comment comment = this.doc.createComment(new String(buf, start, length));
        el.appendChild(comment);
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(comment, this.startTok.pos);
        }
    }

    protected void appendCharacters(Node n, char[] buf, int start, int length) {
        this.insertCharactersBefore(buf, start, length, null, n);
    }

    private void insertCharactersBefore(char[] buf, int start, int length, Node sibling, Node parent) {
        Node priorSibling = sibling != null ? sibling.getPreviousSibling() : parent.getLastChild();
        Token<HtmlTokenType> tok = this.pendingText;
        this.pendingText = null;
        String tokText = tok != null && CajaTreeBuilder.bufferMatches(buf, start, length, tok.text) ? tok.text : String.valueOf(buf, start, length);
        FilePosition pos = this.startTok.pos;
        String htmlText = null;
        String plainText = tokText;
        if (tok != null) {
            switch ((HtmlTokenType)tok.type) {
                case TEXT: {
                    pos = tok.pos;
                    htmlText = tokText;
                    plainText = Nodes.decode(htmlText);
                    break;
                }
                case UNESCAPED: 
                case CDATA: {
                    pos = tok.pos;
                    plainText = htmlText = tokText;
                    break;
                }
            }
        }
        if (this.needsDebugData && htmlText == null) {
            htmlText = Nodes.encode(plainText);
        }
        if (priorSibling != null && priorSibling.getNodeType() == 3) {
            Text prevText = (Text)priorSibling;
            String prevTextContent = prevText.getTextContent();
            StringBuilder sb = new StringBuilder(prevTextContent.length() + length);
            sb.append(prevTextContent).append(buf, start, length);
            Text combined = this.doc.createTextNode(sb.toString());
            if (this.needsDebugData) {
                Nodes.setFilePositionFor(combined, FilePosition.span(Nodes.getFilePositionFor(priorSibling), pos));
                Nodes.setRawText(combined, Nodes.getRawText(prevText) + htmlText);
            }
            parent.replaceChild(combined, priorSibling);
            return;
        }
        Text text = this.doc.createTextNode(plainText);
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(text, pos);
            Nodes.setRawText(text, htmlText);
        }
        parent.insertBefore(text, sibling);
    }

    protected void addAttributesToElement(Node node, HtmlAttributes attributes) {
        Element el = (Element)node;
        List<Attr> associatedAttrs = Html5ElementStack.getAssociatedAttrs(attributes);
        int n = associatedAttrs.size();
        if (n != 0) {
            boolean hasXmlnsDeclaration;
            boolean bl = hasXmlnsDeclaration = associatedAttrs.get(n - 1) == Html5ElementStack.XMLNS_ATTR_MARKER;
            if (hasXmlnsDeclaration) {
                Nodes.markAsHavingXmlnsDeclaration(el);
                --n;
            }
            for (int j = 0; j < n; ++j) {
                Attr a = associatedAttrs.get(j);
                if (!el.hasAttributeNS(a.getNamespaceURI(), a.getLocalName())) {
                    el.setAttributeNodeNS(a);
                    continue;
                }
                String name = a.getName();
                this.mq.addMessage((MessageTypeInt)MessageType.DUPLICATE_ATTRIBUTE, Nodes.getFilePositionFor(a), MessagePart.Factory.valueOf(name), Nodes.getFilePositionFor(el.getAttributeNodeNS(a.getNamespaceURI(), a.getLocalName())));
            }
        }
        if (attributes.getLength() != 0) {
            FilePosition pos = this.needsDebugData ? FilePosition.startOf(Nodes.getFilePositionFor(el)) : null;
            String elNs = el.getNamespaceURI();
            int n2 = attributes.getLength();
            for (int i = 0; i < n2; ++i) {
                String localName;
                boolean isNamespaced;
                String name = attributes.getQName(i);
                String ns = attributes.getURI(i);
                if ("".equals(ns)) {
                    ns = elNs;
                }
                boolean bl = isNamespaced = !name.startsWith("f:");
                if (isNamespaced ? el.hasAttributeNS(ns, localName = attributes.getLocalName(i)) : el.hasAttribute(name)) continue;
                String value = attributes.getValue(i);
                Attr a = this.doc.createAttributeNS(ns, name);
                a.setValue(value);
                if (pos != null) {
                    Nodes.setFilePositionFor(a, pos);
                    Nodes.setFilePositionForValue(a, pos);
                }
                el.setAttributeNodeNS(a);
            }
        }
    }

    protected void appendElement(Node child, Node parent) {
        parent.appendChild(child);
    }

    protected void appendChildrenToNewParent(Node oldParent, Node newParent) {
        Node child;
        while ((child = oldParent.getFirstChild()) != null) {
            newParent.appendChild(child);
        }
    }

    protected void insertFosterParentedChild(Node child, Node table, Node stackParent) {
        stackParent.insertBefore(child, table);
    }

    protected void insertFosterParentedCharacters(char[] buf, int start, int length, Node table, Node stackParent) {
        this.insertCharactersBefore(buf, start, length, table, stackParent);
    }

    protected Node shallowClone(Node node) {
        Node clone = node.cloneNode(false);
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(clone, Nodes.getFilePositionFor(node));
        }
        switch (node.getNodeType()) {
            case 2: {
                if (!this.needsDebugData) break;
                Nodes.setFilePositionForValue((Attr)clone, Nodes.getFilePositionForValue((Attr)node));
                break;
            }
            case 1: {
                Element el = (Element)node;
                Element cloneEl = (Element)clone;
                NamedNodeMap attrs = el.getAttributes();
                int n = attrs.getLength();
                for (int i = 0; i < n; ++i) {
                    Attr a = (Attr)attrs.item(i);
                    Attr cloneA = cloneEl.getAttributeNodeNS(a.getNamespaceURI(), a.getLocalName());
                    if (!this.needsDebugData) continue;
                    Nodes.setFilePositionFor(cloneA, Nodes.getFilePositionFor(a));
                    Nodes.setFilePositionForValue(cloneA, Nodes.getFilePositionForValue(a));
                }
                break;
            }
            case 3: 
            case 4: {
                if (!this.needsDebugData) break;
                Text t = (Text)node;
                Nodes.setRawText(t, Nodes.getRawText(t));
            }
        }
        return clone;
    }

    protected boolean hasChildren(Node node) {
        return node.getFirstChild() != null;
    }

    protected void detachFromParent(Node node) {
        node.getParentNode().removeChild(node);
    }

    protected Element createHtmlElementSetAsRoot(HtmlAttributes attributes) {
        Element documentElement;
        this.rootElement = documentElement = this.createElement(HTML_NAMESPACE, "html", attributes);
        return documentElement;
    }

    protected Element createElement(String ns, String localName, HtmlAttributes attributes) {
        Element el = (localName = localName.intern()).indexOf(58) < 0 ? this.doc.createElementNS(HTML_NAMESPACE, localName) : this.doc.createElement(localName);
        this.addAttributesToElement(el, attributes);
        if (this.needsDebugData) {
            FilePosition pos = this.startTok == null ? null : (this.startTok.type == HtmlTokenType.TAGBEGIN && CajaTreeBuilder.tagMatchesElementName(CajaTreeBuilder.tagName(this.startTok.text), localName) ? FilePosition.span(this.startTok.pos, this.endTok.pos) : FilePosition.startOf(this.startTok.pos));
            Nodes.setFilePositionFor(el, pos);
        }
        return el;
    }

    protected void elementPopped(String ns, String name, Node node) {
        boolean removed = this.unpoppedElements.remove(node);
        if (this.needsDebugData) {
            Node last;
            Node first;
            name = Html5ElementStack.canonicalElementName(name);
            FilePosition endPos = this.startTok.type == HtmlTokenType.TAGBEGIN && (CajaTreeBuilder.isEndTag(this.startTok.text) || "select".equals(name)) && CajaTreeBuilder.tagCloses(CajaTreeBuilder.tagName(this.startTok.text), name) ? this.endTok.pos : FilePosition.startOf(this.startTok.pos);
            FilePosition startPos = Nodes.getFilePositionFor(node);
            if (startPos.source().equals(InputSource.UNKNOWN) && (first = node.getFirstChild()) != null) {
                startPos = Nodes.getFilePositionFor(first);
            }
            FilePosition lastPos = startPos;
            for (last = node.getLastChild(); last != null && last.getNodeType() == 3 && CajaTreeBuilder.isWhitespace(last.getNodeValue()); last = last.getPreviousSibling()) {
            }
            if (last != null) {
                lastPos = Nodes.getFilePositionFor(last);
            }
            if (endPos.endCharInFile() >= lastPos.endCharInFile() && (removed || lastPos.endCharInFile() > startPos.endCharInFile())) {
                Nodes.setFilePositionFor(node, FilePosition.span(startPos, endPos));
            }
        }
    }

    private static boolean isWhitespace(String s) {
        int i = s.length();
        block3: while (--i >= 0) {
            switch (s.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            return false;
        }
        return true;
    }

    protected void bodyClosed() {
        for (Element unpopped : this.unpoppedElements) {
            if (!"body".equals(unpopped.getTagName()) || !HTML_NAMESPACE.equals(unpopped.getNamespaceURI())) continue;
            this.elementPopped(HTML_NAMESPACE, "body", unpopped);
            return;
        }
    }

    protected void headClosed() {
        for (Element unpopped : this.unpoppedElements) {
            if (!"head".equals(unpopped.getTagName()) || !HTML_NAMESPACE.equals(unpopped.getNamespaceURI())) continue;
            this.elementPopped(HTML_NAMESPACE, "head", unpopped);
            return;
        }
    }

    protected void htmlClosed(Node html) {
        this.elementPopped(HTML_NAMESPACE, "html", html);
    }

    protected void elementPushed(String ns, String name, Node node) {
        this.unpoppedElements.add((Element)node);
    }

    void closeUnclosedNodes() {
        if (this.needsDebugData) {
            for (Element node : this.unpoppedElements) {
                Nodes.setFilePositionFor(node, FilePosition.span(Nodes.getFilePositionFor(node), this.endTok.pos));
            }
        }
        this.unpoppedElements.clear();
    }

    private static boolean bufferMatches(char[] buf, int start, int len, String s) {
        if (len != s.length()) {
            return false;
        }
        int i = len;
        while (--i >= 0) {
            if (s.charAt(i) == buf[start + i]) continue;
            return false;
        }
        return true;
    }

    static boolean isEndTag(String tokenText) {
        return tokenText.length() >= 2 && tokenText.charAt(1) == '/';
    }

    private static String tagName(String tokenText) {
        String name = tokenText.substring(CajaTreeBuilder.isEndTag(tokenText) ? 2 : 1);
        return Html5ElementStack.canonicalElementName(name.intern());
    }

    static boolean tagMatchesElementName(String tagName, String elementName) {
        return tagName.equals(elementName) || tagName.equals("image") && elementName.equals("img");
    }

    static boolean tagCloses(String tagName, String elementName) {
        return CajaTreeBuilder.tagMatchesElementName(tagName, elementName) || CajaTreeBuilder.isHeading(tagName) && CajaTreeBuilder.isHeading(elementName);
    }

    static boolean isHeading(String tagName) {
        if (tagName.length() != 2 || 'h' != tagName.charAt(0)) {
            return false;
        }
        char ch1 = tagName.charAt(1);
        return ch1 >= '1' && ch1 <= '6';
    }
}

