/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.PositionInferer;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.TokenStream;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.reporting.DevNullMessageQueue;
import com.google.caja.util.Maps;
import com.google.caja.util.Sets;
import com.google.caja.util.Strings;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlQuasiBuilder {
    private static Map<String, Node> QUASI_CACHE = Collections.synchronizedMap(new LinkedHashMap<String, Node>(){
        private static final long serialVersionUID = 5261642907670842806L;

        @Override
        public boolean removeEldestEntry(Map.Entry<String, Node> eldest) {
            return this.size() > 100;
        }
    });
    private final Document doc;
    private static final Set<String> PROBLEMATIC_TAGS = Sets.newHashSet("<thead", "<tbody", "<tfoot", "<caption", "<tr", "<td", "<th", "<option");
    private static final Pattern QUASI_PATTERN = Pattern.compile("@(?:([a-zA-Z][a-zA-Z0-9_]*) ?|@)");

    private HtmlQuasiBuilder(Document doc) {
        this.doc = doc;
    }

    public static final HtmlQuasiBuilder getBuilder(Document doc) {
        return new HtmlQuasiBuilder(doc);
    }

    public Node substV(String quasiHtml, Object ... bindings) {
        Node quasi = QUASI_CACHE.get(quasiHtml);
        if (quasi == null) {
            try {
                boolean isProblematic;
                CharProducer cp = CharProducer.Factory.fromString((CharSequence)quasiHtml, InputSource.UNKNOWN);
                TokenQueue<HtmlTokenType> tq = new TokenQueue<HtmlTokenType>(new HtmlLexer(cp.clone()), InputSource.UNKNOWN, DomParser.SKIP_COMMENTS);
                boolean isDocument = false;
                TokenQueue.Mark m = tq.mark();
                Token<HtmlTokenType> firstTag = null;
                while (!tq.isEmpty()) {
                    Token<HtmlTokenType> t = tq.pop();
                    if (t.type != HtmlTokenType.TAGBEGIN) continue;
                    if (firstTag == null) {
                        firstTag = t;
                    }
                    if (!Strings.equalsIgnoreCase("<html", t.text)) continue;
                    isDocument = true;
                    break;
                }
                boolean bl = isProblematic = !isDocument && firstTag != null && PROBLEMATIC_TAGS.contains(Strings.toLowerCase(firstTag.text));
                if (isProblematic) {
                    final HtmlLexer lexer = new HtmlLexer(cp);
                    TokenStream<HtmlTokenType> caseFilter = new TokenStream<HtmlTokenType>(){

                        @Override
                        public boolean hasNext() throws ParseException {
                            return lexer.hasNext();
                        }

                        @Override
                        public Token<HtmlTokenType> next() throws ParseException {
                            Token<HtmlTokenType> t = lexer.next();
                            switch ((HtmlTokenType)t.type) {
                                case TAGBEGIN: 
                                case TAGEND: 
                                case ATTRNAME: {
                                    if (t.text.contains(":")) break;
                                    t = Token.instance(Strings.toLowerCase(t.text), t.type, t.pos);
                                    break;
                                }
                            }
                            return t;
                        }
                    };
                    tq = new TokenQueue<HtmlTokenType>(caseFilter, InputSource.UNKNOWN, DomParser.SKIP_COMMENTS);
                } else {
                    tq.rewind(m);
                }
                DomParser p = new DomParser(tq, isProblematic, DevNullMessageQueue.singleton());
                quasi = isDocument ? p.parseDocument() : p.parseFragment();
            }
            catch (ParseException ex) {
                throw new SomethingWidgyHappenedError("Malformed Quasiliteral : " + quasiHtml, (Throwable)ex);
            }
            QUASI_CACHE.put(quasiHtml, quasi);
        }
        Map<String, Object> bindingMap = Maps.newHashMap();
        int n = bindings.length;
        for (int i = 0; i < n; i += 2) {
            bindingMap.put((String)bindings[i], bindings[i + 1]);
        }
        return this.subst(quasi, bindingMap);
    }

    public DocumentFragment toFragment(String html) throws ParseException {
        try {
            return new DomParser(DomParser.makeTokenQueue(FilePosition.startOfFile(InputSource.UNKNOWN), (Reader)new StringReader(html), false, false), false, DevNullMessageQueue.singleton()).parseFragment(this.doc);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("Can't drain StringReader", (Throwable)ex);
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public static void usePosition(FilePosition pos, Node node) {
        if (InputSource.UNKNOWN.equals(Nodes.getFilePositionFor(node).source())) {
            Nodes.setFilePositionFor(node, pos);
        }
        PositionInferer inferer = new PositionInferer(pos){

            protected FilePosition getPosForNode(Object o) {
                return Nodes.getFilePositionFor((Node)o);
            }

            protected void setPosForNode(Object o, FilePosition pos) {
                Node n = (Node)o;
                FilePosition old = Nodes.getFilePositionFor(n);
                if (InputSource.UNKNOWN.equals(old.source())) {
                    Nodes.setFilePositionFor((Node)o, pos);
                }
            }
        };
        HtmlQuasiBuilder.addRelations(node, true, inferer);
        inferer.solve();
    }

    private static void addRelations(Node n, boolean isRoot, PositionInferer inferer) {
        Node next;
        if (n instanceof Element) {
            Node firstChild = n.getFirstChild();
            for (Attr attr : Nodes.attributesOf((Element)n)) {
                inferer.contains(n, attr);
                inferer.precedes(attr, attr.getFirstChild());
                if (firstChild == null) continue;
                inferer.precedes(attr, firstChild);
            }
        }
        for (Node node : Nodes.childrenOf(n)) {
            inferer.contains(n, node);
            HtmlQuasiBuilder.addRelations(node, false, inferer);
        }
        if (!isRoot && (next = n.getNextSibling()) != null) {
            inferer.adjacent(n, next);
        }
    }

    private Node subst(Node quasiNode, Map<String, ?> bindings) {
        switch (quasiNode.getNodeType()) {
            case 2: {
                return this.substAttrib((Attr)quasiNode, bindings);
            }
            case 11: {
                DocumentFragment f = this.doc.createDocumentFragment();
                this.expandAll(quasiNode, bindings, f);
                return f;
            }
            case 1: {
                Element el = (Element)quasiNode;
                if ("body".equals(el.getLocalName()) && "http://www.w3.org/1999/xhtml".equals(el.getNamespaceURI())) {
                    return this.substBody(el, bindings);
                }
                return this.substElement(el, bindings);
            }
            case 3: {
                return this.substText((Text)quasiNode, bindings);
            }
        }
        return this.doc.importNode(quasiNode, true);
    }

    private void expandAll(Node quasi, Map<String, ?> bindings, Node parent) {
        for (Node c = quasi.getFirstChild(); c != null; c = c.getNextSibling()) {
            Node substitute = this.subst(c, bindings);
            HtmlQuasiBuilder.flattenOnto(substitute, parent);
        }
    }

    private Node substText(Text t, Map<String, ?> bindings) {
        String unescaped = Nodes.getRawText(t);
        Matcher m = QUASI_PATTERN.matcher(unescaped);
        if (!m.find()) {
            Node result = this.doc.importNode(t, true);
            HtmlQuasiBuilder.copyFilePositions(t, result);
            return result;
        }
        DocumentFragment parts = this.doc.createDocumentFragment();
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        do {
            sb.append(unescaped, pos, m.start());
            pos = m.end();
            String quasiIdentifier = m.group(1);
            if (quasiIdentifier == null) {
                sb.append('@');
                continue;
            }
            Object binding = bindings.get(quasiIdentifier);
            if (binding instanceof String) {
                Escaping.escapeXml((CharSequence)((String)binding), false, sb);
                continue;
            }
            if (sb.length() != 0) {
                parts.appendChild(this.doc.createTextNode(Nodes.decode(sb.toString())));
                sb.setLength(0);
            }
            Node bindingNode = (Node)binding;
            Node imported = this.doc.importNode(bindingNode, true);
            HtmlQuasiBuilder.copyFilePositions(bindingNode, imported);
            HtmlQuasiBuilder.flattenOnto(imported, parts);
        } while (m.find());
        sb.append(unescaped, pos, unescaped.length());
        if (sb.length() != 0) {
            parts.appendChild(this.doc.createTextNode(Nodes.decode(sb.toString())));
        }
        if (parts.getFirstChild() != null && parts.getFirstChild().getNextSibling() == null) {
            return parts.getFirstChild();
        }
        return parts;
    }

    private Attr substAttrib(Attr a, Map<String, ?> bindings) {
        String oldValue = Nodes.getRawValue(a);
        String quasiIdentifier = HtmlQuasiBuilder.singleIdentifier(HtmlQuasiBuilder.dequote(oldValue));
        String uri = a.getNamespaceURI();
        String qname = a.getName();
        if (quasiIdentifier != null) {
            Object binding = bindings.get(quasiIdentifier);
            if (binding instanceof Boolean) {
                boolean present = (Boolean)binding;
                if (!present) {
                    return null;
                }
                Attr result = this.doc.createAttributeNS(uri, qname);
                result.setNodeValue(result.getName());
                return result;
            }
            if (binding instanceof Attr) {
                Attr bindingAttr = (Attr)binding;
                Attr result = this.doc.createAttributeNS(uri, qname);
                result.setNodeValue(bindingAttr.getNodeValue());
                HtmlQuasiBuilder.copyFilePositions(bindingAttr, result);
                return result;
            }
        }
        Attr result = this.doc.createAttributeNS(uri, qname);
        result.setNodeValue(HtmlQuasiBuilder.substAttrValue(oldValue, bindings));
        return result;
    }

    private static String substAttrValue(String rawText, Map<String, ?> bindings) {
        String unescaped = Nodes.decode(HtmlQuasiBuilder.dequote(rawText));
        Matcher m = QUASI_PATTERN.matcher(unescaped);
        if (!m.find()) {
            return unescaped;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        do {
            sb.append(unescaped, pos, m.start());
            pos = m.end();
            String quasiIdentifier = m.group(1);
            if (quasiIdentifier == null) {
                sb.append('@');
                continue;
            }
            Object binding = bindings.get(quasiIdentifier);
            if (!(binding instanceof String)) {
                throw new ClassCastException("@" + quasiIdentifier);
            }
            Escaping.escapeXml((CharSequence)((String)binding), false, sb);
        } while (m.find());
        sb.append(unescaped, pos, unescaped.length());
        return Nodes.decode(sb.toString());
    }

    private Element substElement(Element e, Map<String, ?> bindings) {
        Element result = this.doc.createElementNS(e.getNamespaceURI(), e.getTagName());
        for (Attr attr : Nodes.attributesOf(e)) {
            Attr newAttr = this.substAttrib(attr, bindings);
            if (newAttr == null) continue;
            result.setAttributeNodeNS(newAttr);
        }
        this.expandAll(e, bindings, result);
        return result;
    }

    private Element substBody(Element e, Map<String, ?> bindings) {
        String unescaped;
        String quasiIdentifier;
        Node firstChild = e.getFirstChild();
        if (firstChild instanceof Text && firstChild.getNextSibling() == null && (quasiIdentifier = HtmlQuasiBuilder.singleIdentifier(unescaped = Nodes.getRawText((Text)firstChild))) != null) {
            Element bindingEl;
            DocumentFragment f;
            Node fFirstChild;
            Object binding = bindings.get(quasiIdentifier);
            if (binding instanceof DocumentFragment && (fFirstChild = (f = (DocumentFragment)binding).getFirstChild()) != null && fFirstChild.getNextSibling() == null) {
                binding = fFirstChild;
            }
            if (binding instanceof Element && "frameset".equals((bindingEl = (Element)binding).getLocalName()) && "http://www.w3.org/1999/xhtml".equals(bindingEl.getNamespaceURI())) {
                Element result = (Element)this.doc.importNode(bindingEl, true);
                HtmlQuasiBuilder.copyFilePositions(bindingEl, result);
                return result;
            }
        }
        return this.substElement(e, bindings);
    }

    private static void flattenOnto(Node toAdd, Node parent) {
        if (toAdd instanceof DocumentFragment) {
            Node c = toAdd.getFirstChild();
            while (c != null) {
                Node next = c.getNextSibling();
                parent.appendChild(c);
                c = next;
            }
        } else {
            parent.appendChild(toAdd);
        }
    }

    private static String singleIdentifier(String unescaped) {
        Matcher m = QUASI_PATTERN.matcher(unescaped.trim());
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    private static String dequote(String rawAttributeValue) {
        char chn;
        int start = 0;
        int end = rawAttributeValue.length();
        if (end > 0 && ((chn = rawAttributeValue.charAt(end - 1)) == '\"' || chn == '\'') && start < --end && rawAttributeValue.charAt(0) == chn) {
            ++start;
        }
        return rawAttributeValue.substring(start, end);
    }

    private static void copyFilePositions(Node from, Node to) {
        Nodes.setFilePositionFor(to, Nodes.getFilePositionFor(from));
        Node fromChild = from.getFirstChild();
        Node toChild = to.getFirstChild();
        while (fromChild != null) {
            HtmlQuasiBuilder.copyFilePositions(fromChild, toChild);
            fromChild = fromChild.getNextSibling();
            toChild = toChild.getNextSibling();
        }
    }
}

