/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.render.SourceSpansRenderer;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import com.google.caja.util.Lists;
import com.google.javascript.jscomp.jsonml.JsonML;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CajoledModule
extends AbstractParseTreeNode
implements JsonMLCompatible,
Serializable {
    private static final long serialVersionUID = -2499144011243193616L;
    private static final InputSource CAJOLED_OUTPUT_FILE_NAME = new InputSource(URI.create("file:///CAJOLED-OUTPUT"));

    @ParseTreeNode.ReflectiveCtor
    public CajoledModule(FilePosition pos, Void value, List<? extends ObjectConstructor> children) {
        this(pos, children.get(0));
        assert (children.size() == 1);
    }

    public CajoledModule(FilePosition pos, ObjectConstructor body) {
        super(pos, ObjectConstructor.class);
        this.createMutation().appendChild(body).execute();
    }

    public CajoledModule(ObjectConstructor body) {
        this(body.getFilePosition(), body);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        if (this.children().size() != 1 && this.getModuleBody() != null) {
            throw new IllegalStateException("A CajoledModule may only have one child");
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    public List<? extends ObjectConstructor> children() {
        return this.childrenAs(ObjectConstructor.class);
    }

    public ObjectConstructor getModuleBody() {
        return this.children().get(0);
    }

    public String getSrc() {
        ValueProperty p = (ValueProperty)this.getModuleBody().propertyWithName("src");
        if (p == null) {
            return null;
        }
        return ((StringLiteral)p.getValueExpr()).getUnquotedValue();
    }

    public ArrayConstructor getIncludedModules() {
        ValueProperty p = (ValueProperty)this.getModuleBody().propertyWithName("includedModules");
        return p != null ? (ArrayConstructor)p.getValueExpr() : null;
    }

    public ArrayConstructor getInlinedModules() {
        ValueProperty p = (ValueProperty)this.getModuleBody().propertyWithName("inlinedModules");
        return p != null ? (ArrayConstructor)p.getValueExpr() : null;
    }

    public FunctionConstructor getInstantiateMethod() {
        return (FunctionConstructor)((ValueProperty)this.getModuleBody().propertyWithName("instantiate")).getValueExpr();
    }

    @Override
    public final TokenConsumer makeRenderer(Appendable out, Callback<IOException> exHandler) {
        return new JsPrettyPrinter(new Concatenator(out, exHandler));
    }

    @Override
    public void render(RenderContext rc) {
        this.renderModuleExpression((Expression)QuasiBuilder.substV("___.loadModule(@body)", "body", this.getModuleBody()), rc);
    }

    @Override
    public JsonML toJsonML() {
        Expression loadModuleCall = (Expression)QuasiBuilder.substV("___.loadModule(@body)", "body", this.getModuleBody());
        Block program = new Block(loadModuleCall.getFilePosition(), Collections.singletonList(new ExpressionStmt(loadModuleCall)));
        return program.toJsonMLAsProgram();
    }

    public void render(Expression callbackExpression, RenderContext rc) {
        if (callbackExpression == null) {
            this.render(rc);
        } else {
            this.renderModuleExpression((Expression)QuasiBuilder.substV("@callbackExpression(___.prepareModule(@body))", "callbackExpression", callbackExpression, "body", this.getModuleBody()), rc);
        }
    }

    private void renderModuleExpression(Expression expr, RenderContext rc) {
        Block block = new Block(FilePosition.UNKNOWN, Arrays.asList(new ExpressionStmt(FilePosition.UNKNOWN, expr)));
        block.render(rc);
    }

    public void renderWithDebugSymbols(Map<InputSource, CharSequence> originalSources, RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.consume("{ ___.loadModule({\n");
        this.renderModuleBodyWithDebugSymbols(originalSources, rc);
        out.consume("}); }\n");
    }

    public void renderWithDebugSymbols(Expression callbackExpression, Map<InputSource, CharSequence> originalSources, RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.consume("{");
        CajoledModule.renderNode(callbackExpression, rc);
        out.consume("(___.prepareModule({\n");
        this.renderModuleBodyWithDebugSymbols(originalSources, rc);
        out.consume("}));}\n");
    }

    private void renderModuleBodyWithDebugSymbols(Map<InputSource, CharSequence> originalSources, RenderContext rc) {
        SourceSpansRenderer ssr = new SourceSpansRenderer(CAJOLED_OUTPUT_FILE_NAME, rc);
        RenderContext ssrrc = new RenderContext(ssr).withAsciiOnly(rc.isAsciiOnly()).withEmbeddable(rc.isEmbeddable());
        ((ValueProperty)this.getModuleBody().propertyWithName("instantiate")).getValueExpr().render(ssrrc);
        ssr.noMoreTokens();
        List<String> abbreviatedOriginalFileNames = Lists.newArrayList();
        List<List<String>> originalFileContents = Lists.newArrayList();
        for (InputSource is : ssr.getMessageContext().getInputSources()) {
            String sourceString = CajoledModule.charSequenceToString(originalSources.get(is));
            List<String> lines = Arrays.asList(sourceString.split("\r\n?|\n"));
            abbreviatedOriginalFileNames.add(ssr.getMessageContext().abbreviate(is));
            originalFileContents.add(lines);
        }
        CajoledModule.renderText(this.getModuleBody(), ssr.getProgramText(), ssr.getSourceLocationMap(), abbreviatedOriginalFileNames, originalFileContents, rc);
    }

    private static void renderText(ObjectConstructor moduleBody, String instantiateFunctionText, List<String> sourceLocationMap, List<String> abbreviatedOriginalFileNames, List<List<String>> originalFileContents, RenderContext rc) {
        TokenConsumer out = rc.getOut();
        CajoledModule.renderNode(CajoledModule.stringToStringLiteral("instantiate"), rc);
        out.consume(":\n");
        out.consume(instantiateFunctionText);
        out.consume(",\n");
        List<? extends ObjProperty> moduleBodyProps = moduleBody.children();
        for (ObjProperty objProperty : moduleBodyProps) {
            if ("instantiate".equals(objProperty.getPropertyName())) continue;
            CajoledModule.renderNode(objProperty.getPropertyNameNode(), rc);
            out.consume(": ");
            Expression valueExpr = ((ValueProperty)objProperty).getValueExpr();
            if (Operation.is((ParseTreeNode)valueExpr, Operator.COMMA)) {
                out.consume("(");
                CajoledModule.renderNode(valueExpr, rc);
                out.consume(")");
            } else {
                CajoledModule.renderNode(valueExpr, rc);
            }
            out.consume(",\n");
        }
        CajoledModule.renderNode(CajoledModule.stringToStringLiteral("sourceLocationMap"), rc);
        out.consume(": ");
        CajoledModule.renderNode(CajoledModule.stringListToContentNode(sourceLocationMap), rc);
        out.consume(",\n");
        CajoledModule.renderNode(CajoledModule.stringToStringLiteral("originalSource"), rc);
        out.consume(": ");
        CajoledModule.renderNode(CajoledModule.buildOriginalSourceNode(abbreviatedOriginalFileNames, originalFileContents), rc);
        out.consume("\n");
    }

    private static ParseTreeNode buildOriginalSourceNode(List<String> abbreviatedOriginalFileNames, List<List<String>> originalFileContents) {
        return QuasiBuilder.substV("({ @keys*: @values* })", "keys", CajoledModule.stringListToStringLiterals(abbreviatedOriginalFileNames), "values", CajoledModule.stringListListToMultipleContentNodes(originalFileContents));
    }

    private static ParseTreeNode stringListListToMultipleContentNodes(List<List<String>> contents) {
        List<ParseTreeNode> multipleContents = Lists.newArrayList(contents.size());
        for (List<String> c : contents) {
            multipleContents.add(CajoledModule.stringListToContentNode(c));
        }
        return new ParseTreeNodeContainer(multipleContents);
    }

    private static ParseTreeNode stringListToContentNode(List<String> lines) {
        return QuasiBuilder.substV("  ({  type: 'content',  content: [ @stringLiterals* ]})", "stringLiterals", CajoledModule.stringListToStringLiterals(lines));
    }

    private static ParseTreeNode stringListToStringLiterals(List<String> strings) {
        List<ParseTreeNode> stringLiterals = Lists.newArrayList(strings.size());
        for (String s : strings) {
            stringLiterals.add(CajoledModule.stringToStringLiteral(s));
        }
        return new ParseTreeNodeContainer(stringLiterals);
    }

    private static ParseTreeNode stringToStringLiteral(String s) {
        return StringLiteral.valueOf(FilePosition.UNKNOWN, s);
    }

    private static String charSequenceToString(CharSequence cs) {
        return cs instanceof String ? (String)cs : "" + cs;
    }

    private static void renderNode(ParseTreeNode node, RenderContext rc) {
        JsPrettyPrinter tc = new JsPrettyPrinter((Concatenator)rc.getOut());
        node.render(new RenderContext(tc).withAsciiOnly(rc.isAsciiOnly()).withEmbeddable(rc.isEmbeddable()));
        tc.noMoreTokens();
    }
}

