/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Declaration
extends AbstractStatement {
    private static final long serialVersionUID = 8412211687133669346L;
    private Identifier identifier;
    private Expression initializer;

    @ParseTreeNode.ReflectiveCtor
    public Declaration(FilePosition pos, Void value, List<? extends ParseTreeNode> children) {
        super(pos, ParseTreeNode.class);
        this.createMutation().appendChildren(children).execute();
    }

    public Declaration(FilePosition pos, Identifier identifier, Expression initializer) {
        super(pos, ParseTreeNode.class);
        MutableParseTreeNode.Mutation m = this.createMutation();
        m.appendChild(identifier);
        if (null != initializer) {
            m.appendChild(initializer);
        }
        m.execute();
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        List<? extends ParseTreeNode> children = this.children();
        this.identifier = (Identifier)children.get(0);
        if (this.identifier.getName() == null) {
            throw new NullPointerException();
        }
        Expression expression = this.initializer = children.size() > 1 ? (Expression)children.get(1) : null;
        if (children.size() > 2) {
            throw new IllegalArgumentException("Declaration has extraneous children " + children.subList(2, children.size()));
        }
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getIdentifierName() {
        return this.identifier.getName();
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        out.consume("var");
        this.renderShort(rc);
    }

    void renderShort(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        if (this.identifier.getName() == null) {
            throw new IllegalStateException("null name for declaration at " + this.getFilePosition());
        }
        this.identifier.render(rc);
        if (null != this.initializer) {
            out.consume("=");
            boolean isComma = Operation.is((ParseTreeNode)this.initializer, Operator.COMMA);
            if (isComma) {
                out.consume("(");
            }
            this.initializer.render(rc);
            if (isComma) {
                out.consume(")");
            }
        }
    }

    @Override
    public boolean hasHangingConditional() {
        return false;
    }

    @Override
    public JsonML toJsonML() {
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.VarDecl, this.getFilePosition()).addChild(this.toInitOrIdPatt()).build();
    }

    JsonML toInitOrIdPatt() {
        Expression initializer = this.getInitializer();
        JsonML id = this.getIdentifier().toJsonML();
        if (initializer != null) {
            return JsonMLCompatible.JsonMLBuilder.builder(TagType.InitPatt, this.getFilePosition()).addChild(id).addChild(initializer).build();
        }
        return id;
    }
}

