/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LabeledStatement
extends AbstractStatement {
    private static final long serialVersionUID = -1825047573111985986L;
    private final String label;

    protected LabeledStatement(FilePosition pos, String label, Class<? extends ParseTreeNode> childClass) {
        super(pos, childClass);
        assert (label != null);
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public abstract boolean isTargetForContinue();

    @Override
    public void breaks(Map<String, List<BreakStmt>> labels) {
        super.breaks(labels);
        labels.remove(this.label);
    }

    @Override
    public void continues(Map<String, List<ContinueStmt>> labels) {
        super.continues(labels);
        labels.remove(this.label);
    }

    @Override
    public final Object getValue() {
        return this.label;
    }

    protected final String getRenderedLabel(RenderContext rc) {
        if (this.label == null || "".equals(this.label)) {
            return null;
        }
        StringBuilder escapedLabel = new StringBuilder();
        Escaping.escapeJsIdentifier((CharSequence)this.label, rc.isAsciiOnly(), escapedLabel);
        return escapedLabel.toString();
    }

    protected JsonML wrapIfLabelled(JsonML unlabelled) {
        if (this.label == null || "".equals(this.label)) {
            return unlabelled;
        }
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.LabelledStmt, this.getFilePosition()).setAttribute(TagAttr.LABEL, this.label).addChild(unlabelled).build();
    }
}

