/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Literal;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringLiteral
extends Literal {
    private static final long serialVersionUID = 6251403659182707540L;
    private final String value;
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("\\\\(?:u([0-9A-Fa-f]{4})|([0-3][0-7]{0,2}|[4-7][0-7]?)|(?:x([0-9A-Fa-f]{2}))|([^u0-7]))");

    @ParseTreeNode.ReflectiveCtor
    public StringLiteral(FilePosition pos, String value, List<? extends ParseTreeNode> children) {
        this(pos, value);
    }

    public StringLiteral(FilePosition pos, String value) {
        super(pos);
        if (null == value) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean getValueInBooleanContext() {
        return !"".equals(this.getUnquotedValue());
    }

    @Override
    public void render(RenderContext rc) {
        rc.getOut().mark(this.getFilePosition());
        StringLiteral.renderUnquotedValue(this.getUnquotedValue(), rc);
    }

    public static void renderUnquotedValue(String unquoted, RenderContext rc) {
        StringBuilder sb = new StringBuilder(unquoted.length() + 18);
        if (!rc.isEmbeddable() && rc.asJson()) {
            sb.append('\"');
            Escaping.escapeJsonString((CharSequence)unquoted, rc.isAsciiOnly(), sb);
            sb.append('\"');
        } else {
            sb.append('\'');
            Escaping.escapeJsString((CharSequence)unquoted, rc.isAsciiOnly(), rc.isEmbeddable(), sb);
            sb.append('\'');
        }
        rc.getOut().consume(sb.toString());
    }

    public String getUnquotedValue() {
        return StringLiteral.getUnquotedValueOf(this.value);
    }

    public static String getUnquotedValueOf(String jsLiteral) {
        char ch0;
        int n = jsLiteral.length();
        if (n >= 2 && ('\'' == (ch0 = jsLiteral.charAt(0)) || '\"' == ch0) && jsLiteral.charAt(n - 1) == ch0) {
            return StringLiteral.unescapeJsString(jsLiteral.substring(1, n - 1));
        }
        return jsLiteral;
    }

    public static String toQuotedValue(CharSequence unquotedValue) {
        StringBuilder sb = new StringBuilder(unquotedValue.length() + 16);
        sb.append('\'');
        Escaping.escapeJsString(unquotedValue, true, false, sb);
        sb.append('\'');
        return sb.toString();
    }

    public static StringLiteral valueOf(FilePosition pos, CharSequence unquotedValue) {
        return new StringLiteral(pos, StringLiteral.toQuotedValue(unquotedValue));
    }

    public static String unescapeJsString(CharSequence s) {
        Matcher m = UNESCAPE_PATTERN.matcher(s);
        if (!m.find()) {
            return ((Object)s).toString();
        }
        StringBuffer sb = new StringBuffer(s.length());
        do {
            int repl;
            String g;
            if (null != (g = m.group(1))) {
                repl = Integer.parseInt(g, 16);
            } else {
                g = m.group(2);
                if (null != g) {
                    repl = (char)Integer.parseInt(g, 8);
                } else {
                    g = m.group(3);
                    if (null != g) {
                        repl = (char)Integer.parseInt(g, 16);
                    } else {
                        char ch = s.charAt(m.start(4));
                        switch (ch) {
                            case 'b': {
                                repl = 8;
                                break;
                            }
                            case 'r': {
                                repl = 13;
                                break;
                            }
                            case 'n': {
                                repl = 10;
                                break;
                            }
                            case 'f': {
                                repl = 12;
                                break;
                            }
                            case 't': {
                                repl = 9;
                                break;
                            }
                            case 'v': {
                                repl = 11;
                                break;
                            }
                            default: {
                                repl = ch;
                            }
                        }
                    }
                }
            }
            m.appendReplacement(sb, "");
            sb.append((char)repl);
        } while (m.find());
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String typeOf() {
        return "string";
    }

    @Override
    public JsonML toJsonML() {
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.LiteralExpr, this.getFilePosition()).setAttribute(TagAttr.TYPE, "string").setAttribute(TagAttr.VALUE, this.getUnquotedValue()).build();
    }
}

