/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.CommonJsRewriterTestCase;
import com.google.caja.parser.quasiliteral.ES53Rewriter;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.Executor;
import com.google.caja.util.FailureIsAnOption;
import com.google.caja.util.Lists;
import com.google.caja.util.RhinoTestBed;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import junit.framework.AssertionFailedError;

public class ES53RewriterTest
extends CommonJsRewriterTestCase {
    private Rewriter es53Rewriter;

    public final void testNoFastpathWritableInheritance() throws Exception {
        this.rewriteAndExecute("(function() {  var a = {};  var b = Object.freeze(Object.create(a));  a.x = 8;  assertThrows(function(){b.x = 9;});  assertEquals(b.x, 8);})();");
    }

    public final void testConstant() throws Exception {
        this.assertConsistent("1;");
    }

    public final void testInit() throws Exception {
        this.assertConsistent("var a = 0; a;");
    }

    public final void testNew() throws Exception {
        this.assertConsistent("function f() { this.x = 1; }var g = new f();g.x;");
    }

    public final void testThrowCatch() throws Exception {
        this.assertConsistent("var x = 0; try { throw 1; }catch (e) { x = e; }x;");
        this.assertConsistent("var x = 0; try { throw { a: 1 }; }catch (e) { x = e; }'' + x;");
        this.assertConsistent("var x = 0; try { throw 'err'; }catch (e) { x = e; }x;");
        this.assertConsistent("var x = 0; try { throw new Error('err'); }catch (e) { x = e.message; }x;");
        this.assertConsistent("var x = 0; try { throw 1; }catch (e) { x = e; }finally { x = 2; }x;");
        this.assertConsistent("var x = 0; try { throw { a: 1 }; }catch (e) { x = e; }finally { x = 2; }x;");
        this.assertConsistent("var x = 0; try { throw 'err'; }catch (e) { x = e; }finally { x = 2; }x;");
        this.assertConsistent("var x = 0; try { throw new Error('err'); }catch (e) { x = e.message; }finally { x = 2; }x;");
    }

    public final void testProtoCall() throws Exception {
        this.assertConsistent("Array.prototype.sort.call([3, 1, 2]);");
        this.assertConsistent("[3, 1, 2].sort();");
        this.assertConsistent("[3, 1, 2].sort.call([4, 2, 7]);");
        this.assertConsistent("String.prototype.indexOf.call('foo', 'o');");
        this.assertConsistent("'foo'.indexOf('o');");
        this.assertConsistent("'foo'.indexOf.call('bar', 'o');");
        this.assertConsistent("'foo'.indexOf.call('bar', 'a');");
    }

    public final void testInherit() throws Exception {
        this.assertConsistent("function Point(x) { this.x = x; }\nPoint.prototype.toString = function () {\n  return '<' + this.x + '>';\n};\nfunction WP(x) { Point.call(this,x); }\nWP.prototype = Object.create(Point.prototype);\nvar pt = new WP(3);\npt.toString();");
    }

    public final void testRegExpLeak() throws Exception {
        this.rewriteAndExecute("assertEquals('' + (/(.*)/).exec(), 'undefined,undefined');");
    }

    public final void testClosure() throws Exception {
        this.assertConsistent("function f() {  var y = 2;   this.x = function() {    return y;  }; }var g = new f();var h = {};f.call(h);h.y = g.x;h.x() + h.y();");
    }

    public final void testNamedFunctionShadow() throws Exception {
        this.assertConsistent("function f() { return f; } f === f();");
        this.assertConsistent("(function () { function f() { return f; } return f === f(); })();");
    }

    public final void testArray() throws Exception {
        this.assertConsistent("[3, 2, 1].sort();");
        this.assertConsistent("[3, 2, 1].sort.call([4, 2, 7]);");
    }

    public final void testObject() throws Exception {
        this.assertConsistent("({ x: 1, y: 2 });");
    }

    @FailureIsAnOption
    public final void testFunctionToStringCall() throws Exception {
        this.rewriteAndExecute("function foo() {}\nassertEquals('function foo() {\\n  [cajoled code]\\n}',\n             foo.toString());");
        this.rewriteAndExecute("function foo (a, b) { xx; }\nassertEquals('function foo(a, b) {\\n  [cajoled code]\\n}',\n             foo.toString());");
        this.rewriteAndExecute("function foo() {}\nassertEquals('function foo() {\\n  [cajoled code]\\n}',\n             Function.prototype.toString.call(foo));");
        this.rewriteAndExecute("var foo = function (x$x, y_y) {};\nassertEquals(    'function foo$_var(x$x, y_y) {\\n  [cajoled code]\\n}',\n    Function.prototype.toString.call(foo));");
    }

    public final void testDate() throws Exception {
        this.assertConsistent("(new Date(0)).getTime();");
        this.assertConsistent("'' + (new Date(0));");
        this.rewriteAndExecute("var time = (new Date - 1);assertFalse(isNaN(time));assertEquals('number', typeof time);");
    }

    public final void testMultiDeclaration2() throws Exception {
        this.rewriteAndExecute("var a, b, c;");
        this.rewriteAndExecute("var a = 0, b = ++a, c = ++a;assertEquals(++a * b / c, 1.5);");
    }

    public final void testDelete() throws Exception {
        this.assertConsistent("(function () { var a = { x: 1 }; delete a.x; return typeof a.x; })();");
        this.assertConsistent("var a = { x: 1 }; delete a.x; typeof a.x;");
        this.rewriteAndExecute("var x = {a:1, '[object Object]':2};delete x[{valueOf:function(){return 'a';}}];assertEquals(x.a, void 0);assertEquals(x['[object Object]'], 2);");
    }

    public final void testIn2() throws Exception {
        this.assertConsistent("(function () {  var a = { x: 1 };\n  return '' + ('x' in a) + ('y' in a);})();");
        this.assertConsistent("var a = { x: 1 };\n[('x' in a), ('y' in a)];");
    }

    public final void testFuncCtor() throws Exception {
        this.rewriteAndExecute("function Foo(x) { this.x = x; }var foo = new Foo(2);if (!foo) { fail('Failed to construct a global object.'); }assertEquals(2, foo.x);assertEquals(Foo, foo.constructor);");
        this.rewriteAndExecute("(function () {  function Foo(x) { this.x = x; }  var foo = new Foo(2);  if (!foo) { fail('Failed to construct a local object.'); }  assertEquals(2, foo.x);})();");
        this.rewriteAndExecute("function Foo() { }var foo = new Foo();if (!foo) {  fail('Failed to use a simple named function as a constructor.');}");
    }

    public final void testFuncArgs() throws Exception {
        this.rewriteAndExecute("var x = 0;function f() { x = arguments[0]; }f(3);assertEquals(3, x);");
    }

    public final void testStatic() throws Exception {
        this.assertConsistent("Array.slice([3, 4, 5, 6], 1);");
    }

    public final void testConcatArgs() throws Exception {
        this.rewriteAndExecute("", "(function(x, y){ return [x, y]; })", "var f = ___.getNewModuleHandler().getLastValue();function g(var_args) { return f.apply(___.USELESS, arguments); }assertEquals(g(3, 4).toString(), [3, 4].toString());");
    }

    public final void testReformedGenerics() throws Exception {
        this.assertConsistent("var x = [33];x.foo = [].push;x.foo(44);x;");
        this.assertConsistent("var x = {blue:'green'};x.foo = [].push;x.foo(44);var keys = [];for (var i in x) { if (x.hasOwnProperty(i)) { keys.push(i); } }keys.sort();");
        this.assertConsistent("var x = [33];Array.prototype.push.apply(x, [3,4,5]);x;");
        this.assertConsistent("var x = {blue:'green'};Array.prototype.push.apply(x, [3,4,5]);var keys = [];for (var i in x) { if (x.hasOwnProperty(i)) { keys.push(i); } }keys.sort();");
        this.assertConsistent("var x = {blue:'green'};x.foo = [].push;x.foo.call(x, 44);var keys = [];for (var i in x) { if (x.hasOwnProperty(i)) { keys.push(i); } }keys.sort();");
    }

    public final void testMonkeyPatchPrimordialFunction() throws Exception {
        this.assertConsistent("isNaN.foo = 'bar';isNaN.foo;");
    }

    public final void testInMonkeyDelete() throws Exception {
        this.assertConsistent("var x = {y:1 };delete x.y;('y' in x);");
    }

    public final void testMonkeyOverride() throws Exception {
        this.assertConsistent("Date.prototype.propertyIsEnumerable = function(p) { return true; };(new Date()).propertyIsEnumerable('foo');");
    }

    public final void testEmbeddedcajaVM() throws Exception {
        this.assertConsistent("\"use strict,cajaVM\"; \nvar foo; \n(function () { \n  foo = function () { return 8; }; \n})(); \nfoo();");
    }

    public final void testErrorFreeze() throws Exception {
        this.rewriteAndExecute("try {  throw new Error('foo');} catch (ex) {  assertTrue(Object.isFrozen(ex));}");
    }

    public final void testObjectFreeze() throws Exception {
        this.rewriteAndExecute("var r = Object.freeze({});assertThrows(function(){r.foo = 8;});");
        this.rewriteAndExecute("var f = function(){};f.foo = 8;");
        this.rewriteAndExecute("var f = Object.freeze(function(){});assertThrows(function(){f.foo = 8;});");
        this.rewriteAndExecute("function Point(x,y) {  this.x = x;  this.y = y;}var pt = new Point(3,5);pt.x = 8;Object.freeze(pt);assertThrows(function(){pt.y = 9;});");
        this.rewriteAndExecute("function f(){}Object.freeze(f);assertThrows(function() { f.prototype = {}; });");
    }

    public final void testFunctionInstance() throws Exception {
        this.rewriteAndExecute("assertTrue(!!((function(){}).prototype));");
        this.rewriteAndExecute("assertEquals((function(a,b,c){}).length, 3);");
        this.rewriteAndExecute("assertEquals((function x(a,b,c){}).name, 'x');");
        this.rewriteAndExecute("assertTrue(!!(cajaVM.USELESS.toString.prototype));");
    }

    public final void testTamedXo4aOkOnNull() throws Exception {
        this.rewriteAndExecute("this.foo = 8;", "var x = Object.create(cajaVM.USELESS);assertFalse(({foo: 7}).hasOwnProperty.call(null, 'foo'));assertTrue(cajaVM.USELESS.isPrototypeOf(x));assertTrue(({foo: 7}).isPrototypeOf.call(null, x));", "assertTrue(({}).hasOwnProperty.call(null, 'foo'));assertFalse(({bar: 7}).hasOwnProperty.call(null, 'bar'));");
        this.rewriteAndExecute("this.foo = 8;", "var x = Object.create(cajaVM.USELESS);assertFalse(({foo: 7}).hasOwnProperty.apply(null, ['foo']));assertTrue(cajaVM.USELESS.isPrototypeOf(x));assertTrue(({foo: 7}).isPrototypeOf.apply(null, [x]));", "assertTrue(({}).hasOwnProperty.apply(null, ['foo']));assertFalse(({bar: 7}).hasOwnProperty.apply(null, ['bar']));");
        this.rewriteAndExecute("var x = Object.create(cajaVM.USELESS);assertFalse(({foo: 7}).hasOwnProperty.bind(null)('foo'));assertTrue(cajaVM.USELESS.isPrototypeOf(x));assertTrue(({foo: 7}).isPrototypeOf.bind(null)(x));");
    }

    public final void testToString() throws Exception {
        this.assertConsistent("var z = { toString: function () { return 'blah'; } };try {  '' + z;} catch (e) {  throw new Error('PlusPlus error: ' + e);}");
        this.assertConsistent("  function foo() {  var x = 1;  return {    toString: function () {      return x;    }  };}'' + (new foo);");
    }

    public final void testToStringToxicity() throws Exception {
        this.rewriteAndExecute("", "function objMaker(f) {return {toString:f};}", "assertThrows(    function() {testImports.objMaker(function(){return '1';});});");
    }

    public final void testInitializeMap() throws Exception {
        this.assertConsistent("var zerubabel = {bobble:2, apple:1}; zerubabel.apple;");
    }

    public final void testValueOf() throws Exception {
        this.assertConsistent("''+{valueOf:function(){return 5;}}");
    }

    public final void testAssertEqualsCajoled() throws Exception {
        try {
            this.rewriteAndExecute("assertEquals(1, 2);");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ES53RewriterTest.fail((String)"Assertions do not work in cajoled mode");
    }

    public final void testAssertThrowsCajoledNoError() throws Exception {
        this.rewriteAndExecute("  assertThrows(function() { throw 'foo'; });");
        this.rewriteAndExecute("  assertThrows(    function() { throw 'foo'; },    'foo');");
    }

    public final void testAssertThrowsCajoledErrorNoMsg() throws Exception {
        try {
            this.rewriteAndExecute("assertThrows(function() {});");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ES53RewriterTest.fail((String)"Assertions do not work in cajoled mode");
    }

    public final void testAssertThrowsCajoledErrorWithMsg() throws Exception {
        try {
            this.rewriteAndExecute("assertThrows(function() {}, 'foo');");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ES53RewriterTest.fail((String)"Assertions do not work in cajoled mode");
    }

    public final void testConstructionWithFunction() throws Exception {
        this.assertConsistent("  function Point() {}var p = new Point();(p !== undefined);");
        this.assertConsistent("  var Point = function() {};var p = new Point();(p !== undefined);");
    }

    public final void testReflectiveMethodInvocation() throws Exception {
        this.assertConsistent("(function (first, second) { return 'a' + first + 'b' + second; }).call([], 8, 9);");
        this.assertConsistent("var a = []; [].push.call(a, 5, 6); a;");
        this.assertConsistent("(function (a, b) { return 'a' + a + 'b' + b; }).apply([], [8, 9]);");
        this.assertConsistent("var a = []; [].push.apply(a, [5, 6]); a;");
        this.assertConsistent("[].sort.apply([6, 5]);");
        this.assertConsistent("(function (first, second) { return 'a' + first + 'b' + second; }).bind([], 8)(9);");
    }

    public final void testToxicBind() throws Exception {
        this.rewriteAndExecute("var confused = false;testImports.keystone = function keystone() { confused = true; };", "assertThrows(function() {keystone.bind()();});", "assertFalse(confused);");
    }

    public final void testBadDelete() throws Exception {
        this.rewriteAndExecute("testImports.badContainer = {secret__: 3469};", "assertThrows(function() {delete badContainer['secret__'];});", "assertEquals(testImports.badContainer.secret__, 3469);");
        this.rewriteAndExecute("assertThrows(function() {delete ({})['proto___'];});");
    }

    public final void testApply() throws Exception {
        this.rewriteAndExecute("", "var x = 0;function f() { x = 1 }\nf.apply({});", "assertEquals(testImports.x, 1);");
    }

    public final void testInVeil() throws Exception {
        this.rewriteAndExecute("assertFalse('f___' in Object);");
    }

    public final void testSyntheticIsUntouched() throws Exception {
        String source = "function foo() { this; arguments; }";
        Block input = this.js(this.fromString(source));
        this.syntheticTree(input);
        this.checkSucceeds(input, this.js(this.fromString("var dis___ = IMPORTS___;" + source)));
    }

    public final void testSyntheticMemberAccess() throws Exception {
        Block input = this.js(this.fromString("({}).foo"));
        this.syntheticTree(input);
        this.checkSucceeds(input, this.js(this.fromString("var dis___ = IMPORTS___; ___.iM([]).foo;")));
    }

    public final void testSyntheticFormals() throws Exception {
        FilePosition unk = FilePosition.UNKNOWN;
        FunctionConstructor fc = new FunctionConstructor(unk, new Identifier(unk, "f"), Arrays.asList(new FormalParam(new Identifier(unk, "x")), new FormalParam(SyntheticNodes.s(new Identifier(unk, "y___")))), new Block(unk, Arrays.asList(new ReturnStmt(unk, Operation.createInfix(Operator.MULTIPLICATION, Operation.createInfix(Operator.ADDITION, new Reference(new Identifier(unk, "x")), new Reference(SyntheticNodes.s(new Identifier(unk, "y___")))), new Reference(new Identifier(unk, "z")))))));
        this.checkSucceeds(new Block(unk, Arrays.asList(new FunctionDeclaration((FunctionConstructor)fc.clone()))), this.js(this.fromString("var dis___ = IMPORTS___;{  function f(x, y___) {    return (x + y___) *        (IMPORTS___.z_v___ ?        IMPORTS___.z :        ___.ri(IMPORTS___, 'z'));  }  IMPORTS___.w___('f', ___.f(f, 'f'));}")));
        SyntheticNodes.s(fc);
        this.checkSucceeds(new Block(unk, Arrays.asList(new FunctionDeclaration((FunctionConstructor)fc.clone()))), this.js(this.fromString("var dis___ = IMPORTS___;function f(x, y___) {  return (x + y___) *        (IMPORTS___.z_v___ ?        IMPORTS___.z :        ___.ri(IMPORTS___, 'z'));}")));
    }

    public final void testWith() throws Exception {
        this.checkFails("with (dreams || ambiguousScoping) anything.isPossible();", "\"with\" blocks are not allowed");
        this.checkFails("with (dreams || ambiguousScoping) { anything.isPossible(); }", "\"with\" blocks are not allowed");
    }

    public final void testTryCatch() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("try {  throw 2;} catch (e) {  var e;}")), MessageType.MASKING_SYMBOL, MessageLevel.ERROR);
        this.checkAddsMessage(this.js(this.fromString("var e;try {  throw 2;} catch (e) {}")), MessageType.MASKING_SYMBOL, MessageLevel.ERROR);
        this.checkAddsMessage(this.js(this.fromString("try {} catch (x__) { }")), RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE);
        this.checkAddsMessage(this.js(this.fromString("var x;try {  g[x + 0];  g[x + 1];} catch (e) {  g[x + 2];  e;  g[x + 3];}var e;")), MessageType.MASKING_SYMBOL, MessageLevel.ERROR);
        this.rewriteAndExecute("var handled = false;try {  throw null;} catch (ex) {  assertEquals(null, ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw undefined;} catch (ex) {  assertEquals(undefined, ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw true;} catch (ex) {  assertEquals(true, ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw 37639105;} catch (ex) {  assertEquals(37639105, ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw 'panic';} catch (ex) {  assertEquals('panic', ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw new Error('hello');} catch (ex) {  assertEquals('hello', ex.message);  assertEquals('Error', ex.name);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw function foo() { throw 'should not be called'; };} catch (ex) {  assertEquals('In lieu of thrown function: foo', ex());  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw { toString: function () { return 'hiya'; }, y: 4 };} catch (ex) {  assertEquals('string', typeof ex);  assertEquals('hiya', ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw { toString: function () { throw new Error(); } };} catch (ex) {  assertEquals('Exception during exception handling.', ex);  handled = true;}assertTrue(handled);");
    }

    public final void testTryCatchFinally() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("try {} catch (e) {  var e;} finally {}")), MessageType.MASKING_SYMBOL, MessageLevel.ERROR);
        this.checkAddsMessage(this.js(this.fromString("var e;try {} catch (e) {} finally {}")), MessageType.MASKING_SYMBOL, MessageLevel.ERROR);
        this.checkAddsMessage(this.js(this.fromString("try {} catch (x__) { } finally { }")), RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE);
    }

    public final void testTryFinally() throws Exception {
        this.assertConsistent("var out = 0;try {  try {    throw 2;  } finally {    out = 1;  }  out = 2;} catch (e) {}out;");
    }

    public final void testGlobalBadSuffix() throws Exception {
        this.checkFails("x__ = 1;", "Variables cannot end in \"__\"");
        this.checkFails("var x__ = 1;", "Variables cannot end in \"__\"");
        this.checkFails("var x = x__;", "Variables cannot end in \"__\"");
        this.checkFails("var x\\u005f\\u005f;", "Variables cannot end in \"__\"");
        this.checkFails("var x__;", "Variables cannot end in \"__\"");
        this.checkFails("x__ = 1;", "Variables cannot end in \"__\"");
        this.checkFails("__ = 1;", "Variables cannot end in \"__\"");
        this.checkFails("__ = 1;", "Variables cannot end in \"__\"");
    }

    public final void testVarBadSuffix() throws Exception {
        this.checkFails("function() { foo__; };", "Variables cannot end in \"__\"");
        this.checkSucceeds("function() { var foo_ = 3; };", "var dis___ = IMPORTS___;___.f(function () {    var foo_;    foo_ = 3;  });");
    }

    public final void testVarBadSuffixDeclaration() throws Exception {
        this.checkFails("function foo__() { }", "Variables cannot end in \"__\"");
        this.checkFails("var foo__ = 3;", "Variables cannot end in \"__\"");
        this.checkFails("var foo__;", "Variables cannot end in \"__\"");
        this.checkFails("function() { function foo__() { } };", "Variables cannot end in \"__\"");
        this.checkFails("function() { var foo__ = 3; };", "Variables cannot end in \"__\"");
        this.checkFails("function() { var foo__; };", "Variables cannot end in \"__\"");
    }

    public final void testVarFuncFreeze() throws Exception {
        this.rewriteAndExecute("function foo() {}foo();");
        this.rewriteAndExecute("var foo = {};foo.x = 3;assertEquals(foo.x, 3);");
        this.assertConsistent("function foo() {}var bar = foo;bar.x = 3;bar.x;");
    }

    public final void testReadBadSuffix() throws Exception {
        this.checkFails("x.y__;", "Properties cannot end in \"__\"");
    }

    public final void testSetBadFreeVariable() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("Array = function () { return [] };")), RewriterMessageType.CANNOT_MASK_IDENTIFIER);
        this.rewriteAndExecute("assertThrows(function () { x = 1; })");
    }

    public final void testSetBadSuffix() throws Exception {
        this.checkFails("x.y__ = z;", "Properties cannot end in \"__\"");
    }

    public final void testSetBadInitialize() throws Exception {
        this.checkFails("var x__ = 3;", "Variables cannot end in \"__\"");
    }

    public final void testSetBadDeclare() throws Exception {
        this.checkFails("var x__;", "Variables cannot end in \"__\"");
    }

    public final void testSetVar() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("try {} catch (x__) { x__ = 3; }")), RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE);
    }

    public final void testSetReadModifyWriteLocalVar() throws Exception {
        this.checkFails("x__ *= 2;", "");
        this.checkFails("x *= y__;", "");
        this.assertConsistent("var x = 3; x *= 2;");
        this.assertConsistent("var x = 1; x += 7;");
        this.assertConsistent("var x = 1; x /= '2';");
        this.assertConsistent("var o = { x: 'a' }; o.x += 'b'; o;");
        EnumSet<Operator[]> ops = EnumSet.of(Operator.ASSIGN_MUL, new Operator[]{Operator.ASSIGN_DIV, Operator.ASSIGN_MOD, Operator.ASSIGN_SUM, Operator.ASSIGN_SUB, Operator.ASSIGN_LSH, Operator.ASSIGN_RSH, Operator.ASSIGN_USH, Operator.ASSIGN_AND, Operator.ASSIGN_XOR, Operator.ASSIGN_OR});
        for (Operator operator : ops) {
            this.assertConsistent("var x = 41, y = 0, g = [17]; x " + operator.getSymbol() + " g[y];");
        }
    }

    public final void testSetIncrDecr() throws Exception {
        this.checkFails("x__--;", "");
        this.assertConsistent("var x = 2;var arr = [--x, x, x--, x, ++x, x, x++, x];assertEquals('1,1,1,0,1,1,1,2', arr.join(','));arr;");
        this.assertConsistent("var x = '2';var arr = [--x, x, x--, x, ++x, x, x++, x];assertEquals('1,1,1,0,1,1,1,2', arr.join(','));arr;");
    }

    public final void testSetIncrDecrOnLocals() throws Exception {
        this.checkFails("++x__;", "");
        this.assertConsistent("(function () {  var x = 2;  var arr = [--x, x, x--, x, ++x, x, x++, x];  assertEquals('1,1,1,0,1,1,1,2', arr.join(','));  return arr;})();");
    }

    public final void testSetIncrDecrOfComplexLValues() throws Exception {
        this.checkFails("arr[x__]--;", "Variables cannot end in \"__\"");
        this.checkFails("arr__[x]--;", "Variables cannot end in \"__\"");
        this.assertConsistent("(function () {  var o = { x: 2 };  var arr = [--o.x, o.x, o.x--, o.x, ++o.x, o.x, o.x++, o.x];  assertEquals('1,1,1,0,1,1,1,2', arr.join(','));  return arr;})();");
    }

    public final void testSetIncrDecrOrderOfAssignment() throws Exception {
        this.assertConsistent("(function () {  var arrs = [1, 2];  var j = 0;  arrs[++j] *= ++j;  assertEquals(2, j);  assertEquals(1, arrs[0]);  assertEquals(4, arrs[1]);  return arrs;})();");
        this.assertConsistent("(function () {  var foo = (function () {               var k = 0;               return function () {                 switch (k++) {                   case 0: return [10, 20, 30];                   case 1: return 1;                   case 2: return 2;                   default: throw new Error(k);                 }               };             })();  return foo()[foo()] -= foo();})();");
    }

    public final void testDeletePub() throws Exception {
        this.checkFails("delete x.foo___;", "Properties cannot end in \"__\"");
        this.assertConsistent("(function() {  var o = { x: 3, y: 4 };  function ptStr(o) { return '(' + o.x + ',' + o.y + ')'; }  var history = [ptStr(o)];  delete o.y;  delete o.z;  history.push(ptStr(o));  return history.toString();})();");
        this.assertConsistent("var alert = 'a';var o = { a: 1 };delete o[alert];assertEquals(undefined, o.a);o;");
    }

    public final void testDeleteFails() throws Exception {
        this.rewriteAndExecute("assertThrows(function (){delete (function f(){}).name;});");
    }

    public final void testDeleteNonLvalue() throws Exception {
        this.checkFails("delete 4;", "Invalid operand to delete");
    }

    public final void testFuncAnonSimple() throws Exception {
        this.assertConsistent("var foo = (function () {             function foo() {}             foo.x = 3;             return foo;           })();foo();foo.x;");
    }

    public final void testFuncNamedSimpleDecl() throws Exception {
        this.rewriteAndExecute("(function () {  function foo() {}  Object.freeze(foo);  foo();  try {    foo.x = 3;  } catch (e) { return; }  fail('mutated frozen function');})();");
        this.assertConsistent("function foo() {}foo.x = 3;foo();foo.x;");
        this.rewriteAndExecute("  function f_() { return 31415; }var x = f_();assertEquals(x, 31415);");
    }

    public final void testMapSingle() throws Exception {
        this.checkFails("var o = { x___: p.x, k1: p.y };", "Properties cannot end in \"__\"");
    }

    public final void testInstanceof() throws Exception {
        this.assertConsistent("[ (({}) instanceof Object),  ((new Date) instanceof Date),  (({}) instanceof Date)];");
        this.assertConsistent("function foo() {}  (new foo) instanceof foo;");
        this.assertConsistent("function foo() {}  !(({}) instanceof foo);");
    }

    public final void testTypeof() throws Exception {
        this.rewriteAndExecute("assertThrows(function () { return typeof ___; })");
        this.assertConsistent("typeof true;");
        this.assertConsistent("typeof 0;");
        this.assertConsistent("typeof undefined;");
        this.assertConsistent("typeof null;");
        this.assertConsistent("typeof 'string';");
        this.assertConsistent("typeof function () {};");
        this.assertConsistent("typeof ({});");
    }

    public final void testMaskingFunction() throws Exception {
        this.assertAddsMessage("function Goo() { function Goo() {} }", MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR);
        this.assertAddsMessage("function Goo() { var Goo = 1; }", MessageType.MASKING_SYMBOL, MessageLevel.LINT);
        this.assertMessageNotPresent("function Goo() { this.x = 1; }", MessageType.MASKING_SYMBOL);
    }

    public final void testMapBadKeySuffix() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("var o = { x__: 3 };")), RewriterMessageType.PROPERTIES_CANNOT_END_IN_DOUBLE_UNDERSCORE);
    }

    public final void testMapNonEmpty() throws Exception {
        this.rewriteAndExecute("testImports.f = function() {};", "assertThrows(function() { f(); });", ";");
        this.rewriteAndExecute("  var f = function() {};var m = { f : f };m.f();");
        this.rewriteAndExecute("testImports.f = function() {};", "assertThrows(function(){({ isPrototypeOf : f });});", ";");
    }

    public final void testLabeledStatement() throws Exception {
        this.checkFails("IMPORTS___: 1;", "Labels cannot end in \"__\"");
        this.checkFails("IMPORTS___: while (1);", "Labels cannot end in \"__\"");
        this.checkFails("while (1) { break x__; }", "Labels cannot end in \"__\"");
        this.checkFails("while (1) { continue x__; }", "Labels cannot end in \"__\"");
        this.assertConsistent("var k = 0;a: for (var i = 0; i < 10; ++i) {  b: for (var j = 0; j < 10; ++j) {    if (++k > 5) break a;  }}k;");
        this.assertConsistent("var k = 0;a: for (var i = 0; i < 10; ++i) {  b: for (var j = 0; j < 10; ++j) {    if (++k > 5) break b;  }}k;");
    }

    public final void testWrapperAccess() throws Exception {
        this.rewriteAndExecute("", "var x = 'test';", "if (___.getNewModuleHandler().getImports().x != 'test') {fail('Cannot see inside the wrapper');}");
    }

    public final void testFrozenObjectPrototype() throws Exception {
        this.rewriteAndExecute("var success = false;try {Object.prototype.x = 'X';} catch (e){success = true;}if (!success) { fail('Object.prototype not frozen.'); }");
    }

    public final void testStamp() throws Exception {
        this.rewriteAndExecute("function Foo(){}var foo = new Foo();Object.freeze(foo);var TestMark = cajaVM.Trademark('Test');var passed = false;try {   cajaVM.stamp([TestMark.stamp], foo);} catch (e) {  if (e.message !==       'Can\\'t stamp frozen objects: [object Object]') {    fail(e.message);  }  passed = true;}if (!passed) { fail ('Able to stamp frozen objects.'); }");
        this.rewriteAndExecute("___.getNewModuleHandler().    getImports().DefineOwnProperty___('stampAnyway', {      value: ___.markFuncFreeze(function(stamp, obj) {          stamp.mark___(obj);        }),      enumerable: false,      writable: true,      configurable: false    });", "function Foo(){}var foo = new Foo();Object.freeze(foo);var TestMark = cajaVM.Trademark('Test');try {   stampAnyway(TestMark.stamp, foo);} catch (e) {  fail(e.message);}cajaVM.guard(TestMark.guard, foo);", "");
        this.rewriteAndExecute("var foo = {};var TestMark = cajaVM.Trademark('Test');cajaVM.stamp([TestMark.stamp], foo);cajaVM.guard(TestMark.guard, foo);");
        this.rewriteAndExecute("var foo = {};var TestMark = cajaVM.Trademark('Test');cajaVM.stamp([TestMark.stamp], foo);TestMark.guard.coerce(foo);");
        this.rewriteAndExecute("var foo = {};var TestMark = cajaVM.Trademark('Test');var passed = false;try {   cajaVM.guard(TestMark.guard, foo);} catch (e) {  if (e.message !==       'Specimen does not have the \"Test\" trademark') {    fail(e.message);  }  passed = true;}if (!passed) { fail ('Able to forge trademarks.'); }");
        this.rewriteAndExecute("var foo = {};var T1Mark = cajaVM.Trademark('T1');var T2Mark = cajaVM.Trademark('T2');var passed = false;try {   cajaVM.stamp([T1Mark.stamp], foo);  cajaVM.guard(T2Mark.guard, foo);} catch (e) {  if (e.message !== 'Specimen does not have the \"T2\" trademark') {    fail(e.message);  }  passed = true;}if (!passed) { fail ('Able to forge trademarks.'); }");
        this.rewriteAndExecute("var foo = {};var bar = Object.create(foo);var baz = Object.create(bar);var TestMark = cajaVM.Trademark('Test');cajaVM.stamp([TestMark.stamp], bar);assertFalse(cajaVM.passesGuard(TestMark.guard, foo));assertTrue(cajaVM.passesGuard(TestMark.guard, bar));assertFalse(cajaVM.passesGuard(TestMark.guard, baz));");
    }

    public final void testIndexOf() throws Exception {
        this.assertConsistent("''.indexOf('1');");
    }

    public final void testCallback() throws Exception {
        this.assertConsistent("(function(){}).apply.call(function(a, b) {return a + b;}, {}, [3, 4]);");
        this.assertConsistent("(function(){}).call.call(function(a, b) {return a + b;}, {}, 3, 4);");
        this.rewriteAndExecute("var a = [], b = {x:3};\nfor (var i in b) { a.push(i, b[i]); };assertEquals(a.toString(), 'x,3');");
        this.assertConsistent("Function.prototype.apply.call(    function(a, b) {      return a + b;    },     {},     [3, 4]);");
        this.assertConsistent("Function.prototype.call.call(    function(a, b) {      return a + b;    },    {},    3,    4);");
        this.assertConsistent("Function.prototype.bind.call(    function(a, b) {      return a + b;    },    {},    3)(4);");
    }

    public final void testTable() throws Exception {
        this.rewriteAndExecute("var t = cajaVM.newTable();var k1 = {};var k2 = {};var k3 = {};t.set(k1, 'v1');t.set(k2, 'v2');assertEquals(t.get(k1), 'v1');assertEquals(t.get(k2), 'v2');assertTrue(t.get(k3) === void 0);");
        this.rewriteAndExecute("var t = cajaVM.newTable(true);var k1 = {};var k2 = {};var k3 = {};t.set(k1, 'v1');t.set(k2, 'v2');assertEquals(t.get(k1), 'v1');assertEquals(t.get(k2), 'v2');assertTrue(t.get(k3) === void 0);");
        this.rewriteAndExecute("var t = cajaVM.newTable();t.set('foo', 'v1');t.set(null, 'v2');assertEquals(t.get('foo'), 'v1');assertEquals(t.get(null), 'v2');assertTrue(t.get({toString: function(){return 'foo';}}) === void 0);");
        this.rewriteAndExecute("var t = cajaVM.newTable(true);assertThrows(function(){t.set('foo', 'v1');});");
        this.rewriteAndExecute("var t = cajaVM.newTable(true);var k1 = {};var k2 = Object.create(k1);var k3 = Object.create(k2);var k4 = Object.create(k3);t.set(k2, 'foo');t.set(k3, 'bar');assertEquals(t.get(k2), 'foo');\nassertEquals(t.get(k3), 'bar');\nassertTrue(t.get(k1) === void 0);\nassertTrue(t.get(k4) === void 0);");
        this.rewriteAndExecute("var t = cajaVM.newTable();var k1 = {};var k2 = Object.create(k1);var k3 = Object.create(k2);var k4 = Object.create(k3);t.set(k2, 'foo');t.set(k3, 'bar');assertEquals(t.get(k2), 'foo');\nassertEquals(t.get(k3), 'bar');\nassertTrue(t.get(k1) === void 0);\nassertTrue(t.get(k4) === void 0);");
        this.rewriteAndExecute("var t1 = cajaVM.newTable(true);var t2 = cajaVM.newTable(true);var k = {};t1.set(k, 'foo');t2.set(k, 'bar');assertEquals(t1.get(k), 'foo');assertEquals(t2.get(k), 'bar');t1.set(k, void 0);assertTrue(t1.get(k) === void 0);assertEquals(t2.get(k), 'bar');");
        this.rewriteAndExecute("var t1 = cajaVM.newTable();var t2 = cajaVM.newTable();var k = {};t1.set(k, 'foo');t2.set(k, 'bar');assertEquals(t1.get(k), 'foo');assertEquals(t2.get(k), 'bar');t1.set(k, void 0);assertTrue(t1.get(k) === void 0);assertEquals(t2.get(k), 'bar');");
    }

    public final void testInheritance() throws Exception {
        this.rewriteAndExecute("var x = {a:8}, y = Object.create(x); assertTrue(y.a === 8);");
    }

    public final void testNoPrivilegeEscalation() throws Exception {
        this.rewriteAndExecute("assertTrue([].valueOf.call(null) === cajaVM.USELESS);");
        this.rewriteAndExecute("assertTrue([].valueOf.apply(null) === cajaVM.USELESS);");
        this.rewriteAndExecute("assertTrue([].valueOf.bind(null)() === cajaVM.USELESS);");
    }

    public final void testJSONClass() throws Exception {
        this.rewriteAndExecute("assertTrue(''+JSON === '[object JSON]');");
        this.rewriteAndExecute("assertTrue(({}).toString.call(JSON) === '[object JSON]');");
        this.rewriteAndExecute("var x = JSON.parse('{\"a\":[{\"b\":33}]}');assertEquals(33, x.a[0].b);");
        this.rewriteAndExecute("var x = JSON.stringify({a:33});assertEquals('{\"a\":33}', x);");
        this.rewriteAndExecute("var pass = false;try { var x = JSON.parse('{\"b\":1, \"a___\":33}'); }catch (e) {   assertTrue(e.message.indexOf('a___') !== -1);  pass = true;}assertTrue(pass);");
    }

    public final void testGetPrototypeOf() throws Exception {
        this.rewriteAndExecute("assertEquals(Object.getPrototypeOf({}), Object.prototype);");
        this.rewriteAndExecute("assertEquals(Object.getPrototypeOf([]), Array.prototype);");
        this.rewriteAndExecute("function Foo() {}var foo = new Foo();assertEquals(Object.getPrototypeOf(foo), Foo.prototype);");
    }

    public final void testArrayForEach() throws Exception {
        this.rewriteAndExecute("var testArray = ['a', 'b', 'c'];var expectedI = 0;testArray.forEach(function(item, index, orig) {  assertEquals(item, testArray[expectedI]);  assertEquals(index, expectedI);  assertEquals(orig, testArray);  expectedI++; });");
    }

    public final void testCanPut() throws Exception {
        this.rewriteAndExecute("function F(){}Object.defineProperty(F.prototype, 'constructor', {writable:false});var G = function (){};G.prototype = Object.create(F.prototype);assertThrows(function(){G.prototype.constructor = G;});");
        this.rewriteAndExecute("function F(){}Object.defineProperty(F.prototype, 'constructor', {writable:false});var G = function (){};G.prototype = Object.create(F.prototype);Object.defineProperty(G.prototype, 'constructor',    {value:undefined, writable:true, configurable:true});G.prototype.constructor = G;assertEquals(G.prototype.constructor, G);");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.es53Rewriter = new ES53Rewriter(TestBuildInfo.getInstance(), this.mq, false);
        this.setRewriter(this.es53Rewriter);
    }

    protected Object executePlain(String caja) throws IOException {
        this.mq.getMessages().clear();
        return RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/es53.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/jsunit/2.2/jsUnitCore.js"), new Executor.Input(caja, this.getName() + "-uncajoled"));
    }

    protected Object rewriteAndExecute(String pre, String caja, String post) throws IOException, ParseException {
        this.mq.getMessages().clear();
        List<Block> children = Lists.newArrayList();
        children.add(this.js(this.fromString(caja, this.is)));
        String cajoledJs = ES53RewriterTest.render(this.rewriteTopLevelNode(new UncajoledModule(new Block(FilePosition.UNKNOWN, children))));
        this.assertNoErrors();
        String[] assertFunctions = new String[]{"fail", "assertEquals", "assertTrue", "assertFalse", "assertLessThan", "assertNull", "assertThrows"};
        StringBuilder importsSetup = new StringBuilder();
        importsSetup.append("var testImports = ___.copy(___.whitelistAll(___.sharedImports));");
        for (String f : assertFunctions) {
            importsSetup.append("testImports." + f + " = ___.markFuncFreeze(" + f + ");").append("___.grantRead(testImports, '" + f + "');");
        }
        importsSetup.append("___.getNewModuleHandler().setImports(___.whitelistAll(testImports));");
        Object result = RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/plugin/console-stubs.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/es53.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/jsunit/2.2/jsUnitCore.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/log-to-console.js"), new Executor.Input(importsSetup.toString(), this.getName() + "-test-fixture"), new Executor.Input(pre, this.getName()), new Executor.Input(cajoledJs, this.getName() + "-cajoled"), new Executor.Input(post, this.getName()), new Executor.Input("___.getNewModuleHandler().getLastValue();", this.getName()));
        this.assertNoErrors();
        return result;
    }

    protected class TestUriFetcher
    implements UriFetcher {
        protected TestUriFetcher() {
        }

        public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
            try {
                URI uri = ref.getReferencePosition().source().getUri().resolve(ref.getUri());
                if ("resource".equals(uri.getScheme())) {
                    return ES53RewriterTest.this.dataFromResource(uri.getPath(), new InputSource(uri));
                }
                throw new UriFetcher.UriFetchException(ref, mimeType);
            }
            catch (IOException ex) {
                throw new UriFetcher.UriFetchException(ref, mimeType, ex);
            }
        }
    }
}

