/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.RhinoAsserts;
import com.google.caja.util.TestUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RewriterTestCase
extends CajaTestCase {
    protected Rewriter rewriter;

    protected abstract Object executePlain(String var1) throws IOException, ParseException;

    protected abstract Object rewriteAndExecute(String var1, String var2, String var3) throws IOException, ParseException;

    protected Object rewriteAndExecute(String program) throws IOException, ParseException {
        return this.rewriteAndExecute(";", program, ";");
    }

    protected void checkFails(String input, String error) throws Exception {
        this.mq.getMessages().clear();
        this.getRewriter().expand(new UncajoledModule(new Block(FilePosition.UNKNOWN, Arrays.asList(this.js(this.fromString(input, this.is))))));
        RewriterTestCase.assertFalse((String)("Expected error, found none: " + error), (boolean)this.mq.getMessages().isEmpty());
        StringBuilder messageText = new StringBuilder();
        this.mq.getMessages().get(0).format(this.mc, messageText);
        RewriterTestCase.assertTrue((String)("First error is not \"" + error + "\": " + messageText.toString()), (boolean)messageText.toString().contains(error));
    }

    protected void checkSucceeds(ParseTreeNode inputNode, ParseTreeNode expectedResultNode) {
        this.checkSucceeds(inputNode, expectedResultNode, MessageLevel.WARNING);
    }

    protected void checkSucceeds(ParseTreeNode inputNode, ParseTreeNode expectedResultNode, MessageLevel highest) {
        this.mq.getMessages().clear();
        ParseTreeNode actualResultNode = this.getRewriter().expand(inputNode);
        for (Message m : this.mq.getMessages()) {
            if (m.getMessageLevel().compareTo(highest) < 0) continue;
            RewriterTestCase.fail((String)m.toString());
        }
        if (expectedResultNode != null) {
            RewriterTestCase.assertEquals((String)RewriterTestCase.render(expectedResultNode), (String)RewriterTestCase.render(actualResultNode));
            RewriterTestCase.assertEquals((String)TestUtil.format(expectedResultNode), (String)TestUtil.format(actualResultNode));
        }
    }

    protected void assertMessageNotPresent(String src, MessageTypeInt type, MessageLevel level) throws Exception {
        this.checkDoesNotAddMessage(this.js(this.fromString(src)), type, level);
    }

    protected void assertMessageNotPresent(String src, MessageTypeInt type) throws Exception {
        this.checkDoesNotAddMessage(this.js(this.fromString(src)), type);
    }

    private void checkDoesNotAddMessage(ParseTreeNode inputNode, MessageTypeInt type) {
        this.mq.getMessages().clear();
        this.getRewriter().expand(inputNode);
        if (this.containsConsistentMessage(this.mq.getMessages(), type)) {
            RewriterTestCase.fail((String)("Unexpected add message of type " + type));
        }
    }

    protected void checkDoesNotAddMessage(ParseTreeNode inputNode, MessageTypeInt type, MessageLevel level) {
        this.mq.getMessages().clear();
        this.getRewriter().expand(inputNode);
        if (this.containsConsistentMessage(this.mq.getMessages(), type, level)) {
            RewriterTestCase.fail((String)("Unexpected add message of type " + type + " and level " + (Object)((Object)level)));
        }
    }

    protected void assertAddsMessage(String src, MessageTypeInt type, MessageLevel level) throws Exception {
        this.checkAddsMessage(this.js(this.fromString(src)), type, level);
    }

    protected void checkAddsMessage(ParseTreeNode inputNode, MessageTypeInt type) {
        this.checkAddsMessage(inputNode, type, type.getLevel());
    }

    protected void checkAddsMessage(ParseTreeNode inputNode, MessageTypeInt type, MessageLevel level) {
        this.mq.getMessages().clear();
        this.getRewriter().expand(inputNode);
        if (!this.containsConsistentMessage(this.mq.getMessages(), type, level)) {
            RewriterTestCase.fail((String)("Failed to add message of type " + type + " and level " + (Object)((Object)level)));
        }
    }

    protected boolean containsConsistentMessage(List<Message> list, MessageTypeInt type) {
        for (Message m : list) {
            System.out.println("**" + m.getMessageType() + "|" + (Object)((Object)m.getMessageLevel()));
            if (!m.getMessageType().equals(type)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsConsistentMessage(List<Message> list, MessageTypeInt type, MessageLevel level) {
        for (Message m : list) {
            System.out.println("**" + m.getMessageType() + "|" + (Object)((Object)m.getMessageLevel()));
            if (!m.getMessageType().equals(type) || m.getMessageLevel() != level) continue;
            return true;
        }
        return false;
    }

    protected void checkSucceeds(String input, String expectedResult) throws Exception {
        this.checkSucceeds(this.js(this.fromString(input)), this.js(this.fromString(expectedResult)));
    }

    protected void checkSucceeds(CharProducer cp) throws Exception {
        this.checkSucceeds(this.js(cp), null);
    }

    protected void assertConsistent(String caja) throws IOException, ParseException {
        this.assertConsistent(null, caja);
    }

    private void assertConsistent(String message, String caja) throws IOException, ParseException {
        Object plainResult = this.executePlain(caja);
        Object rewrittenResult = this.rewriteAndExecute(caja);
        String plainRepr = RhinoAsserts.structuralForm(plainResult);
        String rewrittenRepr = RhinoAsserts.structuralForm(rewrittenResult);
        if ("undefined".equals(plainRepr)) {
            RewriterTestCase.fail((String)"Consistency check returned undefined");
        }
        System.err.println("Results: plain=<" + plainRepr + "> " + "rewritten=<" + rewrittenRepr + "> " + "for " + this.getName());
        RewriterTestCase.assertEquals((String)message, (String)plainRepr, (String)rewrittenRepr);
    }

    protected final <T extends ParseTreeNode> T syntheticTree(T node) {
        for (ParseTreeNode parseTreeNode : node.children()) {
            this.syntheticTree(parseTreeNode);
        }
        return this.makeSynthetic(node);
    }

    protected final <T extends ParseTreeNode> T makeSynthetic(T node) {
        SyntheticNodes.s(node);
        return node;
    }

    protected ParseTreeNode rewriteTopLevelNode(ParseTreeNode node) {
        return this.getRewriter().expand(node);
    }

    protected Rewriter getRewriter() {
        return this.rewriter;
    }

    protected void setRewriter(Rewriter r) {
        this.rewriter = r;
    }

    protected ParseTreeNode emulateIE6FunctionConstructors(ParseTreeNode node) {
        final Rewriter w = new Rewriter(this.mq, true, false){};
        w.addRule(new Rule(){

            @RuleDescription(name="blockScope", reason="Set up the root scope and handle block scope statements", synopsis="")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                if (node instanceof Block) {
                    Scope s2 = scope == null ? Scope.fromProgram((Block)node, w.mq) : Scope.fromPlainBlock(scope);
                    return QuasiBuilder.substV("@startStmts*; @body*;", "startStmts", new ParseTreeNodeContainer(s2.getStartStatements()), "body", this.expandAll(new ParseTreeNodeContainer(node.children()), s2));
                }
                return NONE;
            }
        });
        w.addRule(new Rule(){

            @RuleDescription(name="fnDeclarations", reason="function declarations contain function constructors but don't have the same discrepencies on IE 6 as function constructors", synopsis="")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                if (node instanceof FunctionDeclaration) {
                    FunctionDeclaration decl = (FunctionDeclaration)node;
                    FunctionConstructor ctor = decl.getInitializer();
                    Scope s2 = Scope.fromFunctionConstructor(scope, ctor);
                    FunctionConstructor rewritten = (FunctionConstructor)QuasiBuilder.substV("function @ident(@formals*) { @fh*; @stmts*; @body*; }", "ident", ctor.getIdentifier(), "formals", this.expandAll(new ParseTreeNodeContainer(ctor.getParams()), s2), "fh", CajitaRewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()), "body", this.expandAll(new ParseTreeNodeContainer(ctor.getBody().children()), s2));
                    return new FunctionDeclaration(rewritten);
                }
                return NONE;
            }
        });
        w.addRule(new Rule(){

            @RuleDescription(name="ie6functions", reason="simulate IE 6's broken scoping of function constructors as described in JScript Deviations Section 2.3", synopsis="")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                if (node instanceof FunctionConstructor) {
                    FunctionConstructor ctor = (FunctionConstructor)node;
                    Scope s2 = Scope.fromFunctionConstructor(scope, ctor);
                    if (ctor.getIdentifierName() == null) {
                        return this.expandAll(node, s2);
                    }
                    Identifier ident = ctor.getIdentifier();
                    Reference identRef = new Reference(ident);
                    identRef.setFilePosition(ident.getFilePosition());
                    scope.addStartStatement(new Declaration(FilePosition.UNKNOWN, ident, identRef));
                    return QuasiBuilder.substV("(@var = function @ident(@formals*) { @fh*; @stmts*; @body*; })", "var", identRef, "ident", ident, "formals", new ParseTreeNodeContainer(ctor.getParams()), "fh", CajitaRewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()), "body", this.expandAll(new ParseTreeNodeContainer(ctor.getBody().children()), s2));
                }
                return NONE;
            }
        });
        w.addRule(new Rule(){

            @RuleDescription(name="catchAll", reason="Handles non function constructors.", synopsis="")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                return this.expandAll(node, scope);
            }
        });
        return w.expand(node);
    }
}

