/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.ParseException;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.plugin.CssDynamicExpressionRewriter;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.SafeUriLiteral;
import com.google.caja.plugin.UnsafeUriLiteral;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssDynamicExpressionRewriterTest
extends CajaTestCase {
    public final void testSimpleRule() {
        this.assertCompiledCss("p {color:purple}", "[ '.', ' p {\\n  color: purple\\n}' ]");
    }

    public final void testClassRule() {
        this.assertCompiledCss(".foo .bar {color:blue}", "[ '.', ' .foo .bar {\\n  color: blue\\n}' ]");
        this.assertCompiledCss(".foo.bar {color:blue}", "[ '.', ' .foo.bar {\\n  color: blue\\n}' ]");
    }

    public final void testIdRule() {
        this.assertCompiledCss("#foo {color:blue}", "[ '.', ' #foo-', ' {\\n  color: blue\\n}' ]");
        this.assertCompiledCss("p#foo #baz{color:blue}", "[ '.', ' p#foo-', ' #baz-', ' {\\n  color: blue\\n}' ]");
    }

    public final void testBodyMarker() {
        this.assertCompiledCss("body.ie6 p {color:blue}", "[ '.vdoc-body___.ie6.', ' p {\\n  color: blue\\n}' ]");
        this.assertCompiledCss("body.ie6#zoicks p {color:blue}", "[ '.vdoc-body___.ie6#zoicks-', '.', ' p {\\n  color: blue\\n}' ]");
        this.assertCompiledCss("body.ie6 {color:blue}", "[ '.vdoc-body___.ie6.', ' {\\n  color: blue\\n}' ]");
        this.assertCompiledCss("body { font-size: 12pt }", "[ '.vdoc-body___.', ' {\\n  font-size: 12pt\\n}' ]");
    }

    public final void testCompoundRule() {
        this.assertCompiledCss("a, b {color:blue}", "[ '.', ' a, .', ' b {\\n  color: blue\\n}' ]");
    }

    public final void testDescendentRule() {
        this.assertCompiledCss("#foo > #bar { color: blue }", "[ '.', ' #foo-', ' > #bar-', ' {\\n  color: blue\\n}' ]");
    }

    public final void testWildcardSelectors() {
        this.assertCompiledCss("div * { margin: 0; }", "[ '.', ' div * {\\n  margin: 0;\\n}' ]");
    }

    public final void testStaticIdClass() {
        this.assertCompiledCss("#a > #b, .c { color: blue }", "[ '.xyz___ #a-xyz___ > #b-xyz___, .xyz___ .c {\\n  color: blue\\n}' ]", false);
    }

    public final void testRewriteUnsafeUris1() throws Exception {
        this.assertRewriteUris("  p { background: url(foo.png) }a { background: url(bar.png) }", "[ '.', ' p {\\n  background: url(\\'foo.png\\')\\n}\\n.', ' a {\\n  background: url(' + IMPORTS___.rewriteUriInCss___('bar.png') + ')\\n}' ]", Arrays.asList("foo.png"), Arrays.asList("bar.png"));
    }

    public final void testRewriteUnsafeUris2() throws Exception {
        this.assertRewriteUris("  p { background: url(\"foo'.png\") }a { background: url(\"bar'.png\") }", "[ '.', ' p {\\n  background: url(\\'foo%27.png\\')\\n}\\n.', ' a {\\n  background: url(' + IMPORTS___.rewriteUriInCss___('bar\\'.png') + ')\\n}' ]", Arrays.asList("foo'.png"), Arrays.asList("bar'.png"));
    }

    private void assertRewriteUris(String input, String golden, List<String> safeUris, List<String> unsafeUris) throws Exception {
        this.assertCompiledCss(this.safeUnsafe(this.css(this.fromString(input)), safeUris, unsafeUris), golden);
    }

    private void assertCompiledCss(String input, String golden) {
        this.assertCompiledCss(input, golden, true);
    }

    private void assertCompiledCss(CssTree.StyleSheet css, String golden) {
        this.assertCompiledCss(css, golden, true);
    }

    private void assertCompiledCss(String input, String golden, boolean dynamic) {
        try {
            this.assertCompiledCss(this.css(this.fromString(input)), golden, dynamic);
        }
        catch (ParseException ex) {
            CssDynamicExpressionRewriterTest.fail((String)input);
        }
    }

    private void assertCompiledCss(CssTree.StyleSheet css, String golden, boolean dynamic) {
        PluginMeta pm = new PluginMeta();
        if (!dynamic) {
            pm.setIdClass("xyz___");
        }
        new CssDynamicExpressionRewriter(pm).rewriteCss(css);
        ArrayConstructor ac = CssDynamicExpressionRewriter.cssToJs(css);
        CssDynamicExpressionRewriterTest.assertEquals((String)golden, (String)CssDynamicExpressionRewriterTest.render(ac, 160));
    }

    private CssTree.StyleSheet safeUnsafe(CssTree.StyleSheet css, final List<String> safeUris, final List<String> unsafeUris) {
        css.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.UriLiteral) {
                    CssTree parent = (CssTree)ancestors.parent.node;
                    assert (null != parent);
                    String value = ((CssTree.CssLiteral)node).getValue();
                    CssTree.UriLiteral repl = null;
                    if (safeUris.contains(value)) {
                        repl = new SafeUriLiteral(node.getFilePosition(), URI.create(value));
                    } else if (unsafeUris.contains(value)) {
                        repl = new UnsafeUriLiteral(node.getFilePosition(), URI.create(value));
                    }
                    if (repl != null) {
                        parent.replaceChild(repl, (ParseTreeNode)node);
                    } else {
                        Assert.fail((String)("URI literal " + value + " unaccounted for by test"));
                    }
                }
                return true;
            }
        }, null);
        return css;
    }

    private static String render(ParseTreeNode node, int limit) {
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter pp = new JsPrettyPrinter(new Concatenator(sb));
        pp.setLineLengthLimit(limit);
        node.render(new RenderContext(pp));
        pp.noMoreTokens();
        return sb.toString();
    }
}

