/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.js.Elision;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.render.Concatenator;
import com.google.caja.render.CssPrettyPrinter;
import com.google.caja.util.Lists;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmbeddedJsExpressionTokenConsumer
implements TokenConsumer {
    private final StringBuilder partialJsStringLiteral = new StringBuilder();
    private boolean inJsString;
    private FilePosition positionAtStartOfStringLiteral;
    private FilePosition last;
    private final CssPrettyPrinter cssTokenConsumer = new CssPrettyPrinter(new Concatenator(this.partialJsStringLiteral));
    private Expression pendingExpression;
    private final List<Expression> arrayElements = Lists.newArrayList();

    EmbeddedJsExpressionTokenConsumer() {
    }

    public void consume(Expression jsExpression) {
        if (jsExpression instanceof StringLiteral) {
            if (!this.inJsString) {
                this.startPartialJsStringLiteral();
            }
            this.mark(jsExpression.getFilePosition());
            this.partialJsStringLiteral.append(((StringLiteral)jsExpression).getUnquotedValue());
        } else {
            if (this.inJsString) {
                this.pendingExpression = this.combine(this.pendingExpression, this.endPartialJsStringLiteral());
            }
            this.pendingExpression = this.combine(this.pendingExpression, jsExpression);
        }
    }

    public void endArrayElement() {
        this.endArrayElement(true);
    }

    private void endArrayElement(boolean requireHole) {
        if (this.inJsString) {
            this.pendingExpression = this.combine(this.pendingExpression, this.endPartialJsStringLiteral());
        }
        if (this.pendingExpression != null) {
            this.arrayElements.add(this.pendingExpression);
            this.pendingExpression = null;
        } else if (requireHole) {
            this.arrayElements.add(new Elision(this.last != null ? this.last : FilePosition.UNKNOWN));
        }
    }

    public List<Expression> getArrayMembers() {
        if (this.inJsString || this.pendingExpression != null) {
            throw new IllegalStateException();
        }
        return this.arrayElements;
    }

    @Override
    public void mark(FilePosition pos) {
        this.cssTokenConsumer.mark(pos);
        if (this.inJsString && this.positionAtStartOfStringLiteral == null) {
            this.positionAtStartOfStringLiteral = pos;
        }
        this.last = pos;
    }

    @Override
    public void consume(String text) {
        if (!this.inJsString) {
            this.startPartialJsStringLiteral();
        }
        this.cssTokenConsumer.consume(text);
    }

    @OverridingMethodsMustInvokeSuper
    protected void startPartialJsStringLiteral() {
        this.inJsString = true;
    }

    @Override
    public void noMoreTokens() {
        this.cssTokenConsumer.noMoreTokens();
        this.endArrayElement(false);
    }

    @OverridingMethodsMustInvokeSuper
    protected Expression endPartialJsStringLiteral() {
        String s = this.partialJsStringLiteral.toString();
        this.partialJsStringLiteral.setLength(0);
        FilePosition pos = this.positionAtStartOfStringLiteral != null ? FilePosition.span(this.positionAtStartOfStringLiteral, this.last) : FilePosition.UNKNOWN;
        this.positionAtStartOfStringLiteral = null;
        this.inJsString = false;
        return StringLiteral.valueOf(pos, s);
    }

    protected Expression combine(@Nullable Expression prefixExpression, Expression suffixExpression) {
        if (prefixExpression != null) {
            return Operation.createInfix(Operator.ADDITION, prefixExpression, suffixExpression);
        }
        return suffixExpression;
    }
}

