/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.plugin.PluginCompiler;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Executor;
import com.google.caja.util.RhinoTestBed;
import com.google.caja.util.TestUtil;
import junit.framework.AssertionFailedError;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HtmlCompiledPluginTest
extends CajaTestCase {
    protected void setUp() throws Exception {
        TestUtil.enableContentUrls();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testEmptyGadget() throws Exception {
        this.execGadget("", "");
    }

    public final void testTestingFramework() throws Exception {
        try {
            this.execGadget("<script>fail('hiya');</script>", "");
        }
        catch (AssertionFailedError ex) {
            HtmlCompiledPluginTest.assertEquals((String)"hiya", (String)ex.getMessage());
            return;
        }
        HtmlCompiledPluginTest.fail((String)"Expected failure");
    }

    public final void testVariableRefInHandlerFunction() throws Exception {
        this.execGadget("  <script type='text/javascript'>var foo;</script><a onclick='foo + bar;'>foo</a>", "");
    }

    public final void testNonNamespaceAwareDom() throws Exception {
        Document doc = DomParser.makeDocument(null, null);
        DocumentFragment root = doc.createDocumentFragment();
        Element script = doc.createElement("script");
        script.setAttribute("type", "text/javascript");
        script.appendChild(doc.createTextNode("var foo;"));
        Element a = doc.createElement("a");
        a.setAttribute("onclick", "foo + bar;");
        a.appendChild(doc.createTextNode("foo"));
        root.appendChild(script);
        root.appendChild(a);
        this.execGadget(new Dom(root), "");
    }

    public final void testEmptyStyle() throws Exception {
        this.execGadget("<style> </style>", "");
    }

    public final void testHandlerRewriting() throws Exception {
        this.execGadget("<a onclick=\"foo(this)\">hi</a>", "assertEquals('<a target=\"_blank\">hi</a>',             document.getElementById('test-test').innerHTML);");
    }

    public final void testECMAScript31Scoping() {
    }

    public final void testExceptionsInScriptBlocks() throws Exception {
        this.execGadget("<script>var a = 0, b = 0;</script><script>throw new Error(); a = 1;</script><script>b = 1;</script>\n<script>\n  assertEquals(0, a);  assertEquals(1, b);</script>", "");
    }

    public final void testCajitaBlocks() throws Exception {
        this.execGadget("<script>  'use strict';  Object.prototype.hello = 'there';</script><script>  'use strict';  'use cajita';  assertEquals('not visible in cajita', undefined, ({}).hello);</script><script>  'use strict';  assertEquals('visible in valija', 'there', ({}).hello);</script><script>  assertEquals(      'nested cajita fns not patched',      'there,,',      [ ({}).hello,        (function () {          'use strict';          'use cajita';          return {}.hello;        })(),        (function f() {          'use strict';          'use cajita';          return {}.hello;        })() ]      .join(','));</script><script>  assertEquals('cajita fn decls hoisted to block', undefined, f);  {    function f() { 'use strict'; 'use cajita'; return {}.hello; }    assertEquals('cajita fns not patchable', undefined, f());    assertThrows(function () { f.foo = 'bar'; });    assertEquals('cajita fns frozen', undefined, f.foo);  }</script>", "assertEquals(undefined, ({}).hello);");
    }

    public final void testCustomOnErrorHandler() throws Exception {
        this.execGadget("<script>\n  'use cajita';\n  window.a = 0, window.b = 0;\n</script>\n<script>\n  'use cajita';\n  window.messages = [];\n  $v.so('onerror',\n        function onerror(message, source, lineNumber) {\n          window.messages.push(\n              source + ':' + lineNumber + ': ' + message);\n        });\n</script>\n<script>\n  'use cajita';\n  throw new Error('panic');\n  window.a = 1;</script>\n<script>\n  'use cajita';\n  window.b = 1;\n</script>\n<script>\n  'use cajita';\n  assertEquals('window.a', 0, window.a);\n  assertEquals('window.b', 1, window.b);\n</script>\n<script>\n  'use cajita';\n  assertEquals('# messages', 1, window.messages.length);\n  assertEquals(\n      'testCustomOnErrorHandler:15: panic', window.messages[0]);\n</script>", "assertEquals(1, imports.window.messages.length);");
    }

    public final void testPartialScript() throws Exception {
        PluginMeta meta = new PluginMeta();
        PluginCompiler compiler = new PluginCompiler(TestBuildInfo.getInstance(), meta, this.mq);
        compiler.setMessageContext(this.mc);
        Dom html = new Dom(this.htmlFragment(this.fromString("<script>{</script>")));
        compiler.addInput(html, this.is.getUri());
        boolean passed = compiler.run();
        HtmlCompiledPluginTest.assertFalse((boolean)passed);
        this.assertMessage(MessageType.END_OF_FILE, MessageLevel.ERROR, FilePosition.instance(this.is, 1, 9, 9, 1));
    }

    private void execGadget(String gadgetSpec, String tests) throws Exception {
        this.execGadget(new Dom(this.htmlFragment(this.fromString(gadgetSpec))), tests);
    }

    private void execGadget(Dom html, String tests) throws Exception {
        boolean failed;
        PluginMeta meta = new PluginMeta(UriFetcher.NULL_NETWORK, UriPolicy.IDENTITY);
        PluginCompiler compiler = new PluginCompiler(TestBuildInfo.getInstance(), meta, this.mq);
        compiler.setMessageContext(this.mc);
        compiler.addInput(html, html.getFilePosition().source().getUri());
        boolean bl = failed = !compiler.run();
        if (failed) {
            HtmlCompiledPluginTest.fail();
        } else {
            CajoledModule jsTree = compiler.getJavascript();
            Node htmlTree = compiler.getStaticHtml();
            String staticHtml = htmlTree != null ? Nodes.render(htmlTree, MarkupRenderMode.HTML) : "";
            String js = jsTree != null ? HtmlCompiledPluginTest.render(jsTree) : "";
            Block valijaOrigNode = this.js(this.fromResource("/com/google/caja/valija-cajita.js"));
            ParseTreeNode valijaCajoledNode = new CajitaRewriter(TestBuildInfo.getInstance(), this.mq, false).expand(new UncajoledModule(valijaOrigNode));
            String valijaCajoled = HtmlCompiledPluginTest.render(valijaCajoledNode);
            String htmlStubUrl = TestUtil.makeContentUrl("<html><head/><body><div id=\"test-test\">" + staticHtml + "</div></body></html>");
            try {
                Executor.Input[] inputs = new Executor.Input[]{new Executor.Input(((Object)((Object)this)).getClass(), "/js/jqueryjs/runtest/env.js"), new Executor.Input(((Object)((Object)this)).getClass(), "console-stubs.js"), new Executor.Input("location = '" + htmlStubUrl + "';\n", "dom"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../js/jsunit/2.2/jsUnitCore.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../cajita.js"), new Executor.Input("___.setLogFunc(function(s, opt_stop) { console.log(s); });", "setLogFunc-setup"), new Executor.Input("var valijaMaker = {};\nvar testImports = ___.copy(___.sharedImports);\ntestImports.loader = {\n  provide: ___.markFuncFreeze(\n      function(v) { valijaMaker = v; })\n};\ntestImports.outers = ___.copy(___.sharedImports);\n___.getNewModuleHandler().setImports(testImports);", this.getName() + "valija-setup"), new Executor.Input(valijaCajoled, "valija-cajoled"), new Executor.Input(((Object)((Object)this)).getClass(), "html4-defs.js"), new Executor.Input(((Object)((Object)this)).getClass(), "html-sanitizer.js"), new Executor.Input(((Object)((Object)this)).getClass(), "bridal.js"), new Executor.Input(((Object)((Object)this)).getClass(), "html-emitter.js"), new Executor.Input(((Object)((Object)this)).getClass(), "container.js"), new Executor.Input(js.toString(), "gadget"), new Executor.Input(tests, "tests")};
                RhinoTestBed.runJs(inputs);
            }
            catch (Exception e) {
                System.out.println("Compiled gadget: \n" + staticHtml + "\n" + js);
                throw e;
            }
            catch (Error e) {
                System.out.println("Compiled gadget: \n" + staticHtml + "\n" + js);
                throw e;
            }
        }
    }
}

