/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PipelineMaker;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.plugin.stages.PipelineStageTestCase;
import com.google.caja.plugin.stages.PipelineStoreStage;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.ContentType;
import com.google.caja.util.Join;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pipeline;
import com.google.caja.util.Sets;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class PipelineCacheTest
extends PipelineStageTestCase {
    private TestJobCache cache;
    private static final String CACHEABLE_HELLO_WORLD_CSS = "<style>b { color: blue; font-weight: inherit }</style>";
    private static final String REWRITTEN_HELLO_WORLD_CSS = Join.join((CharSequence)"\n", "<style type=\"text/css\">", ".foo123___ b {", "  color: blue;", "  font-weight: inherit", "}</style>");
    private static final String CACHEABLE_HELLO_WORLD_CSS_VARIANT = "<style>p { color: purple }</style>";
    private static final String REWRITTEN_HELLO_WORLD_CSS_VARIANT = Join.join((CharSequence)"\n", "<style type=\"text/css\">", ".foo123___ p {", "  color: purple", "}</style>");
    private static final String REWRITTEN_HELLO_WORLD_CSS_AND_VARIANT = Join.join((CharSequence)"\n", "<style type=\"text/css\">", ".foo123___ b {", "  color: blue;", "  font-weight: inherit", "}", ".foo123___ p {", "  color: purple", "}</style>");
    private static final String REWRITTEN_HELLO_WORLD_VARIANT_AND_CSS = Join.join((CharSequence)"\n", "<style type=\"text/css\">", ".foo123___ p {", "  color: purple", "}", ".foo123___ b {", "  color: blue;", "  font-weight: inherit", "}</style>");
    private static final String JS_MODULE_SUFFIX = Join.join((CharSequence)"\n", "", "    el___ = emitter___.finish();", "    emitter___.signalLoaded();", "  }", "  return moduleResult___;", "}");
    private static final String CACHEABLE_HELLO_WORLD_HTML = "<b onclick=alert('Hello')>Hello, World!</b>";
    private static final String REWRITTEN_HELLO_WORLD_HTML = "<b id=\"id_3___\">Hello, World!</b>";
    private static final String REWRITTEN_HELLO_WORLD_HTML_HELPER_JS = PipelineCacheTest.jsModulePrefix(new String[]{"cf", "ro"}, new String[]{"el___", "emitter___", "c_2___"}, new String[0]) + Join.join((CharSequence)"\n", "  {", "    emitter___ = IMPORTS___.htmlEmitter___;", "    el___ = emitter___.byId('id_3___');", "    c_2___ = ___.markFuncFreeze(function (event, thisNode___) {", "        $v.cf($v.ro('alert'), [ 'Hello' ]);", "      });", "    el___.onclick = function (event) {", "      return plugin_dispatchEvent___(this, event, ___.getId(IMPORTS___),", "        c_2___);", "    };", "    el___.removeAttribute('id');") + JS_MODULE_SUFFIX;
    private static final String REWRITTEN_HELLO_WORLD_HTML_HELPER_JS_NO_LOAD = REWRITTEN_HELLO_WORLD_HTML_HELPER_JS.replaceFirst("\n *emitter___\\.signalLoaded\\(\\);", "");
    private static final String CACHEABLE_HELLO_WORLD_JS = "<script>'use cajita'; alert('Hello');</script>";
    private static final String CACHEABLE_HELLO_WORLD_JS_DEFERRED = "<script defer>'use cajita'; alert('Hello');</script>";
    private static final String REWRITTEN_HELLO_WORLD_JS = PipelineCacheTest.jsModulePrefix(new String[]{"ro"}, new String[0], new String[]{"alert"}) + Join.join((CharSequence)"\n", "  try {", "    {", "      moduleResult___ = alert.CALL___('Hello');", "    }", "  } catch (ex___) {", "    ___.getNewModuleHandler().handleUncaughtException(ex___, $v.ro('onerror'),", "      'PipelineCacheTest', '1');", "  }", "  return moduleResult___;", "}");
    private static final String CACHEABLE_HELLO_WORLD_JS_VARIANT = "<script>'use cajita'; alert('Howdy');</script>";
    private static final String CACHEABLE_HELLO_WORLD_JS_VARIANT_DEFERRED = "<script defer>'use cajita'; alert('Howdy');</script>";
    private static final String REWRITTEN_HELLO_WORLD_JS_VARIANT = PipelineCacheTest.jsModulePrefix(new String[]{"ro"}, new String[0], new String[]{"alert"}) + Join.join((CharSequence)"\n", "  try {", "    {", "      moduleResult___ = alert.CALL___('Howdy');", "    }", "  } catch (ex___) {", "    ___.getNewModuleHandler().handleUncaughtException(ex___, $v.ro('onerror'),", "      'PipelineCacheTest', '1');", "  }", "  return moduleResult___;", "}");
    private static final String SIGNAL_LOADED_JS = Join.join((CharSequence)"\n", "{", "  var moduleResult___;", "  moduleResult___ = ___.NO_RESULT;", "  {", "    IMPORTS___.htmlEmitter___.signalLoaded();", "  }", "  return moduleResult___;", "}");

    protected PluginMeta createPluginMeta() {
        PluginMeta meta = super.createPluginMeta();
        meta.setIdClass("foo123___");
        return meta;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.cache = new TestJobCache();
        this.is = new InputSource(URI.create("test://example.org/" + ((Object)((Object)this)).getClass().getSimpleName()));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.cache = null;
    }

    private static final String jsModulePrefix(String[] importMembers, String[] vars, String[] imports) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("  var $v = ___.readImport(IMPORTS___, '$v', {\n");
        sb.append("      'getOuters': { '()': {} },\n");
        sb.append("      'initOuter': { '()': {} },\n");
        int n = importMembers.length;
        for (int i = 0; i < n; ++i) {
            sb.append("      '").append(importMembers[i]).append("': { '()': {} }");
            sb.append(i + 1 < n ? ",\n" : "\n");
        }
        sb.append("    });\n");
        for (String importName : imports) {
            sb.append("  var ").append(importName).append(" = ___.readImport(IMPORTS___, '").append(importName).append("');\n");
        }
        sb.append("  var moduleResult___, $dis");
        for (String var : vars) {
            sb.append(", ").append(var);
        }
        sb.append(";\n");
        sb.append("  moduleResult___ = ___.NO_RESULT;\n");
        sb.append("  $dis = $v.getOuters();\n");
        sb.append("  $v.initOuter('onerror');\n");
        return sb.toString();
    }

    public final void testEmptyCache() throws Exception {
        ((EchoingMessageQueue)this.mq).setDumpStack(true);
        PipelineStageTestCase.JobStub[] golden = new PipelineStageTestCase.JobStub[]{PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_CSS, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS, ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS, ContentType.JS)};
        this.assertPipeline(PipelineCacheTest.job("<style>b { color: blue; font-weight: inherit }</style><script>'use cajita'; alert('Hello');</script><b onclick=alert('Hello')>Hello, World!</b>", ContentType.HTML), golden);
        PipelineCacheTest.assertEquals((int)0, (int)this.cache.nServedFromCache);
        this.meta = this.createPluginMeta();
        this.assertPipeline(PipelineCacheTest.job("<style>b { color: blue; font-weight: inherit }</style><script>'use cajita'; alert('Hello');</script><b onclick=alert('Hello')>Hello, World!</b>", ContentType.HTML), golden);
        PipelineCacheTest.assertEquals((int)2, (int)this.cache.nServedFromCache);
    }

    public final void testMixAndMatchJs() throws Exception {
        this.assertPipeline(PipelineCacheTest.job("<style>b { color: blue; font-weight: inherit }</style><b onclick=alert('Hello')>Hello, World!</b><script>'use cajita'; alert('Hello');</script>", ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_CSS, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS_NO_LOAD, ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS, ContentType.JS), PipelineCacheTest.job(SIGNAL_LOADED_JS, ContentType.JS));
        PipelineCacheTest.assertEquals((int)0, (int)this.cache.nServedFromCache);
        this.meta = this.createPluginMeta();
        this.assertPipeline(PipelineCacheTest.job("<style>b { color: blue; font-weight: inherit }</style><b onclick=alert('Hello')>Hello, World!</b><script>'use cajita'; alert('Howdy');</script>", ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_CSS, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS_NO_LOAD, ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS_VARIANT, ContentType.JS), PipelineCacheTest.job(SIGNAL_LOADED_JS, ContentType.JS));
        PipelineCacheTest.assertEquals((int)2, (int)this.cache.nServedFromCache);
    }

    public final void testMixAndMatchCss() throws Exception {
        this.assertPipeline(PipelineCacheTest.job("<style>b { color: blue; font-weight: inherit }</style><b onclick=alert('Hello')>Hello, World!</b><script>'use cajita'; alert('Hello');</script>", ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_CSS, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS_NO_LOAD, ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS, ContentType.JS), PipelineCacheTest.job(SIGNAL_LOADED_JS, ContentType.JS));
        PipelineCacheTest.assertEquals((int)0, (int)this.cache.nServedFromCache);
        System.err.println("Done");
        this.meta = this.createPluginMeta();
        this.assertPipeline(PipelineCacheTest.job("<style>p { color: purple }</style><b onclick=alert('Hello')>Hello, World!</b><script>'use cajita'; alert('Hello');</script>", ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_CSS_VARIANT, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS_NO_LOAD, ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS, ContentType.JS), PipelineCacheTest.job(SIGNAL_LOADED_JS, ContentType.JS));
        PipelineCacheTest.assertEquals((int)3, (int)this.cache.nServedFromCache);
    }

    public final void testCssCacheOrdering() throws Exception {
        this.assertPipeline(PipelineCacheTest.job("<style>b { color: blue; font-weight: inherit }</style><style>p { color: purple }</style><b onclick=alert('Hello')>Hello, World!</b><script>'use cajita'; alert('Hello');</script>", ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_CSS_AND_VARIANT, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS_NO_LOAD, ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS, ContentType.JS), PipelineCacheTest.job(SIGNAL_LOADED_JS, ContentType.JS));
        PipelineCacheTest.assertEquals((int)0, (int)this.cache.nServedFromCache);
        this.meta = this.createPluginMeta();
        this.assertPipeline(PipelineCacheTest.job("<style>p { color: purple }</style><style>b { color: blue; font-weight: inherit }</style><b onclick=alert('Hello')>Hello, World!</b><script>'use cajita'; alert('Hello');</script>", ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_VARIANT_AND_CSS, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML, ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS_NO_LOAD, ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS, ContentType.JS), PipelineCacheTest.job(SIGNAL_LOADED_JS, ContentType.JS));
        PipelineCacheTest.assertEquals((int)3, (int)this.cache.nServedFromCache);
    }

    private static String rewriteGeneratedIds(String src) {
        return src.replaceAll("\\bc_2___\\b", "c_3___").replaceAll("\\bid_3___\\b", "id_4___");
    }

    public final void testDeferredJsCacheOrdering() throws Exception {
        this.assertPipeline(PipelineCacheTest.job("<script>'use cajita'; alert('Hello');</script><script defer>'use cajita'; alert('Howdy');</script><b onclick=alert('Hello')>Hello, World!</b>", ContentType.HTML), PipelineCacheTest.job(PipelineCacheTest.rewriteGeneratedIds(REWRITTEN_HELLO_WORLD_HTML), ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS, ContentType.JS), PipelineCacheTest.job(PipelineCacheTest.rewriteGeneratedIds(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS_NO_LOAD), ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS_VARIANT, ContentType.JS), PipelineCacheTest.job(SIGNAL_LOADED_JS, ContentType.JS));
        PipelineCacheTest.assertEquals((int)0, (int)this.cache.nServedFromCache);
        this.meta = this.createPluginMeta();
        this.assertPipeline(PipelineCacheTest.job("<script defer>'use cajita'; alert('Hello');</script><script>'use cajita'; alert('Howdy');</script><b onclick=alert('Hello')>Hello, World!</b>", ContentType.HTML), PipelineCacheTest.job(PipelineCacheTest.rewriteGeneratedIds(REWRITTEN_HELLO_WORLD_HTML), ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS_VARIANT, ContentType.JS), PipelineCacheTest.job(PipelineCacheTest.rewriteGeneratedIds(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS_NO_LOAD), ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS, ContentType.JS), PipelineCacheTest.job(SIGNAL_LOADED_JS, ContentType.JS));
        PipelineCacheTest.assertEquals((int)4, (int)this.cache.nServedFromCache);
    }

    public final void testJsCacheOrdering() throws Exception {
        this.assertPipeline(PipelineCacheTest.job("<script>'use cajita'; alert('Hello');</script><script>'use cajita'; alert('Howdy');</script><b onclick=alert('Hello')>Hello, World!</b>", ContentType.HTML), PipelineCacheTest.job(PipelineCacheTest.rewriteGeneratedIds(REWRITTEN_HELLO_WORLD_HTML), ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS, ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS_VARIANT, ContentType.JS), PipelineCacheTest.job(PipelineCacheTest.rewriteGeneratedIds(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS), ContentType.JS));
        PipelineCacheTest.assertEquals((int)0, (int)this.cache.nServedFromCache);
        this.meta = this.createPluginMeta();
        this.assertPipeline(PipelineCacheTest.job("<script>'use cajita'; alert('Howdy');</script><script>'use cajita'; alert('Hello');</script><b onclick=alert('Hello')>Hello, World!</b>", ContentType.HTML), PipelineCacheTest.job(PipelineCacheTest.rewriteGeneratedIds(REWRITTEN_HELLO_WORLD_HTML), ContentType.HTML), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS_VARIANT, ContentType.JS), PipelineCacheTest.job(REWRITTEN_HELLO_WORLD_JS, ContentType.JS), PipelineCacheTest.job(PipelineCacheTest.rewriteGeneratedIds(REWRITTEN_HELLO_WORLD_HTML_HELPER_JS), ContentType.JS));
        PipelineCacheTest.assertEquals((int)3, (int)this.cache.nServedFromCache);
    }

    public final void testIhabsHeadache() throws Exception {
        PipelineStageTestCase.JobStub[] goldens = new PipelineStageTestCase.JobStub[]{PipelineCacheTest.job("<p id=\"id_2___\">1337</p>", ContentType.HTML), PipelineCacheTest.job(PipelineCacheTest.jsModulePrefix(new String[]{"cf", "ro"}, new String[]{"el___", "emitter___", "c_1___"}, new String[0]) + Join.join((CharSequence)"\n", "  {", "    emitter___ = IMPORTS___.htmlEmitter___;", "    el___ = emitter___.byId('id_2___');", "    c_1___ = ___.markFuncFreeze(function (event, thisNode___) {", "        $v.cf($v.ro('alert'), [ 1337 ]);", "      });", "    el___.onclick = function (event) {", "      return plugin_dispatchEvent___(this, event, ___.getId(IMPORTS___),", "        c_1___);", "    };", "    el___.removeAttribute('id');") + JS_MODULE_SUFFIX, ContentType.JS)};
        this.assertPipeline(PipelineCacheTest.job("<p onclick=\"alert(1337);\">1337</p>", ContentType.HTML), goldens);
        PipelineCacheTest.assertEquals((int)0, (int)this.cache.nServedFromCache);
        this.meta = this.createPluginMeta();
        this.assertPipeline(PipelineCacheTest.job("<p onclick=\"alert(1337);\">1337</p>", ContentType.HTML), goldens);
        PipelineCacheTest.assertEquals((int)1, (int)this.cache.nServedFromCache);
    }

    protected boolean runPipeline(Jobs jobs) throws Exception {
        Pipeline<Jobs> pl = new Pipeline<Jobs>();
        PipelineMaker plm = new PipelineMaker(CssSchema.getDefaultCss21Schema(this.mq), HtmlSchema.getDefault(this.mq), new ModuleManager(this.meta, TestBuildInfo.getInstance(), UriFetcher.NULL_NETWORK, false, this.mq), this.cache, PipelineMaker.DEFAULT_PRECONDS, PipelineMaker.CAJOLED_MODULES.with(PipelineMaker.HTML_SAFE_STATIC).with(PipelineMaker.SANITY_CHECK));
        plm.populate(pl.getStages());
        pl.getStages().add(new PipelineStoreStage(this.cache));
        pl.getStages().add(new Pipeline.Stage<Jobs>(){

            @Override
            public boolean apply(Jobs jobs) {
                ListIterator<JobEnvelope> it = jobs.getJobs().listIterator();
                while (it.hasNext()) {
                    JobEnvelope env = it.next();
                    Job j = env.job;
                    if (env.fromCache || j.getType() != ContentType.JS) continue;
                    if (!(j.getRoot() instanceof CajoledModule)) {
                        throw new IllegalStateException("Some content not cajoled");
                    }
                    CajoledModule m = (CajoledModule)j.getRoot();
                    Block body = m.getInstantiateMethod().getBody();
                    it.set(env.withJob(Job.jsJob(body, j.getBaseUri())));
                }
                return true;
            }
        });
        return pl.apply(jobs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TestJobCache
    extends JobCache {
        final Map<TestKey, List<Job>> jobMap = Maps.newLinkedHashMap();
        int nServedFromCache = 0;

        TestJobCache() {
        }

        public List<Job> fetch(JobCache.Key k) {
            List<Job> cached = this.jobMap.get(k);
            if (cached == null) {
                return null;
            }
            this.nServedFromCache += cached.size();
            System.err.println("FETCHING " + k);
            for (Job job : cached) {
                System.err.println("    " + CajaTestCase.render(job.getRoot()).replace("\n", "\\n"));
            }
            return this.cloneJobList(cached);
        }

        private List<Job> cloneJobList(List<? extends Job> jobs) {
            List<Job> out = Lists.newArrayList();
            for (Job job : jobs) {
                out.add(Job.job(job.getRoot().clone(), job.getBaseUri()));
            }
            return out;
        }

        @Override
        public JobCache.Key forJob(ContentType type, ParseTreeNode node) {
            return new TestKey(type, CajaTestCase.render(node));
        }

        @Override
        public void store(JobCache.Key k, List<? extends Job> derivatives) {
            System.err.println("STORING  " + k);
            for (Job job : derivatives) {
                System.err.println("    " + CajaTestCase.render(job.getRoot()).replace("\n", "\\n"));
            }
            List<Job> old = this.jobMap.put((TestKey)k, this.cloneJobList(derivatives));
            if (old != null) {
                throw new IllegalStateException("Tests shouldn't overwrite cache entries");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TestKeys
    implements JobCache.Keys {
        final Set<TestKey> keys;

        TestKeys(Set<TestKey> keys) {
            this.keys = keys;
        }

        @Override
        public JobCache.Keys union(JobCache.Keys other) {
            if (!other.iterator().hasNext()) {
                return this;
            }
            Set<TestKey> all = Sets.newHashSet();
            all.addAll(this.keys);
            all.addAll(((TestKeys)other).keys);
            return new TestKeys(all);
        }

        @Override
        public Iterator<JobCache.Key> iterator() {
            final Iterator<TestKey> it = this.keys.iterator();
            return new Iterator<JobCache.Key>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public JobCache.Key next() {
                    return (JobCache.Key)it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public String toString() {
            return this.keys.toString();
        }

        @Override
        public int hashCode() {
            return ((Object)this.keys).hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof TestKeys && ((Object)this.keys).equals(((TestKeys)o).keys);
        }
    }

    static final class TestKey
    implements JobCache.Key {
        final ContentType type;
        final String content;

        TestKey(ContentType type, String content) {
            this.type = type;
            this.content = content;
        }

        public JobCache.Keys asSingleton() {
            return new TestKeys(Collections.singleton(this));
        }

        public boolean equals(Object o) {
            if (!(o instanceof TestKey)) {
                return false;
            }
            TestKey that = (TestKey)o;
            return this.type == that.type && this.content.equals(that.content);
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public String toString() {
            return "(Key " + (Object)((Object)this.type) + " " + ((long)this.content.hashCode() & 0xFFFFFFFFL) + " : " + this.content.replace("\n", "\\n") + ")";
        }
    }
}

