/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.service.CajolingService;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CajolingServlet
extends HttpServlet {
    private static final long serialVersionUID = 5055670217887121398L;
    private static final Pair<String, String> UMP = Pair.pair("Access-Control-Allow-Origin", "*");
    private final CajolingService service;

    @Deprecated
    public CajolingServlet() {
        this(new CajolingService());
    }

    public CajolingServlet(CajolingService service) {
        this.service = service;
    }

    private static void closeBadRequest(HttpServletResponse resp, int httpStatus, String error) throws ServletException {
        try {
            resp.sendError(httpStatus, error);
        }
        catch (IOException ex) {
            throw (ServletException)new ServletException().initCause((Throwable)ex);
        }
    }

    private static void closeBadRequest(HttpServletResponse resp, int httpStatus, MessageQueue mq) throws ServletException {
        CajolingServlet.closeBadRequest(resp, httpStatus, CajolingServlet.serializeMessageQueue(mq));
    }

    private static String serializeMessageQueue(MessageQueue mq) {
        StringBuilder sb = new StringBuilder();
        MessageContext mc = new MessageContext();
        for (Message m : mq.getMessages()) {
            sb.append(m.getMessageLevel().name()).append(": ");
            Escaping.escapeXml((CharSequence)m.format(mc), false, sb);
            sb.append("\n");
        }
        return sb.toString();
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Access-Control-Allow-Origin", "*");
        resp.setHeader("Access-Control-Allow-Methods", "GET, POST");
        resp.setHeader("Access-Control-Allow-Headers", "Content-Type");
        resp.setHeader("Access-Control-Max-Age", "86400");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        FetchedData fetchedData;
        if (req.getContentType() == null) {
            CajolingServlet.closeBadRequest(resp, 400, "Supplied Content-type is null");
            return;
        }
        try {
            fetchedData = FetchedData.fromStream((InputStream)req.getInputStream(), req.getContentType(), req.getCharacterEncoding(), InputSource.UNKNOWN);
        }
        catch (IOException e) {
            CajolingServlet.closeBadRequest(resp, 400, "Error decoding POST data");
            return;
        }
        this.handle(resp, new HttpContentHandlerArgs(req), fetchedData);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.handle(resp, new HttpContentHandlerArgs(req), null);
    }

    private void handle(HttpServletResponse resp, ContentHandlerArgs args, FetchedData inputFetchedData) throws ServletException {
        SimpleMessageQueue mq = new SimpleMessageQueue();
        FetchedData result = this.service.handle(inputFetchedData, args, mq);
        if (result == null) {
            CajolingServlet.closeBadRequest(resp, 500, mq);
            return;
        }
        resp.setStatus(200);
        String responseContentType = result.getContentType();
        if (result.getCharSet() != null) {
            responseContentType = responseContentType + ";charset=" + result.getCharSet();
        }
        if (CajolingServlet.containsNewline(responseContentType)) {
            throw new IllegalArgumentException(responseContentType);
        }
        try {
            byte[] content = result.getByteContent();
            resp.setContentType(responseContentType);
            resp.setContentLength(content.length);
            resp.setHeader((String)CajolingServlet.UMP.a, (String)CajolingServlet.UMP.b);
            resp.getOutputStream().write(content);
            resp.getOutputStream().close();
        }
        catch (IOException ex) {
            throw (ServletException)new ServletException().initCause((Throwable)ex);
        }
    }

    private static boolean containsNewline(String s) {
        return s.indexOf(10) >= 0 || s.indexOf(13) >= 0;
    }

    private static class HttpContentHandlerArgs
    extends ContentHandlerArgs {
        private final HttpServletRequest request;

        public HttpContentHandlerArgs(HttpServletRequest request) {
            this.request = request;
        }

        public String get(String name) {
            return this.request.getParameter(name);
        }
    }
}

