/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.tools;

import com.google.caja.plugin.BuildServiceImplementation;
import com.google.caja.tools.BuildService;
import com.google.caja.util.Lists;
import com.google.caja.util.Sets;
import com.google.caja.util.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCajaAntTask
extends Task {
    private final List<FileGroup> inputs = Lists.newArrayList();
    private final List<FileGroup> depends = Lists.newArrayList();
    private final List<Output> outputs = Lists.newArrayList();

    protected abstract boolean run(BuildService var1, PrintWriter var2, List<File> var3, List<File> var4, File var5, Map<String, Object> var6) throws BuildException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Strings.toLowerCase("");
        try {
            for (FileGroup input : this.inputs) {
                input.requireExecutable();
            }
            for (Output output : this.outputs) {
                output.requireExecutable();
            }
            for (FileGroup depend : this.depends) {
                depend.requireExecutable();
            }
            long youngest = Long.MIN_VALUE;
            List<File> inputFiles = Lists.newArrayList();
            for (FileGroup input : this.inputs) {
                inputFiles.addAll(input.files);
            }
            for (File file : inputFiles) {
                youngest = Math.max(youngest, file.lastModified());
            }
            if (Sets.newHashSet(inputFiles).size() != inputFiles.size()) {
                List dupes = Lists.newArrayList(inputFiles);
                for (File f : Sets.newHashSet(inputFiles)) {
                    dupes.remove(f);
                }
                throw new BuildException("Duplicate inputs: " + dupes);
            }
            List<File> dependees = Lists.newArrayList();
            for (FileGroup depend : this.depends) {
                dependees.addAll(depend.files);
            }
            for (File file : dependees) {
                youngest = Math.max(youngest, file.lastModified());
            }
            BuildService buildService = this.getBuildService();
            PrintWriter logger = this.getLogger();
            try {
                for (Output output : this.outputs) {
                    output.build(inputFiles, dependees, youngest, buildService, logger);
                }
            }
            finally {
                logger.flush();
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw new BuildException((Throwable)ex);
        }
    }

    PrintWriter getLogger() {
        return new PrintWriter(new Writer(){
            StringBuilder sb = new StringBuilder();

            public void write(char[] cbuf, int off, int len) {
                this.sb.append(cbuf, off, len);
            }

            public void flush() {
                if (this.sb.length() != 0) {
                    AbstractCajaAntTask.this.log(this.sb.toString().trim());
                    this.sb = new StringBuilder();
                }
            }

            public void close() {
            }
        }, true);
    }

    BuildService getBuildService() throws BuildException {
        return new BuildServiceImplementation();
    }

    public FileGroup createInput() {
        FileGroup input = new FileGroup("<input>");
        this.inputs.add(input);
        return input;
    }

    public FileGroup createDepend() {
        FileGroup depend = new FileGroup("<depend>");
        this.depends.add(depend);
        return depend;
    }

    public final Output createOutput() {
        Output output = this.makeOutput();
        this.outputs.add(output);
        return output;
    }

    abstract Output makeOutput();

    public class FileGroup {
        private final List<File> files = Lists.newArrayList();
        private final String originTag;

        FileGroup(String originTag) {
            this.originTag = originTag;
        }

        public void setFile(File file) {
            this.files.add(file);
        }

        public void addConfiguredFileSet(FileSet fs) {
            DirectoryScanner scanner = fs.getDirectoryScanner(AbstractCajaAntTask.this.getProject());
            File baseDir = scanner.getBasedir();
            scanner.scan();
            Object[] includedFiles = scanner.getIncludedFiles();
            Arrays.sort(includedFiles);
            for (Object localPath : includedFiles) {
                this.files.add(new File(baseDir, (String)localPath));
            }
        }

        void requireExecutable() throws BuildException {
            if (this.files.isEmpty()) {
                throw new BuildException(this.originTag + " at " + AbstractCajaAntTask.this.getLocation() + "missing 'file' attribute and '<fileset>'");
            }
            for (File file : this.files) {
                if (file.canRead()) continue;
                throw new BuildException(this.originTag + " at " + AbstractCajaAntTask.this.getLocation() + "of '" + file + "' is not readable");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Output {
        private File output;

        public void setFile(File output) {
            this.output = output;
        }

        void requireExecutable() throws BuildException {
            if (this.output == null) {
                throw new BuildException("<output> at " + AbstractCajaAntTask.this.getLocation() + "missing 'file' attribute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void build(List<File> inputs, List<File> dependees, long youngest, BuildService buildService, PrintWriter logger) throws BuildException {
            block9: {
                boolean modified;
                File outputTimeFile = this.output.isDirectory() ? new File(this.output, ".tstamp") : this.output;
                long outputModified = outputTimeFile.lastModified();
                boolean bl = modified = outputModified == 0L || outputModified < youngest;
                if (modified) {
                    File outputDir = this.output.getParentFile();
                    if (!outputDir.exists()) {
                        logger.println("mkdir " + outputDir);
                        outputDir.mkdirs();
                    }
                    logger.println("building " + inputs.size() + " files to " + this.output);
                    Map<String, Object> options = this.getOptions();
                    boolean success = false;
                    try {
                        success = AbstractCajaAntTask.this.run(buildService, logger, dependees, inputs, this.output, options);
                        if (success) {
                            if (outputTimeFile.exists()) break block9;
                            try {
                                new FileOutputStream(outputTimeFile).close();
                                break block9;
                            }
                            catch (IOException ex) {
                                throw new BuildException("Failed to build " + this.output, (Throwable)ex);
                            }
                        }
                        throw new BuildException("Failed to build " + this.output);
                    }
                    finally {
                        if (!success && outputTimeFile.exists()) {
                            outputTimeFile.delete();
                        }
                    }
                }
            }
        }

        public Map<String, Object> getOptions() {
            return new HashMap<String, Object>();
        }
    }
}

