/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.RestBinding;
import org.nuxeo.ecm.automation.server.RestMarshaller;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonMarshalling;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class AutomationServerComponent
extends DefaultComponent
implements AutomationServer {
    protected static final String XP_BINDINGS = "bindings";
    protected static final String XP_MARSHALLERS = "marshallers";
    protected Map<String, RestBinding> bindings;
    protected volatile Map<String, RestBinding> lookup;
    protected JsonMarshalling marshalling = new JsonMarshalling();

    public void activate(ComponentContext context) throws Exception {
        this.bindings = new HashMap<String, RestBinding>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.bindings = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_BINDINGS.equals(extensionPoint)) {
            RestBinding binding = (RestBinding)contribution;
            this.addBinding(binding);
        } else if (XP_MARSHALLERS.equals(extensionPoint)) {
            RestMarshaller marshaller = (RestMarshaller)contribution;
            this.marshalling.addMarshaller(marshaller.newInstance());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_BINDINGS.equals(extensionPoint)) {
            RestBinding binding = (RestBinding)contribution;
            this.removeBinding(binding);
        } else if (XP_MARSHALLERS.equals(extensionPoint)) {
            RestMarshaller marshaller = (RestMarshaller)contribution;
            this.marshalling.removeMarshaller(marshaller.clazz);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (AutomationServer.class.isAssignableFrom(adapter)) {
            return adapter.cast(this);
        }
        if (JsonMarshalling.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.marshalling);
        }
        return null;
    }

    @Override
    public RestBinding getOperationBinding(String name) {
        return this.lookup().get(name);
    }

    @Override
    public RestBinding getChainBinding(String name) {
        return this.lookup().get("Chain." + name);
    }

    @Override
    public RestBinding[] getBindings() {
        Map<String, RestBinding> map = this.lookup();
        return map.values().toArray(new RestBinding[map.size()]);
    }

    protected String getBindingKey(RestBinding binding) {
        return binding.isChain() ? "Chain." + binding.getName() : binding.getName();
    }

    @Override
    public synchronized void addBinding(RestBinding binding) {
        String key = this.getBindingKey(binding);
        this.bindings.put(key, binding);
        this.lookup = null;
    }

    @Override
    public synchronized RestBinding removeBinding(RestBinding binding) {
        RestBinding result = this.bindings.remove(this.getBindingKey(binding));
        this.lookup = null;
        return result;
    }

    @Override
    public boolean accept(String name, boolean isChain, HttpServletRequest req) {
        RestBinding binding;
        if (isChain) {
            name = "Chain." + name;
        }
        if ((binding = this.lookup().get(name)) != null) {
            if (binding.isDisabled()) {
                return false;
            }
            if (binding.isSecure() && !req.isSecure()) {
                return false;
            }
            Principal principal = req.getUserPrincipal();
            if (binding.isAdministrator() || binding.hasGroups()) {
                if (principal instanceof NuxeoPrincipal) {
                    NuxeoPrincipal np = (NuxeoPrincipal)principal;
                    if (binding.isAdministrator() && np.isAdministrator()) {
                        return true;
                    }
                    if (binding.hasGroups()) {
                        for (String group : binding.getGroups()) {
                            if (!np.isMemberOf(group)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, RestBinding> lookup() {
        Map<String, RestBinding> _lookup = this.lookup;
        if (_lookup == null) {
            AutomationServerComponent automationServerComponent = this;
            synchronized (automationServerComponent) {
                _lookup = this.lookup = new HashMap<String, RestBinding>(this.bindings);
            }
        }
        return _lookup;
    }
}

