/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.backend;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.wi.backend.Backend;
import org.nuxeo.ecm.platform.wi.backend.BackendFactory;
import org.nuxeo.ecm.platform.wi.filter.WISession;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestCleanupHandler;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;

public abstract class AbstractBackendFactory
implements BackendFactory {
    private static final Log log = LogFactory.getLog(AbstractBackendFactory.class);

    @Override
    public Backend getBackend(String path, HttpServletRequest request) {
        Backend backend;
        if (log.isDebugEnabled() && request != null) {
            log.debug((Object)("Get backend for method:" + request.getMethod() + " uri:" + request.getRequestURI()));
        }
        if (request != null) {
            WISession wiSession = (WISession)request.getAttribute("org.nuxeo.ecm.platform.wi.session");
            backend = this.getBackend(wiSession);
            RequestContext.getActiveContext((ServletRequest)request).addRequestCleanupHandler(new RequestCleanupHandler(){

                public void cleanup(HttpServletRequest req) {
                    backend.destroy();
                }
            });
        } else {
            backend = this.createRootBackend();
        }
        return backend.getBackend(path);
    }

    @Override
    public Backend getBackend(WISession wiSession) {
        Object sessionBackend;
        Backend backend = null;
        if (wiSession != null && (sessionBackend = wiSession.getAttribute("org.nuxeo.ecm.platform.wi.backend")) != null) {
            backend = (Backend)sessionBackend;
        }
        if (backend == null) {
            CoreSession session = null;
            if (wiSession != null) {
                session = (CoreSession)wiSession.getAttribute("org.nuxeo.ecm.platform.wi.coresession");
            }
            backend = this.createRootBackend();
            if (session != null) {
                backend.setSession(session);
            }
        }
        if (wiSession != null) {
            wiSession.setAttribute("org.nuxeo.ecm.platform.wi.backend", backend);
        }
        return backend;
    }

    protected abstract Backend createRootBackend();
}

