/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.nxql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageSelections;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;

public class CoreQueryDocumentPageProvider
extends AbstractPageProvider<DocumentModel>
implements PageProvider<DocumentModel> {
    private static final Log log = LogFactory.getLog(CoreQueryDocumentPageProvider.class);
    private static final long serialVersionUID = 1L;
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String CHECK_QUERY_CACHE_PROPERTY = "checkQueryCache";
    protected String query;
    protected List<DocumentModel> currentPageDocuments;

    @Override
    public List<DocumentModel> getCurrentPage() {
        this.checkQueryCache();
        if (this.currentPageDocuments == null) {
            this.error = null;
            this.errorMessage = null;
            CoreSession coreSession = this.getCoreSession();
            if (this.query == null) {
                this.buildQuery(coreSession);
            }
            if (this.query == null) {
                throw new ClientRuntimeException(String.format("Cannot perform null query: check provider '%s'", this.getName()));
            }
            this.currentPageDocuments = new ArrayList<DocumentModel>();
            try {
                long minMaxPageSize = this.getMinMaxPageSize();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Perform query for provider '%s': '%s' with pageSize=%s, offset=%s", this.getName(), this.query, minMaxPageSize, this.offset));
                }
                DocumentModelList docs = coreSession.query(this.query, null, minMaxPageSize, this.offset, true);
                this.resultsCount = docs.totalSize();
                this.currentPageDocuments = docs;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Performed query for provider '%s': got %s hits", this.getName(), this.resultsCount));
                }
            }
            catch (Exception e) {
                this.error = e;
                this.errorMessage = e.getMessage();
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.currentPageDocuments;
    }

    protected void buildQuery(CoreSession coreSession) {
        try {
            String newQuery;
            PageProviderDefinition def;
            SortInfo[] sortArray = null;
            if (this.sortInfos != null) {
                sortArray = this.sortInfos.toArray(new SortInfo[0]);
            }
            if ((def = this.getDefinition()).getWhereClause() == null) {
                newQuery = NXQLQueryBuilder.getQuery(def.getPattern(), this.getParameters(), def.getQuotePatternParameters(), def.getEscapePatternParameters(), sortArray);
            } else {
                DocumentModel searchDocumentModel = this.getSearchDocumentModel();
                if (searchDocumentModel == null) {
                    throw new ClientException(String.format("Cannot build query of provider '%s': no search document model is set", this.getName()));
                }
                newQuery = NXQLQueryBuilder.getQuery(searchDocumentModel, def.getWhereClause(), this.getParameters(), sortArray);
            }
            if (newQuery != null && !newQuery.equals(this.query)) {
                this.refresh();
                this.query = newQuery;
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected void checkQueryCache() {
        Map<String, Serializable> props = this.getProperties();
        if (props.containsKey(CHECK_QUERY_CACHE_PROPERTY) && Boolean.TRUE.equals(Boolean.valueOf((String)((Object)props.get(CHECK_QUERY_CACHE_PROPERTY))))) {
            CoreSession coreSession = this.getCoreSession();
            this.buildQuery(coreSession);
        }
    }

    protected CoreSession getCoreSession() {
        Map<String, Serializable> props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (coreSession == null) {
            throw new ClientRuntimeException("cannot find core session");
        }
        return coreSession;
    }

    @Override
    public PageSelections<DocumentModel> getCurrentSelectPage() {
        this.checkQueryCache();
        return super.getCurrentSelectPage();
    }

    public String getCurrentQuery() {
        return this.query;
    }

    @Override
    protected void pageChanged() {
        super.pageChanged();
        this.currentPageDocuments = null;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.query = null;
        this.currentPageDocuments = null;
    }
}

