/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.InputSource;
import com.google.caja.plugin.PluginEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class FileSystemEnvironment
implements PluginEnvironment {
    private final File directory;

    public FileSystemEnvironment(File directory) {
        this.directory = directory;
    }

    public CharProducer loadExternalResource(ExternalReference ref, String mimeType) {
        File f = this.toFileUnderSameDirectory(ref.getUri());
        if (f == null) {
            return null;
        }
        try {
            return CharProducer.Factory.create(this.newReader(f), new InputSource(f.toURI()));
        }
        catch (IOException ex) {
            return null;
        }
    }

    private URI refragUri(URI uri, String frag) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getSchemeSpecificPart(), frag);
    }

    public String rewriteUri(ExternalReference ref, String mimeType) {
        try {
            URI fragless = this.refragUri(ref.getUri(), null);
            File f = this.toFileUnderSameDirectory(fragless);
            if (f != null) {
                URI base = new File(this.directory, ".").toURI();
                URI rel = base.relativize(fragless);
                return this.refragUri(rel, ref.getUri().getFragment()).toString();
            }
            URI self = ref.getReferencePosition().source().getUri();
            String uristr = self.relativize(ref.getUri()).toString();
            if (uristr.startsWith("#")) {
                return uristr;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    protected abstract Reader newReader(File var1) throws FileNotFoundException;

    private File toFileUnderSameDirectory(URI uri) {
        File f;
        if (uri.isOpaque()) {
            return null;
        }
        if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
            return null;
        }
        if (uri.getAuthority() != null || uri.getFragment() != null || uri.getQuery() != null) {
            return null;
        }
        if (uri.getPath() == null) {
            return null;
        }
        for (File tmp = f = new File(new File(this.directory, ".").toURI().resolve(uri)); tmp != null; tmp = tmp.getParentFile()) {
            if (!this.directory.equals(tmp)) continue;
            return f;
        }
        return null;
    }
}

