/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.clipboard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.runtime.api.Framework;

public class DocumentListZipExporter {
    public static final String ZIP_ENTRY_ENCODING_PROPERTY = "zip.entry.encoding";
    private static final int BUFFER = 2048;
    private static final String SUMMARY_FILENAME = "INDEX.txt";

    public File exportWorklistAsZip(List<DocumentModel> documents, CoreSession documentManager, boolean exportAllBlobs) throws ClientException, IOException {
        StringBuilder blobList = new StringBuilder();
        File tmpFile = File.createTempFile("NX-BigZipFile-", ".zip");
        tmpFile.deleteOnExit();
        FileOutputStream fout = new FileOutputStream(tmpFile);
        ZipOutputStream out = new ZipOutputStream(fout);
        out.setMethod(8);
        out.setLevel(9);
        byte[] data = new byte[2048];
        for (DocumentModel doc : documents) {
            if (doc.getSessionId() == null) {
                doc = documentManager.getDocument(doc.getRef());
            }
            if ("deleted".equals(doc.getCurrentLifeCycleState())) continue;
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (doc.isFolder() && !this.isEmptyFolder(doc, documentManager)) {
                this.addFolderToZip("", out, doc, data, documentManager, blobList, exportAllBlobs);
                continue;
            }
            if (bh == null) continue;
            this.addBlobHolderToZip("", out, doc, data, blobList, bh, exportAllBlobs);
        }
        if (blobList.length() > 1) {
            this.addSummaryToZip(out, data, blobList);
        }
        try {
            out.close();
            fout.close();
        }
        catch (ZipException e) {
            return null;
        }
        return tmpFile;
    }

    private void addFolderToZip(String path, ZipOutputStream out, DocumentModel doc, byte[] data, CoreSession documentManager, StringBuilder blobList, boolean exportAllBlobs) throws ClientException, IOException {
        String title = (String)doc.getProperty("dublincore", "title");
        DocumentModelList docList = documentManager.getChildren(doc.getRef());
        for (DocumentModel docChild : docList) {
            if ("deleted".equals(docChild.getCurrentLifeCycleState())) continue;
            BlobHolder bh = (BlobHolder)docChild.getAdapter(BlobHolder.class);
            String newPath = null;
            newPath = path.length() == 0 ? title : path + "/" + title;
            if (docChild.isFolder() && !this.isEmptyFolder(docChild, documentManager)) {
                this.addFolderToZip(newPath, out, docChild, data, documentManager, blobList, exportAllBlobs);
                continue;
            }
            if (bh == null) continue;
            this.addBlobHolderToZip(newPath, out, docChild, data, blobList, bh, exportAllBlobs);
        }
    }

    private boolean isEmptyFolder(DocumentModel doc, CoreSession documentManager) throws ClientException {
        DocumentModelList docList = documentManager.getChildren(doc.getRef());
        for (DocumentModel docChild : docList) {
            if (docChild.getAdapter(BlobHolder.class) == null && !docChild.isFolder()) continue;
            return false;
        }
        return true;
    }

    private void addSummaryToZip(ZipOutputStream out, byte[] data, StringBuilder sb) throws IOException {
        StringBlob content = new StringBlob(sb.toString());
        BufferedInputStream buffi = new BufferedInputStream(content.getStream(), 2048);
        ZipEntry entry = new ZipEntry(SUMMARY_FILENAME);
        out.putNextEntry(entry);
        int count = buffi.read(data, 0, 2048);
        while (count != -1) {
            out.write(data, 0, count);
            count = buffi.read(data, 0, 2048);
        }
        out.closeEntry();
        buffi.close();
    }

    private void addBlobHolderToZip(String path, ZipOutputStream out, DocumentModel doc, byte[] data, StringBuilder blobList, BlobHolder bh, boolean exportAllBlobs) throws IOException, ClientException {
        List<Blob> blobs = new ArrayList();
        if (exportAllBlobs) {
            if (bh.getBlobs() != null) {
                blobs = bh.getBlobs();
            }
        } else {
            Blob mainBlob = bh.getBlob();
            if (mainBlob != null) {
                blobs.add(mainBlob);
            }
        }
        if (blobs.size() > 0) {
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            if (path.length() > 0) {
                blobList.append(path).append('/');
            }
            blobList.append(doc.getTitle()).append(" ");
            blobList.append(doc.getType()).append(" ");
            Calendar c = (Calendar)doc.getPropertyValue("dc:modified");
            if (c != null) {
                blobList.append(format.format(c.getTime()));
            }
            blobList.append("\n");
        }
        for (Blob content : blobs) {
            String fileName = content.getFilename();
            BufferedInputStream buffi = new BufferedInputStream(content.getStream(), 2048);
            int tryCount = 0;
            String entryPath = null;
            String entryName = null;
            while (true) {
                try {
                    ZipEntry entry = null;
                    entryName = tryCount == 0 ? fileName : this.formatFileName(fileName, "(" + tryCount + ")");
                    entryPath = path.length() == 0 ? entryName : path + "/" + entryName;
                    entryPath = this.escapeEntryPath(entryPath);
                    entry = new ZipEntry(entryPath);
                    out.putNextEntry(entry);
                }
                catch (ZipException e) {
                    ++tryCount;
                    continue;
                }
                break;
            }
            blobList.append(" - ").append(entryName).append("\n");
            int count = buffi.read(data, 0, 2048);
            while (count != -1) {
                out.write(data, 0, count);
                count = buffi.read(data, 0, 2048);
            }
            out.closeEntry();
            buffi.close();
        }
    }

    private String formatFileName(String filename, String count) {
        StringBuilder sb = new StringBuilder();
        CharSequence name = filename.subSequence(0, filename.lastIndexOf("."));
        CharSequence extension = filename.subSequence(filename.lastIndexOf("."), filename.length());
        sb.append(name).append(count).append(extension);
        return sb.toString();
    }

    protected String escapeEntryPath(String path) {
        String zipEntryEncoding = Framework.getProperty((String)ZIP_ENTRY_ENCODING_PROPERTY);
        if (zipEntryEncoding != null && zipEntryEncoding.equals(ZIP_ENTRY_ENCODING_OPTIONS.ascii.toString())) {
            return StringUtils.toAscii((String)path);
        }
        return path;
    }

    public static enum ZIP_ENTRY_ENCODING_OPTIONS {
        ascii;

    }
}

