/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.security.Principal;
import org.jboss.seam.annotations.In;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

public abstract class AbstractUserGroupManagement {
    public static final String VIEW_HOME = "view_home";
    public static final String MAIN_TABS_CATEGORY = "MAIN_TABS";
    public static final String MAIN_TAB_HOME = "MAIN_TABS:home";
    public static final String NUXEO_ADMIN_CATEGORY = "NUXEO_ADMIN";
    public static final String USER_CENTER_CATEGORY = "USER_CENTER";
    public static final String USERS_GROUPS_MANAGER = "UsersGroupsManager";
    public static final String USERS_GROUPS_MANAGER_SUB_TAB = "UsersGroupsManager_sub_tab";
    public static final String USERS_GROUPS_HOME = "UsersGroupsHome";
    public static final String USERS_GROUPS_HOME_SUB_TAB = "UsersGroupsHome_sub_tab";
    public static final String VALID_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-0123456789.@";
    public static final String DEFAULT_LISTING_MODE = "search_only";
    public static final String DETAILS_VIEW_MODE = "view";
    @In(create=true)
    protected Principal currentUser;
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected ContentViewActions contentViewActions;
    @In(create=true)
    protected WebActions webActions;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    protected String searchString = "";
    protected String listingMode;
    protected String detailsMode;
    protected boolean showCreateForm;
    protected boolean showUserOrGroup;

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getListingMode() throws ClientException {
        if (this.listingMode == null) {
            this.listingMode = this.computeListingMode();
            if (this.listingMode == null || this.listingMode.trim().isEmpty()) {
                this.listingMode = DEFAULT_LISTING_MODE;
            }
        }
        return this.listingMode;
    }

    protected abstract String computeListingMode() throws ClientException;

    public void setListingMode(String listingMode) {
        this.listingMode = listingMode;
    }

    public String getDetailsMode() {
        if (this.detailsMode == null) {
            this.detailsMode = DETAILS_VIEW_MODE;
        }
        return this.detailsMode;
    }

    public void setDetailsMode(String mode) {
        this.detailsMode = mode;
    }

    public boolean isShowCreateForm() {
        return this.showCreateForm;
    }

    public void toggleShowCreateForm() {
        this.showCreateForm = !this.showCreateForm;
    }

    public boolean isShowUserOrGroup() {
        return this.showUserOrGroup;
    }

    public void toggleShowUserOrGroup() {
        this.showUserOrGroup = !this.showUserOrGroup;
    }
}

