/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.TypeCache;
import org.apache.chemistry.opencmis.server.impl.browser.json.JSONConverter;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONStreamAware;

public class VersioningService {
    private VersioningService() {
    }

    public static void getAllVersions(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean includeAllowableActions;
        String filter;
        String objectId = (String)context.get("org.apache.chemistry.openmis.browserbinding.objectId");
        List versions = service.getAllVersions(repositoryId, objectId, null, filter = HttpUtils.getStringParameter(request, "filter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), null);
        if (versions == null) {
            throw new CmisRuntimeException("Versions are null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONArray jsonVersions = new JSONArray();
        for (ObjectData version : versions) {
            jsonVersions.add((Object)JSONConverter.convert(version, typeCache));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonVersions, request, response);
    }
}

