/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.forms;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormInstance;
import org.nuxeo.ecm.webengine.forms.validation.Form;
import org.nuxeo.ecm.webengine.forms.validation.FormManager;
import org.nuxeo.ecm.webengine.forms.validation.ValidationException;
import org.nuxeo.runtime.services.streaming.ByteArraySource;
import org.nuxeo.runtime.services.streaming.InputStreamSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class FormData
implements FormInstance {
    public static final String PROPERTY = "property";
    public static final String TITLE = "dc:title";
    public static final String DOCTYPE = "doctype";
    public static final String VERSIONING = "versioning";
    public static final String MAJOR = "major";
    public static final String MINOR = "minor";
    protected static ServletFileUpload fu = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
    protected final HttpServletRequest request;
    protected boolean isMultipart = false;
    protected RequestContext ctx;
    protected Map<String, List<FileItem>> items;

    public FormData(HttpServletRequest request) {
        this.request = request;
        this.isMultipart = this.getIsMultipartContent();
        if (this.isMultipart) {
            this.ctx = new ServletRequestContext(request);
        }
    }

    protected String getString(FileItem item) {
        try {
            return item.getString(this.request.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            return item.getString();
        }
    }

    protected boolean getIsMultipartContent() {
        String method = this.request.getMethod().toLowerCase();
        if (!"post".equals(method) && !"put".equals(method)) {
            return false;
        }
        String contentType = this.request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public boolean isMultipartContent() {
        return this.isMultipart;
    }

    @Override
    public Map<String, String[]> getFormFields() {
        if (this.isMultipart) {
            return this.getMultiPartFormFields();
        }
        return this.request.getParameterMap();
    }

    public Map<String, String[]> getMultiPartFormFields() {
        Map<String, List<FileItem>> items = this.getMultiPartItems();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Map.Entry<String, List<FileItem>> entry : items.entrySet()) {
            List<FileItem> list = entry.getValue();
            String[] ar = new String[list.size()];
            for (int i = 0; i < ar.length; ++i) {
                ar[i] = this.getString(list.get(i));
            }
            result.put(entry.getKey(), ar);
        }
        return result;
    }

    public Map<String, List<FileItem>> getMultiPartItems() {
        if (this.items == null) {
            if (!this.isMultipart) {
                throw new IllegalStateException("Not in a multi part form request");
            }
            try {
                this.items = new HashMap<String, List<FileItem>>();
                ServletRequestContext ctx = new ServletRequestContext(this.request);
                List fileItems = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest((RequestContext)ctx);
                for (FileItem item : fileItems) {
                    String key = item.getFieldName();
                    List<FileItem> list = this.items.get(key);
                    if (list == null) {
                        list = new ArrayList<FileItem>();
                        this.items.put(key, list);
                    }
                    list.add(item);
                }
            }
            catch (FileUploadException e) {
                throw WebException.wrap("Failed to get uploaded files", e);
            }
        }
        return this.items;
    }

    @Override
    public Collection<String> getKeys() {
        if (this.isMultipart) {
            return this.getMultiPartItems().keySet();
        }
        return this.request.getParameterMap().keySet();
    }

    @Override
    public Blob getBlob(String key) {
        FileItem item = this.getFileItem(key);
        return item == null ? null : this.getBlob(item);
    }

    @Override
    public Blob[] getBlobs(String key) {
        List<FileItem> list = this.getFileItems(key);
        Blob[] ar = null;
        if (list != null) {
            ar = new Blob[list.size()];
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                ar[i] = this.getBlob(list.get(i));
            }
        }
        return ar;
    }

    @Override
    public Map<String, Blob[]> getBlobFields() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Blob getFirstBlob() {
        Map<String, List<FileItem>> items = this.getMultiPartItems();
        for (List<FileItem> list : items.values()) {
            for (FileItem item : list) {
                if (item.isFormField()) continue;
                return this.getBlob(item);
            }
        }
        return null;
    }

    protected Blob getBlob(FileItem item) {
        ByteArraySource src;
        if (item.isInMemory()) {
            src = new ByteArraySource(item.get());
        } else {
            try {
                src = new InputStreamSource(item.getInputStream());
            }
            catch (IOException e) {
                throw WebException.wrap("Failed to get blob data", e);
            }
        }
        String ctype = item.getContentType();
        StreamingBlob blob = new StreamingBlob((StreamSource)src, ctype == null ? "application/octet-stream" : ctype);
        blob.setFilename(item.getName());
        return blob;
    }

    public final FileItem getFileItem(String key) {
        Map<String, List<FileItem>> items = this.getMultiPartItems();
        List<FileItem> list = items.get(key);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public final List<FileItem> getFileItems(String key) {
        return this.getMultiPartItems().get(key);
    }

    public String getMultiPartFormProperty(String key) {
        FileItem item = this.getFileItem(key);
        return item == null ? null : this.getString(item);
    }

    public String[] getMultiPartFormListProperty(String key) {
        List<FileItem> list = this.getFileItems(key);
        String[] ar = null;
        if (list != null) {
            ar = new String[list.size()];
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                ar[i] = this.getString(list.get(i));
            }
        }
        return ar;
    }

    public Object[] getMultiPartFormItems(String key) {
        return this.getMultiPartFormItems(this.getFileItems(key));
    }

    public Object[] getMultiPartFormItems(List<FileItem> list) {
        String[] ar;
        block5: {
            ar = null;
            if (list == null) break block5;
            if (list.isEmpty()) {
                return null;
            }
            FileItem item0 = list.get(0);
            if (item0.isFormField()) {
                ar = new String[list.size()];
                ar[0] = this.getString(item0);
                int len = list.size();
                for (int i = 1; i < len; ++i) {
                    ar[i] = this.getString(list.get(i));
                }
            } else {
                ar = new Blob[list.size()];
                ar[0] = this.getBlob(item0);
                int len = list.size();
                for (int i = 1; i < len; ++i) {
                    ar[i] = this.getBlob(list.get(i));
                }
            }
        }
        return ar;
    }

    public final Object getFileItemValue(FileItem item) {
        if (item.isFormField()) {
            return this.getString(item);
        }
        return this.getBlob(item);
    }

    public String getFormProperty(String key) {
        String[] value = this.request.getParameterValues(key);
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    public String[] getFormListProperty(String key) {
        return this.request.getParameterValues(key);
    }

    @Override
    public String getString(String key) {
        if (this.isMultipart) {
            return this.getMultiPartFormProperty(key);
        }
        return this.getFormProperty(key);
    }

    @Override
    public String[] getList(String key) {
        if (this.isMultipart) {
            return this.getMultiPartFormListProperty(key);
        }
        return this.getFormListProperty(key);
    }

    @Override
    public Object[] get(String key) {
        if (this.isMultipart) {
            return this.getMultiPartFormItems(key);
        }
        return this.getFormListProperty(key);
    }

    @Override
    public void fillDocument(DocumentModel doc) {
        try {
            if (this.isMultipart) {
                this.fillDocumentFromMultiPartForm(doc);
            } else {
                this.fillDocumentFromForm(doc);
            }
        }
        catch (PropertyException e) {
            throw WebException.wrap("Failed to fill document properties from request properties", e);
        }
    }

    public void fillDocumentFromForm(DocumentModel doc) throws PropertyException {
        Map map = this.request.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            Property p;
            String key = (String)entry.getKey();
            if (key.indexOf(58) <= -1) continue;
            try {
                p = doc.getProperty(key);
            }
            catch (PropertyException e) {
                continue;
            }
            catch (ClientException e) {
                throw WebException.wrap(e);
            }
            Object[] ar = (String[])entry.getValue();
            FormData.fillDocumentProperty(p, key, ar);
        }
    }

    public void fillDocumentFromMultiPartForm(DocumentModel doc) throws PropertyException {
        Map<String, List<FileItem>> map = this.getMultiPartItems();
        for (Map.Entry<String, List<FileItem>> entry : map.entrySet()) {
            Property p;
            String key = entry.getKey();
            if (key.indexOf(58) <= -1) continue;
            try {
                p = doc.getProperty(key);
            }
            catch (PropertyException e) {
                continue;
            }
            catch (ClientException e) {
                throw WebException.wrap(e);
            }
            List<FileItem> list = entry.getValue();
            if (list.isEmpty()) {
                FormData.fillDocumentProperty(p, key, null);
                continue;
            }
            Object[] ar = this.getMultiPartFormItems(list);
            FormData.fillDocumentProperty(p, key, ar);
        }
    }

    static void fillDocumentProperty(Property p, String key, Object[] ar) throws PropertyException {
        if (ar == null || ar.length == 0) {
            p.remove();
        } else if (p.isScalar()) {
            p.setValue(ar[0]);
        } else if (p.isList()) {
            if (!p.isContainer()) {
                p.setValue((Object)ar);
            } else {
                Type elType = ((ListType)p.getType()).getFieldType();
                if (elType.isSimpleType()) {
                    p.setValue((Object)ar);
                } else if ("content".equals(elType.getName())) {
                    ArrayList<Object> blobs = new ArrayList<Object>();
                    if (ar.getClass().getComponentType() == String.class) {
                        for (Object obj : ar) {
                            blobs.add(new StringBlob(obj.toString()));
                        }
                    } else {
                        for (Object obj : ar) {
                            blobs.add((Blob)obj);
                        }
                    }
                    p.setValue(blobs);
                }
            }
        } else if (p.isComplex() && p.getClass() == BlobProperty.class) {
            Object blob = null;
            blob = ar[0].getClass() == String.class ? new StringBlob(ar[0].toString()) : (Blob)ar[0];
            p.setValue(blob);
        }
    }

    public VersioningOption getVersioningOption() {
        String val = this.getString(VERSIONING);
        if (val != null) {
            return val.equals(MAJOR) ? VersioningOption.MAJOR : (val.equals(MINOR) ? VersioningOption.MINOR : null);
        }
        return null;
    }

    public String getDocumentType() {
        return this.getString(DOCTYPE);
    }

    public String getDocumentTitle() {
        return this.getString(TITLE);
    }

    public <T extends Form> T validate(Class<T> type) throws ValidationException {
        Form proxy = (Form)FormManager.newProxy(type);
        try {
            proxy.load(this, proxy);
            return (T)proxy;
        }
        catch (ValidationException e) {
            e.setForm(proxy);
            throw e;
        }
    }
}

