/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import com.sun.image.codec.jpeg.JPEGCodec;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.imageio.ImageIO;

public class AVI_Reader
extends VirtualStack
implements PlugIn {
    private static final int FOURCC_RIFF = 1179011410;
    private static final int FOURCC_AVI = 541677121;
    private static final int FOURCC_LIST = 1414744396;
    private static final int FOURCC_hdrl = 1819436136;
    private static final int FOURCC_avih = 1751742049;
    private static final int FOURCC_strl = 1819440243;
    private static final int FOURCC_strh = 1752331379;
    private static final int FOURCC_strf = 1718776947;
    private static final int FOURCC_movi = 1769369453;
    private static final int FOURCC_rec = 543384946;
    private static final int FOURCC_JUNK = 1263424842;
    private static final int FOURCC_vids = 1935960438;
    private static final int FOURCC_00db = 1650733104;
    private static final int FOURCC_00dc = 1667510320;
    private static final int NO_COMPRESSION = 0;
    private static final int NO_COMPRESSION_RGB = 541214546;
    private static final int NO_COMPRESSION_RAW = 542589266;
    private static final int NO_COMPRESSION_Y800 = 808466521;
    private static final int NO_COMPRESSION_Y8 = 538982489;
    private static final int NO_COMPRESSION_GREY = 1497715271;
    private static final int NO_COMPRESSION_Y16 = 540422489;
    private static final int AYUV_COMPRESSION = 1448433985;
    private static final int UYVY_COMPRESSION = 0x59565955;
    private static final int Y422_COMPRESSION = 1447975253;
    private static final int UYNV_COMPRESSION = 842151001;
    private static final int CYUV_COMPRESSION = 1987410275;
    private static final int V422_COMPRESSION = 842150998;
    private static final int YUY2_COMPRESSION = 844715353;
    private static final int YUNV_COMPRESSION = 1447974233;
    private static final int YUYV_COMPRESSION = 0x56595559;
    private static final int YVYU_COMPRESSION = 0x55595659;
    private static final int JPEG_COMPRESSION = 1734701162;
    private static final int JPEG_COMPRESSION2 = 1195724874;
    private static final int JPEG_COMPRESSION3 = 4;
    private static final int MJPG_COMPRESSION = 1196444237;
    private static final int PNG_COMPRESSION = 543649392;
    private static final int PNG_COMPRESSION2 = 541544016;
    private static final int PNG_COMPRESSION3 = 5;
    private static final int BITMASK24 = 65536;
    private static final long SIZE_MASK = 0xFFFFFFFFL;
    private static int firstFrameNumber = 1;
    private static int lastFrameNumber = 0;
    private static boolean convertToGray;
    private static boolean flipVertical;
    private static boolean isVirtual;
    private RandomAccessFile raFile;
    private String raFilePath;
    private boolean headerOK = false;
    private int streamNumber;
    private long fileSize = 0L;
    private int paddingGranularity = 2;
    private int dataCompression;
    private int scanLineSize;
    private boolean dataTopDown;
    private ColorModel cm;
    private boolean variableLength;
    private Vector frameInfos;
    private ImageStack stack;
    private ImagePlus imp;
    private boolean verbose = IJ.debugMode;
    private long startTime;
    private int dwMicroSecPerFrame;
    private int dwMaxBytesPerSec;
    private int dwReserved1;
    private int dwFlags;
    private int dwTotalFrames;
    private int dwInitialFrames;
    private int dwStreams;
    private int dwSuggestedBufferSize;
    private int dwWidth;
    private int dwHeight;
    private int fccStreamHandler;
    private int dwStreamFlags;
    private int dwPriorityLanguage;
    private int dwStreamInitialFrames;
    private int dwStreamScale;
    private int dwStreamRate;
    private int dwStreamStart;
    private int dwStreamLength;
    private int dwStreamSuggestedBufferSize;
    private int dwStreamQuality;
    private int dwStreamSampleSize;
    private int biSize;
    private int biWidth;
    private int biHeight;
    private short biPlanes;
    private short biBitCount;
    private int biCompression;
    private int biSizeImage;
    private int biXPelsPerMeter;
    private int biYPelsPerMeter;
    private int biClrUsed;
    private int biClrImportant;

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Select AVI File", arg);
        String fileName = od.getFileName();
        if (fileName == null) {
            return;
        }
        String fileDir = od.getDirectory();
        String path = fileDir + fileName;
        try {
            this.openAndReadHeader(path);
        }
        catch (Exception e) {
            IJ.showMessage("AVI Reader", this.exceptionMessage(e));
            return;
        }
        if (!this.showDialog(fileName)) {
            return;
        }
        try {
            ImageStack stack = this.makeStack(path, firstFrameNumber, lastFrameNumber, isVirtual, convertToGray, flipVertical);
        }
        catch (Exception e) {
            IJ.showMessage("AVI Reader", this.exceptionMessage(e));
            return;
        }
        if (this.stack == null) {
            return;
        }
        if (this.stack.getSize() == 0) {
            String rangeText = "";
            if (firstFrameNumber > 1 || lastFrameNumber != 0) {
                rangeText = "\nin Range " + firstFrameNumber + (lastFrameNumber > 0 ? " - " + lastFrameNumber : " - end");
            }
            IJ.showMessage("AVI Reader", "Error: No Frames Found" + rangeText);
            return;
        }
        this.imp = new ImagePlus(fileName, this.stack);
        this.setFramesPerSecond(this.imp);
        if (arg.equals("")) {
            this.imp.show();
        }
        IJ.showTime(this.imp, this.startTime, "Read AVI in ", this.stack.getSize());
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ImageStack makeStack(String path, int firstFrameNumber, int lastFrameNumber, boolean isVirtual, boolean convertToGray, boolean flipVertical) {
        String exceptionMessage;
        block18: {
            AVI_Reader.firstFrameNumber = firstFrameNumber;
            AVI_Reader.lastFrameNumber = lastFrameNumber;
            AVI_Reader.isVirtual = isVirtual;
            AVI_Reader.convertToGray = convertToGray;
            AVI_Reader.flipVertical = flipVertical;
            exceptionMessage = null;
            IJ.showProgress(0.001);
            this.readAVI(path);
            Object var10_8 = null;
            try {
                this.raFile.close();
                if (this.verbose) {
                    IJ.log("File closed.");
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            IJ.showProgress(1.0);
            {
                break block18;
                catch (OutOfMemoryError e) {
                    this.stack.trim();
                    IJ.showMessage("AVI Reader", "Out of memory.  " + this.stack.getSize() + " of " + this.dwTotalFrames + " frames will be opened.");
                    Object var10_9 = null;
                    try {
                        this.raFile.close();
                        if (this.verbose) {
                            IJ.log("File closed.");
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    IJ.showProgress(1.0);
                    break block18;
                }
                catch (Exception e) {
                    exceptionMessage = this.exceptionMessage(e);
                    Object var10_10 = null;
                    try {
                        this.raFile.close();
                        if (this.verbose) {
                            IJ.log("File closed.");
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    IJ.showProgress(1.0);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    this.raFile.close();
                    if (this.verbose) {
                        IJ.log("File closed.");
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                IJ.showProgress(1.0);
                throw throwable;
            }
        }
        if (exceptionMessage != null) {
            throw new RuntimeException(exceptionMessage);
        }
        if (isVirtual && this.frameInfos != null) {
            this.stack = this;
        }
        if (this.stack != null && this.cm != null) {
            this.stack.setColorModel(this.cm);
        }
        return this.stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ImageProcessor getProcessor(int n) {
        if (this.frameInfos == null || this.frameInfos.size() == 0 || this.raFilePath == null) {
            return null;
        }
        if (n < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        Object pixels = null;
        RandomAccessFile rFile = null;
        String exceptionMessage = null;
        try {
            rFile = new RandomAccessFile(new File(this.raFilePath), "r");
            long[] frameInfo = (long[])this.frameInfos.get(n - 1);
            pixels = this.readFrame(rFile, frameInfo[0], (int)frameInfo[1]);
        }
        catch (Exception e) {
            exceptionMessage = this.exceptionMessage(e);
        }
        finally {
            try {
                rFile.close();
            }
            catch (Exception e) {}
        }
        if (exceptionMessage != null) {
            throw new RuntimeException(exceptionMessage);
        }
        if (pixels == null) {
            return null;
        }
        if (pixels instanceof byte[]) {
            return new ByteProcessor(this.dwWidth, this.biHeight, (byte[])pixels, this.cm);
        }
        return new ColorProcessor(this.dwWidth, this.biHeight, (int[])pixels);
    }

    public int getWidth() {
        return this.dwWidth;
    }

    public int getHeight() {
        return this.biHeight;
    }

    public int getSize() {
        if (this.frameInfos == null) {
            return 0;
        }
        return this.frameInfos.size();
    }

    public String getSliceLabel(int n) {
        if (this.frameInfos == null || n < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("No Virtual Stack or argument out of range: " + n);
        }
        return this.frameLabel(((long[])this.frameInfos.get(n - 1))[2]);
    }

    public void deleteSlice(int n) {
        if (this.frameInfos == null || this.frameInfos.size() == 0) {
            return;
        }
        if (n < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        this.frameInfos.removeElementAt(n - 1);
    }

    private boolean showDialog(String fileName) {
        if (lastFrameNumber != -1) {
            lastFrameNumber = this.dwTotalFrames;
        }
        GenericDialog gd = new GenericDialog("AVI Reader");
        gd.addNumericField("First Frame: ", firstFrameNumber, 0);
        gd.addNumericField("Last Frame: ", lastFrameNumber, 0, 6, "");
        gd.addCheckbox("Use Virtual Stack", isVirtual);
        gd.addCheckbox("Convert to Grayscale", convertToGray);
        gd.addCheckbox("Flip Vertical", flipVertical);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        firstFrameNumber = (int)gd.getNextNumber();
        lastFrameNumber = (int)gd.getNextNumber();
        isVirtual = gd.getNextBoolean();
        convertToGray = gd.getNextBoolean();
        flipVertical = gd.getNextBoolean();
        IJ.register(this.getClass());
        return true;
    }

    private void readAVI(String path) throws Exception, IOException {
        if (!this.headerOK) {
            this.openAndReadHeader(path);
        }
        this.startTime += System.currentTimeMillis();
        this.findFourccAndRead(1769369453, true, this.fileSize, true);
    }

    private void openAndReadHeader(String path) throws Exception, IOException {
        this.startTime = System.currentTimeMillis();
        if (this.verbose) {
            IJ.log("OPEN AND READ AVI FILE HEADER " + this.timeString());
        }
        File file = new File(path);
        this.raFile = new RandomAccessFile(file, "r");
        this.raFilePath = path;
        this.fileSize = this.raFile.length();
        int fileType = this.readInt();
        if (this.verbose) {
            IJ.log("File header: File type='" + this.fourccString(fileType) + "' (should be 'RIFF')" + this.timeString());
        }
        if (fileType != 1179011410) {
            throw new Exception("Not an AVI file.");
        }
        this.readInt();
        int riffType = this.readInt();
        if (this.verbose) {
            IJ.log("File header: RIFF type='" + this.fourccString(riffType) + "' (should be 'AVI ')");
        }
        if (riffType != 541677121) {
            throw new Exception("Not an AVI file.");
        }
        this.findFourccAndRead(1819436136, true, this.fileSize, true);
        this.startTime -= System.currentTimeMillis();
        this.headerOK = true;
    }

    private long findFourccAndRead(int fourcc, boolean isList, long endPosition, boolean throwNotFoundException) throws Exception, IOException {
        long nextPos;
        boolean contentOk = false;
        do {
            int type;
            if ((type = this.readType(endPosition)) == 0) {
                if (throwNotFoundException) {
                    throw new Exception("Required item '" + this.fourccString(fourcc) + "' not found");
                }
                return -1L;
            }
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            nextPos = this.raFile.getFilePointer() + size;
            boolean foundList = false;
            if (isList && type == 1414744396) {
                foundList = true;
                type = this.readInt();
            }
            if (this.verbose) {
                IJ.log("Searching for '" + this.fourccString(fourcc) + "', found " + (foundList ? "LIST '" : "'") + this.fourccString(type) + "' " + this.posSizeString(nextPos - size, size));
            }
            if (type == fourcc) {
                contentOk = this.readContents(fourcc, nextPos);
            } else if (this.verbose) {
                IJ.log("Discarded '" + this.fourccString(type) + "': Contents does not fit");
            }
            this.raFile.seek(nextPos);
            if (!contentOk) continue;
            return nextPos;
        } while (!contentOk);
        return nextPos;
    }

    private boolean readContents(int fourcc, long endPosition) throws Exception, IOException {
        switch (fourcc) {
            case 1819436136: {
                this.findFourccAndRead(1751742049, false, endPosition, true);
                this.findFourccAndRead(1819440243, true, endPosition, true);
                return true;
            }
            case 1751742049: {
                this.readAviHeader();
                return true;
            }
            case 1819440243: {
                long nextPosition = this.findFourccAndRead(1752331379, false, endPosition, false);
                if (nextPosition < 0L) {
                    return false;
                }
                this.findFourccAndRead(1718776947, false, endPosition, true);
                return true;
            }
            case 1752331379: {
                int streamType = this.readInt();
                if (streamType != 1935960438) {
                    if (this.verbose) {
                        IJ.log("Non-video Stream '" + this.fourccString(streamType) + " skipped");
                    }
                    ++this.streamNumber;
                    return false;
                }
                this.readStreamHeader();
                return true;
            }
            case 1718776947: {
                this.readBitMapInfo(endPosition);
                return true;
            }
            case 1769369453: {
                this.readMovieData(endPosition);
                return true;
            }
        }
        throw new Exception("Program error, type " + this.fourccString(fourcc));
    }

    void readAviHeader() throws Exception, IOException {
        this.dwMicroSecPerFrame = this.readInt();
        this.dwMaxBytesPerSec = this.readInt();
        this.dwReserved1 = this.readInt();
        this.dwFlags = this.readInt();
        this.dwTotalFrames = this.readInt();
        this.dwInitialFrames = this.readInt();
        this.dwStreams = this.readInt();
        this.dwSuggestedBufferSize = this.readInt();
        this.dwWidth = this.readInt();
        this.dwHeight = this.readInt();
        if (this.verbose) {
            IJ.log("AVI HEADER (avih):" + this.timeString());
            IJ.log("   dwMicroSecPerFrame=" + this.dwMicroSecPerFrame);
            IJ.log("   dwMaxBytesPerSec=" + this.dwMaxBytesPerSec);
            IJ.log("   dwReserved1=" + this.dwReserved1);
            IJ.log("   dwFlags=" + this.dwFlags);
            IJ.log("   dwTotalFrames=" + this.dwTotalFrames);
            IJ.log("   dwInitialFrames=" + this.dwInitialFrames);
            IJ.log("   dwStreams=" + this.dwStreams);
            IJ.log("   dwSuggestedBufferSize=" + this.dwSuggestedBufferSize);
            IJ.log("   dwWidth=" + this.dwWidth);
            IJ.log("   dwHeight=" + this.dwHeight);
        }
    }

    void readStreamHeader() throws Exception, IOException {
        this.fccStreamHandler = this.readInt();
        this.dwStreamFlags = this.readInt();
        this.dwPriorityLanguage = this.readInt();
        this.dwStreamInitialFrames = this.readInt();
        this.dwStreamScale = this.readInt();
        this.dwStreamRate = this.readInt();
        this.dwStreamStart = this.readInt();
        this.dwStreamLength = this.readInt();
        this.dwStreamSuggestedBufferSize = this.readInt();
        this.dwStreamQuality = this.readInt();
        this.dwStreamSampleSize = this.readInt();
        if (this.verbose) {
            IJ.log("VIDEO STREAM HEADER (strh):");
            IJ.log("   fccStreamHandler='" + this.fourccString(this.fccStreamHandler) + "'");
            IJ.log("   dwStreamFlags=" + this.dwStreamFlags);
            IJ.log("   wPriority,wLanguage=" + this.dwPriorityLanguage);
            IJ.log("   dwStreamInitialFrames=" + this.dwStreamInitialFrames);
            IJ.log("   dwStreamScale=" + this.dwStreamScale);
            IJ.log("   dwStreamRate=" + this.dwStreamRate);
            IJ.log("   dwStreamStart=" + this.dwStreamStart);
            IJ.log("   dwStreamLength=" + this.dwStreamLength);
            IJ.log("   dwStreamSuggestedBufferSize=" + this.dwStreamSuggestedBufferSize);
            IJ.log("   dwStreamQuality=" + this.dwStreamQuality);
            IJ.log("   dwStreamSampleSize=" + this.dwStreamSampleSize);
        }
        if (this.dwStreamSampleSize > 1) {
            throw new Exception("Video stream with " + this.dwStreamSampleSize + " (more than 1) frames/chunk not supported");
        }
    }

    void readBitMapInfo(long endPosition) throws Exception, IOException {
        int bitCountTest;
        this.biSize = this.readInt();
        this.biWidth = this.readInt();
        this.biHeight = this.readInt();
        this.biPlanes = this.readShort();
        this.biBitCount = this.readShort();
        this.biCompression = this.readInt();
        this.biSizeImage = this.readInt();
        this.biXPelsPerMeter = this.readInt();
        this.biYPelsPerMeter = this.readInt();
        this.biClrUsed = this.readInt();
        this.biClrImportant = this.readInt();
        if (this.verbose) {
            IJ.log("   biSize=" + this.biSize);
            IJ.log("   biWidth=" + this.biWidth);
            IJ.log("   biHeight=" + this.biHeight);
            IJ.log("   biPlanes=" + this.biPlanes);
            IJ.log("   biBitCount=" + this.biBitCount);
            IJ.log("   biCompression=0x" + Integer.toHexString(this.biCompression) + " '" + this.fourccString(this.biCompression) + "'");
            IJ.log("   biSizeImage=" + this.biSizeImage);
            IJ.log("   biXPelsPerMeter=" + this.biXPelsPerMeter);
            IJ.log("   biYPelsPerMeter=" + this.biYPelsPerMeter);
            IJ.log("   biClrUsed=" + this.biClrUsed);
            IJ.log("   biClrImportant=" + this.biClrImportant);
        }
        int allowedBitCount = 0;
        boolean readPalette = false;
        switch (this.biCompression) {
            case 0: 
            case 541214546: 
            case 542589266: {
                this.dataCompression = 0;
                this.dataTopDown = this.biHeight < 0;
                allowedBitCount = 65576;
                readPalette = this.biBitCount <= 8;
                break;
            }
            case 538982489: 
            case 808466521: 
            case 1497715271: {
                this.dataTopDown = true;
                this.dataCompression = 0;
                allowedBitCount = 8;
                break;
            }
            case 540422489: {
                this.dataCompression = 0;
                allowedBitCount = 16;
                break;
            }
            case 1448433985: {
                this.dataCompression = 1448433985;
                allowedBitCount = 32;
                break;
            }
            case 842151001: 
            case 0x59565955: {
                this.dataTopDown = true;
            }
            case 842150998: 
            case 1987410275: {
                this.dataCompression = 0x59565955;
                allowedBitCount = 16;
                break;
            }
            case 844715353: 
            case 1447974233: 
            case 0x56595559: {
                this.dataTopDown = true;
                this.dataCompression = 844715353;
                allowedBitCount = 16;
                break;
            }
            case 0x55595659: {
                this.dataTopDown = true;
                this.dataCompression = 0x55595659;
                allowedBitCount = 16;
                break;
            }
            case 4: 
            case 1195724874: 
            case 1196444237: 
            case 1734701162: {
                this.dataCompression = 1734701162;
                this.variableLength = true;
                break;
            }
            case 5: 
            case 541544016: 
            case 543649392: {
                this.variableLength = true;
                this.dataCompression = 543649392;
                break;
            }
            default: {
                throw new Exception("Unsupported compression: " + Integer.toHexString(this.biCompression) + (this.biCompression >= 0x20202020 ? " '" + this.fourccString(this.biCompression) + "'" : ""));
            }
        }
        int n = bitCountTest = this.biBitCount == 24 ? 65536 : (int)this.biBitCount;
        if (allowedBitCount != 0 && (bitCountTest & allowedBitCount) == 0) {
            throw new Exception("Unsupported: " + this.biBitCount + " bits/pixel for compression '" + this.fourccString(this.biCompression) + "'");
        }
        if (this.biHeight < 0) {
            this.biHeight = -this.biHeight;
        }
        this.scanLineSize = (this.biWidth * this.biBitCount + 31) / 32 * 4;
        if (readPalette && this.biClrUsed == 0) {
            this.biClrUsed = 1 << this.biBitCount;
        }
        if (this.verbose) {
            IJ.log("   > data compression=0x" + Integer.toHexString(this.dataCompression) + " '" + this.fourccString(this.dataCompression) + "'");
            IJ.log("   > palette colors=" + this.biClrUsed);
            IJ.log("   > scan line size=" + this.scanLineSize);
            IJ.log("   > data top down=" + this.dataTopDown);
        }
        if (readPalette) {
            long spaceForPalette = endPosition - this.raFile.getFilePointer();
            if (this.verbose) {
                IJ.log("   Reading " + this.biClrUsed + " Palette colors: " + this.posSizeString(spaceForPalette));
            }
            if (spaceForPalette < (long)(this.biClrUsed * 4)) {
                throw new Exception("Not enough data (" + spaceForPalette + ") for palette of size " + this.biClrUsed * 4);
            }
            byte[] pr = new byte[this.biClrUsed];
            byte[] pg = new byte[this.biClrUsed];
            byte[] pb = new byte[this.biClrUsed];
            for (int i = 0; i < this.biClrUsed; ++i) {
                pb[i] = this.raFile.readByte();
                pg[i] = this.raFile.readByte();
                pr[i] = this.raFile.readByte();
                this.raFile.readByte();
            }
            this.cm = new IndexColorModel((int)this.biBitCount, this.biClrUsed, pr, pg, pb);
        }
    }

    void readMovieData(long endPosition) throws Exception, IOException {
        int type;
        if (this.verbose) {
            IJ.log("MOVIE DATA " + this.posSizeString(endPosition - this.raFile.getFilePointer()) + this.timeString());
        }
        int type0xdb = 1650733104 + (this.streamNumber << 8);
        int type0xdc = 1667510320 + (this.streamNumber << 8);
        if (this.verbose) {
            IJ.log("Searching for stream " + this.streamNumber + ": '" + this.fourccString(type0xdb) + "' or '" + this.fourccString(type0xdc) + "' chunks");
        }
        int lastFrameToRead = Integer.MAX_VALUE;
        if (lastFrameNumber > 0) {
            lastFrameToRead = lastFrameNumber;
        }
        if (lastFrameNumber < 0 && this.dwTotalFrames > 0) {
            lastFrameToRead = this.dwTotalFrames + lastFrameNumber;
        }
        if (isVirtual) {
            this.frameInfos = new Vector(100);
        } else {
            this.stack = new ImageStack(this.dwWidth, this.biHeight);
        }
        int frameNumber = 1;
        while ((type = this.readType(endPosition)) != 0) {
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            long pos = this.raFile.getFilePointer();
            long nextPos = pos + size;
            if (type == type0xdb || type == type0xdc) {
                this.updateProgress();
                if (this.verbose) {
                    IJ.log("movie data '" + this.fourccString(type) + "' " + this.posSizeString(size) + this.timeString());
                }
                if (frameNumber >= firstFrameNumber) {
                    if (isVirtual) {
                        this.frameInfos.add(new long[]{pos, size, frameNumber * this.dwMicroSecPerFrame});
                    } else {
                        Object pixels = this.readFrame(this.raFile, pos, (int)size);
                        String label = this.frameLabel(frameNumber * this.dwMicroSecPerFrame);
                        this.stack.addSlice(label, pixels);
                    }
                }
                if (++frameNumber > lastFrameToRead) {
                    break;
                }
            } else if (this.verbose) {
                IJ.log("skipped '" + this.fourccString(type) + "' " + this.posSizeString(size));
            }
            if (nextPos > endPosition) break;
            this.raFile.seek(nextPos);
        }
    }

    private Object readFrame(RandomAccessFile rFile, long filePos, int size) throws Exception, IOException {
        rFile.seek(filePos);
        if (this.variableLength) {
            return this.readCompressedFrame(rFile, size);
        }
        return this.readFixedLengthFrame(rFile, size);
    }

    private Object readCompressedFrame(RandomAccessFile rFile, int size) throws Exception, IOException {
        raInputStream inputStream = new raInputStream(rFile, size, this.biCompression == 1196444237);
        BufferedImage bi = null;
        bi = this.dataCompression == 1734701162 ? JPEGCodec.createJPEGDecoder((InputStream)inputStream).decodeAsBufferedImage() : ImageIO.read(inputStream);
        int type = bi.getType();
        ImageProcessor ip = null;
        if (type == 10) {
            ip = new ByteProcessor(bi);
        } else if (type == 13) {
            this.cm = bi.getColorModel();
            ip = new ByteProcessor((Image)bi);
        } else {
            ip = new ColorProcessor(bi);
        }
        if (convertToGray) {
            ip = ip.convertToByte(false);
        }
        if (flipVertical) {
            ((ImageProcessor)ip).flipVertical();
        }
        return ((ImageProcessor)ip).getPixels();
    }

    private Object readFixedLengthFrame(RandomAccessFile rFile, int size) throws Exception, IOException {
        if (size < this.scanLineSize * this.biHeight) {
            throw new Exception("Data chunk size " + size + " too short (" + this.scanLineSize * this.biHeight + " required)");
        }
        byte[] rawData = new byte[size];
        int n = rFile.read(rawData, 0, size);
        if (n < rawData.length) {
            throw new Exception("Frame ended prematurely after " + n + " bytes");
        }
        boolean topDown = flipVertical ? !this.dataTopDown : this.dataTopDown;
        Object[] pixels = null;
        byte[] bPixels = null;
        int[] cPixels = null;
        if (this.biBitCount <= 8 || convertToGray) {
            pixels = bPixels = new byte[this.dwWidth * this.biHeight];
        } else {
            cPixels = new int[this.dwWidth * this.biHeight];
            pixels = cPixels;
        }
        int offset = topDown ? 0 : (this.biHeight - 1) * this.dwWidth;
        int rawOffset = 0;
        for (int i = this.biHeight - 1; i >= 0; --i) {
            if (this.biBitCount <= 8) {
                this.unpack8bit(rawData, rawOffset, bPixels, offset, this.dwWidth);
            } else if (convertToGray) {
                this.unpackGray(rawData, rawOffset, bPixels, offset, this.dwWidth);
            } else {
                this.unpack(rawData, rawOffset, cPixels, offset, this.dwWidth);
            }
            rawOffset += this.scanLineSize;
            offset += topDown ? this.dwWidth : -this.dwWidth;
        }
        return pixels;
    }

    void unpack8bit(byte[] rawData, int rawOffset, byte[] pixels, int byteOffset, int w) {
        for (int i = 0; i < w; ++i) {
            pixels[byteOffset + i] = rawData[rawOffset + i];
        }
    }

    void unpackGray(byte[] rawData, int rawOffset, byte[] pixels, int byteOffset, int w) {
        int j = byteOffset;
        int k = rawOffset;
        if (this.dataCompression == 0) {
            for (int i = 0; i < w; ++i) {
                int b0 = rawData[k++] & 0xFF;
                int b1 = rawData[k++] & 0xFF;
                int b2 = rawData[k++] & 0xFF;
                if (this.biBitCount == 32) {
                    ++k;
                }
                pixels[j++] = (byte)(b0 * 934 + b1 * 4809 + b2 * 2449 + 4096 >> 13);
            }
        } else {
            if (this.dataCompression == 0x59565955 || this.dataCompression == 1448433985) {
                ++k;
            }
            int step = this.dataCompression == 1448433985 ? 4 : 2;
            for (int i = 0; i < w; ++i) {
                pixels[j++] = rawData[k];
                k += step;
            }
        }
    }

    void unpack(byte[] rawData, int rawOffset, int[] pixels, int intOffset, int w) {
        int j = intOffset;
        int k = rawOffset;
        switch (this.dataCompression) {
            case 0: {
                for (int i = 0; i < w; ++i) {
                    int b0 = rawData[k++] & 0xFF;
                    int b1 = (rawData[k++] & 0xFF) << 8;
                    int b2 = (rawData[k++] & 0xFF) << 16;
                    if (this.biBitCount == 32) {
                        ++k;
                    }
                    pixels[j++] = 0xFF000000 | b0 | b1 | b2;
                }
                break;
            }
            case 844715353: {
                for (int i = 0; i < w / 2; ++i) {
                    int y0 = rawData[k++] & 0xFF;
                    int u = rawData[k++] ^ 0xFFFFFF80;
                    int y1 = rawData[k++] & 0xFF;
                    int v = rawData[k++] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(y0, u, v, pixels, j++);
                    this.writeRGBfromYUV(y1, u, v, pixels, j++);
                }
                break;
            }
            case 0x59565955: {
                for (int i = 0; i < w / 2; ++i) {
                    int u = rawData[k++] ^ 0xFFFFFF80;
                    int y0 = rawData[k++] & 0xFF;
                    int v = rawData[k++] ^ 0xFFFFFF80;
                    int y1 = rawData[k++] & 0xFF;
                    this.writeRGBfromYUV(y0, u, v, pixels, j++);
                    this.writeRGBfromYUV(y1, u, v, pixels, j++);
                }
                break;
            }
            case 0x55595659: {
                for (int i = 0; i < w / 2; ++i) {
                    int y0 = rawData[k++] & 0xFF;
                    int v = rawData[k++] ^ 0xFFFFFF80;
                    int y1 = rawData[k++] & 0xFF;
                    int u = rawData[k++] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(y0, u, v, pixels, j++);
                    this.writeRGBfromYUV(y1, u, v, pixels, j++);
                }
                break;
            }
            case 1448433985: {
                for (int i = 0; i < w; ++i) {
                    int n = ++k;
                    int y = rawData[n] & 0xFF;
                    int n2 = ++k;
                    int v = rawData[n2] ^ 0xFFFFFF80;
                    int n3 = ++k;
                    ++k;
                    int u = rawData[n3] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(y, u, v, pixels, j++);
                }
                break;
            }
        }
    }

    void writeRGBfromYUV(int y, int u, int v, int[] pixels, int intArrayIndex) {
        int r = 9535 * y + 13074 * v - 148464 >> 13;
        int g = 9535 * y - 6660 * v - 3203 * u - 148464 >> 13;
        int b = 9535 * y + 16531 * u - 148464 >> 13;
        if (r > 255) {
            r = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (b > 255) {
            b = 255;
        }
        if (b < 0) {
            b = 0;
        }
        pixels[intArrayIndex] = 0xFF000000 | r << 16 | g << 8 | b;
    }

    int readInt() throws IOException {
        int result = 0;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (this.raFile.readByte() & 0xFF) << shiftBy;
        }
        return result;
    }

    short readShort() throws IOException {
        int low = this.raFile.readByte() & 0xFF;
        int high = this.raFile.readByte() & 0xFF;
        return (short)(high << 8 | low);
    }

    private int readType(long endPosition) throws IOException {
        while (true) {
            long pos;
            if ((pos = this.raFile.getFilePointer()) % (long)this.paddingGranularity != 0L) {
                pos = (pos / (long)this.paddingGranularity + 1L) * (long)this.paddingGranularity;
                this.raFile.seek(pos);
            }
            if (pos >= endPosition) {
                return 0;
            }
            int type = this.readInt();
            if (type != 1263424842) {
                return type;
            }
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            if (this.verbose) {
                IJ.log("Skip JUNK: " + this.posSizeString(size));
            }
            this.raFile.seek(this.raFile.getFilePointer() + size);
        }
    }

    private void setFramesPerSecond(ImagePlus imp) {
        if (this.dwMicroSecPerFrame < 1000 && this.dwStreamRate > 0) {
            this.dwMicroSecPerFrame = (int)((double)this.dwStreamScale * 1000000.0 / (double)this.dwStreamRate);
        }
        if (this.dwMicroSecPerFrame >= 1000) {
            imp.getCalibration().fps = 1000000.0 / (double)this.dwMicroSecPerFrame;
        }
    }

    private String frameLabel(long timeMicroSec) {
        return IJ.d2s((double)timeMicroSec / 1000000.0) + " s";
    }

    private String posSizeString(long size) throws IOException {
        return this.posSizeString(this.raFile.getFilePointer(), size);
    }

    private String posSizeString(long pos, long size) throws IOException {
        return "0x" + Long.toHexString(pos) + "-0x" + Long.toHexString(pos + size - 1L) + " (" + size + " Bytes)";
    }

    private String timeString() {
        return " (t=" + (System.currentTimeMillis() - this.startTime) + " ms)";
    }

    private String fourccString(int fourcc) {
        String s = "";
        for (int i = 0; i < 4; ++i) {
            int c = fourcc & 0xFF;
            s = s + Character.toString((char)c);
            fourcc >>= 8;
        }
        return s;
    }

    private String exceptionMessage(Exception e) {
        String msg = e.getClass() == Exception.class ? e.getMessage() : e + "\n" + e.getStackTrace()[0] + "\n" + e.getStackTrace()[1];
        return "An error occurred reading the file.\n \n" + msg;
    }

    void updateProgress() throws IOException {
        IJ.showProgress((double)this.raFile.getFilePointer() / (double)this.fileSize);
    }

    class raInputStream
    extends InputStream {
        RandomAccessFile rFile;
        int readableSize;
        boolean fixMJPG;

        raInputStream(RandomAccessFile rFile, int readableSize, boolean fixMJPG) {
            this.rFile = rFile;
            this.readableSize = readableSize;
            this.fixMJPG = fixMJPG;
        }

        public int available() {
            return this.readableSize;
        }

        public int read() throws IOException {
            this.fixMJPG = false;
            return this.rFile.read();
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int nBytes = this.rFile.read(b, off, len);
            if (this.fixMJPG) {
                this.doFixMJPG(b, nBytes);
                this.fixMJPG = false;
            }
            return nBytes;
        }

        private void doFixMJPG(byte[] b, int len) {
            int segmentLength;
            if (this.readShort(b, 0) != 65496 || len < 6) {
                return;
            }
            int offset = 2;
            do {
                int code;
                if ((code = this.readShort(b, offset)) == 65498 || code == 65497) {
                    return;
                }
                if (code == 65506) {
                    b[offset + 1] = -60;
                    return;
                }
                offset += 2;
            } while ((offset += (segmentLength = this.readShort(b, offset))) <= len - 4 && segmentLength >= 0);
        }

        private int readShort(byte[] b, int offset) {
            return (b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF;
        }
    }
}

