/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.webengine.gadgets.render;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.nuxeo.opensocial.gadgets.service.InternalGadgetDescriptor;
import org.nuxeo.opensocial.webengine.gadgets.render.HierarchicalResourceBundle;

public class Gadgeti18n {
    public static final String DYN_TRANSLATION_FILE = "dynamic_messages.properties";
    protected static final String EMPTY_I18N_FILE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><messagebundle></messagebundle>";
    protected Map<String, Boolean> isDynamicTranslation = new HashMap<String, Boolean>();
    protected String[] langs = new String[]{"en", "fr", "de", "it", "es", "pt", "pl", "eu", "ru", "ar", "cn", "ja", "vn"};
    protected List<Locale> supportedLang;

    public InputStream getTranslationFile(InternalGadgetDescriptor gadget, String fileName) throws IOException {
        if (this.usesDynamicTranslation(gadget)) {
            return this.loadDynamicFile(gadget, fileName);
        }
        return gadget.getResourceAsStream(fileName);
    }

    public List<Locale> getSupportedLangs() {
        if (this.supportedLang == null) {
            this.supportedLang = new ArrayList<Locale>();
            for (String lang : this.langs) {
                this.supportedLang.add(new Locale(lang));
            }
        }
        return this.supportedLang;
    }

    protected boolean usesDynamicTranslation(InternalGadgetDescriptor gadget) {
        Boolean isDynamic = this.isDynamicTranslation.get(gadget.getName());
        if (isDynamic == null) {
            try {
                InputStream dynDescriptor = gadget.getResourceAsStream(DYN_TRANSLATION_FILE);
                this.generateDynamicTranslations(gadget, dynDescriptor);
                isDynamic = true;
            }
            catch (IOException e) {
                isDynamic = false;
            }
            this.isDynamicTranslation.put(gadget.getName(), isDynamic);
        }
        return isDynamic;
    }

    protected File getDynamicFile(InternalGadgetDescriptor gadget, String fileName) throws IOException {
        File targetDirectory = new File(System.getProperty("java.io.tmpdir", "/tmp") + "/gadget-cache-" + gadget.getName());
        if (!targetDirectory.exists()) {
            targetDirectory.mkdir();
        }
        return new File(targetDirectory.getAbsolutePath() + "/" + fileName);
    }

    protected InputStream loadDynamicFile(InternalGadgetDescriptor gadget, String fileName) throws IOException {
        File resource = this.getDynamicFile(gadget, fileName);
        if (resource == null || !resource.exists()) {
            return new ByteArrayInputStream(EMPTY_I18N_FILE.getBytes("UTF-8"));
        }
        return new FileInputStream(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateDynamicTranslations(InternalGadgetDescriptor gadget, InputStream dynDescriptor) throws IOException {
        HierarchicalResourceBundle descriptor = new HierarchicalResourceBundle(dynDescriptor);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (Locale locale : this.getSupportedLangs()) {
            ResourceBundle bundle = ResourceBundle.getBundle("messages", locale, cl);
            File messageFile = this.getDynamicFile(gadget, "messages_" + locale.toString() + ".xml");
            Enumeration<String> keys = descriptor.getKeys();
            PrintWriter printer = new PrintWriter(new FileOutputStream(messageFile));
            try {
                printer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                printer.println("<messagebundle>");
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    String value = null;
                    try {
                        value = bundle.getString(key);
                    }
                    catch (MissingResourceException e) {
                        value = descriptor.getString(key);
                    }
                    if (value == null) continue;
                    printer.print("<msg name=\"");
                    printer.print(key);
                    printer.print("\">");
                    printer.print(value);
                    printer.println("</msg>");
                }
                printer.println("</messagebundle>");
            }
            finally {
                printer.close();
            }
        }
    }
}

