/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.Map;
import org.nuxeo.common.utils.URLStreamHandlerFactoryInstaller;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.perspectives.PerspectiveManager;
import org.nuxeo.theme.protocol.nxtheme.Handler;
import org.nuxeo.theme.relations.RelationStorage;
import org.nuxeo.theme.resources.ResourceManager;
import org.nuxeo.theme.services.ThemeService;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeRegistry;
import org.nuxeo.theme.uids.UidManager;
import org.nuxeo.theme.vocabularies.VocabularyManager;

public final class Manager {
    private static final String PROTOCOL_HANDLER_PKG = "org.nuxeo.theme.protocol";
    protected static URLStreamHandlerFactory shf;

    private Manager() {
    }

    private static ThemeService getThemeService() {
        return (ThemeService)((Object)Framework.getRuntime().getComponent(ThemeService.ID));
    }

    private static Map<String, Registrable> getRegistries() {
        ThemeService service = Manager.getThemeService();
        if (service != null) {
            return service.getRegistries();
        }
        return Collections.emptyMap();
    }

    public static Registrable getRegistry(String name) {
        return Manager.getRegistries().get(name);
    }

    public static RelationStorage getRelationStorage() {
        return (RelationStorage)Manager.getRegistry("relations");
    }

    public static UidManager getUidManager() {
        return (UidManager)Manager.getRegistry("uids");
    }

    public static ThemeManager getThemeManager() {
        return (ThemeManager)Manager.getRegistry("themes");
    }

    public static TypeRegistry getTypeRegistry() {
        return (TypeRegistry)Manager.getRegistry("types");
    }

    public static ResourceManager getResourceManager() {
        return (ResourceManager)Manager.getRegistry("resources");
    }

    public static PerspectiveManager getPerspectiveManager() {
        return (PerspectiveManager)Manager.getRegistry("perspectives");
    }

    public static VocabularyManager getVocabularyManager() {
        return (VocabularyManager)Manager.getRegistry("vocabularies");
    }

    public static void initializeProtocols() {
        shf = new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if ("nxtheme".equals(protocol)) {
                    return new Handler();
                }
                return null;
            }
        };
        try {
            URLStreamHandlerFactoryInstaller.installURLStreamHandlerFactory((URLStreamHandlerFactory)shf);
        }
        catch (Throwable e) {
            throw new Error("Cannot install nxtheme protocol handler");
        }
    }

    public static void resetProtocols() {
        URLStreamHandlerFactoryInstaller.uninstallURLStreamHandlerFactory((URLStreamHandlerFactory)shf);
        shf = null;
    }
}

