/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.ImageUtils;
import it.tidalwave.image.jai.JAIUtils;
import it.tidalwave.image.op.ConvertColorProfileOp;
import it.tidalwave.image.op.OperationImplementation;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.ColorConvertDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertColorProfileJAIOp
extends OperationImplementation<ConvertColorProfileOp, PlanarImage> {
    private static final String CLASS = ConvertColorProfileJAIOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected PlanarImage execute(ConvertColorProfileOp operation, PlanarImage planarImage) {
        ICC_Profile iccProfile = operation.getICCProfile();
        logger.fine("convertColorProfile(" + ImageUtils.getICCProfileName((ICC_Profile)iccProfile) + ") - " + planarImage.getSampleModel());
        planarImage = ColorConvertDescriptor.create((RenderedImage)planarImage, (ColorModel)JAIUtils.getColorModel(planarImage, iccProfile), null);
        JAIUtils.logImage((Logger)logger, (String)">>>>   convertColorProfile() returning", (RenderedImage)planarImage);
        return planarImage;
    }
}

