/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.EditableImage;
import it.tidalwave.image.ImageFunction;
import it.tidalwave.image.jai.CreateJAIOp;
import it.tidalwave.image.jai.JAIUtils;
import it.tidalwave.image.op.CreateFunctionOp;
import it.tidalwave.image.op.OperationImplementation;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFunctionJAIOp
extends OperationImplementation<CreateFunctionOp, PlanarImage> {
    private static final String CLASS = CreateJAIOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected PlanarImage execute(CreateFunctionOp operation, PlanarImage planarImage) {
        assert (operation.getDataType() == EditableImage.DataType.FLOAT);
        ParameterBlock pb = new ParameterBlock();
        pb.add(new JAIImageFunctionAdapter(operation.getImageFunction()));
        pb.add(operation.getWidth());
        pb.add(operation.getHeight());
        pb.add(1.0f);
        pb.add(1.0f);
        pb.add(0.0f);
        pb.add(0.0f);
        planarImage = JAI.create((String)"imagefunction", (ParameterBlock)pb);
        JAIUtils.logImage((Logger)logger, (String)">>>> CreateFunctionJAIOp returning", (RenderedImage)planarImage);
        return planarImage;
    }

    class JAIImageFunctionAdapter
    implements javax.media.jai.ImageFunction {
        private ImageFunction imageFunction;

        public JAIImageFunctionAdapter(ImageFunction imageFunction) {
            this.imageFunction = imageFunction;
        }

        public boolean isComplex() {
            return this.imageFunction.isComplex();
        }

        public int getNumElements() {
            return this.imageFunction.getNumElements();
        }

        public void getElements(float f, float f0, float f1, float f2, int i, int i0, int i1, float[] f3, float[] f4) {
            this.imageFunction.getElements(f, f0, f1, f2, i, i0, i1, f3, f4);
        }

        public void getElements(double d, double d0, double d1, double d2, int i, int i0, int i1, double[] d3, double[] d4) {
            this.imageFunction.getElements(d, d0, d1, d2, i, i0, i1, d3, d4);
        }
    }
}

