/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.EditableImage;
import it.tidalwave.image.Quality;
import it.tidalwave.image.java2d.Java2DUtils;
import java.awt.RenderingHints;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.BorderDescriptor;
import javax.media.jai.operator.ColorConvertDescriptor;
import javax.media.jai.operator.ConvolveDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.ScaleDescriptor;

public class JAIUtils
extends Java2DUtils {
    private static final String CLASS = JAIUtils.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final int[] POWER2_SIZES = new int[]{32, 64, 128, 256, 512, 1024, 2048, 4096, 8192};

    public static PlanarImage jaiMagnification(PlanarImage source, double scale, Quality quality, RenderingHints hints) {
        assert (scale >= 1.0);
        PlanarImage result = source;
        if (scale != 1.0) {
            logger.finer(">>>> jaiMagnification(" + scale + ", " + quality + ")");
            Float fScale = new Float(scale);
            Float fZero = new Float(0.0f);
            Interpolation interpolation = null;
            switch (quality) {
                case BEST: {
                    interpolation = Interpolation.getInstance((int)3);
                    break;
                }
                case FASTEST: {
                    interpolation = Interpolation.getInstance((int)0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(quality.toString());
                }
            }
            logger.finer(">>>> Scale(" + scale + ", " + interpolation + ")");
            result = ScaleDescriptor.create((RenderedImage)source, (Float)fScale, (Float)fScale, (Float)fZero, (Float)fZero, (Interpolation)interpolation, (RenderingHints)hints);
            JAIUtils.logImage((Logger)logger, (String)">>>>>>>>    planarImage", (RenderedImage)result);
        }
        return result;
    }

    public static PlanarImage jaiReduction(PlanarImage source, double scale, Quality quality, RenderingHints hints) {
        assert (scale <= 1.0);
        PlanarImage result = source;
        if (scale != 1.0) {
            Float fScale = new Float(scale);
            logger.finer(">>>> jaiReduction(" + scale + ")");
            Integer iPad = new Integer(10);
            BorderExtender borderExtender = BorderExtender.createInstance((int)1);
            logger.finer(">>>>>>>> Border(" + iPad + ")");
            result = BorderDescriptor.create((RenderedImage)result, (Integer)iPad, (Integer)iPad, (Integer)iPad, (Integer)iPad, (BorderExtender)borderExtender, (RenderingHints)hints);
            switch (quality) {
                case FASTEST: {
                    Interpolation interpolation = Interpolation.getInstance((int)0);
                    logger.finer(">>>>>>>> Scale(" + scale + ", " + interpolation + ")");
                    result = ScaleDescriptor.create((RenderedImage)result, (Float)fScale, (Float)fScale, (Float)ZERO, (Float)ZERO, (Interpolation)interpolation, (RenderingHints)hints);
                    break;
                }
                case BEST: {
                    if (scale > 0.5) {
                        Interpolation interpolation = Interpolation.getInstance((int)1);
                        logger.finer(">>>>>>>> Scale(" + scale + ", " + interpolation + ")");
                        result = ScaleDescriptor.create((RenderedImage)result, (Float)fScale, (Float)fScale, (Float)ZERO, (Float)ZERO, (Interpolation)interpolation, (RenderingHints)hints);
                        break;
                    }
                    Kernel averagingKernel = JAIUtils.getAveragingKernel((int)((int)Math.round(1.0 / scale)));
                    logger.finer(">>>>>>>> Convolve() with averaging kernel: " + averagingKernel);
                    result = ConvolveDescriptor.create((RenderedImage)result, (KernelJAI)new KernelJAI(averagingKernel), (RenderingHints)hints);
                    Interpolation interpolation = Interpolation.getInstance((int)0);
                    logger.finer(">>>>>>>> Scale(" + scale + ", " + interpolation + ")");
                    result = ScaleDescriptor.create((RenderedImage)result, (Float)fScale, (Float)fScale, (Float)ZERO, (Float)ZERO, (Interpolation)interpolation, (RenderingHints)hints);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(quality.toString());
                }
            }
            JAIUtils.logImage((Logger)logger, (String)">>>>>>>> jaiReduction returning planarImage", (RenderedImage)result);
        }
        return result;
    }

    public static void jaiCopyToBufferedImage(PlanarImage source, BufferedImage destination) {
        logger.finer(">>>> jaiCopyToBufferedImage()");
        long now = System.currentTimeMillis();
        int strategy = 1;
        if (strategy == 1) {
            BufferedImage bufferedImage2 = source.getAsBufferedImage();
            destination.getRaster().setRect(bufferedImage2.getRaster());
        } else if (strategy == 2) {
            destination.getRaster().setRect(JAIUtils.getRaster(source));
        }
        logger.finer(">>>> bufferedImage:     " + destination.getColorModel());
        logger.finer(">>>> jaiCopyToBufferedImage() done in " + (System.currentTimeMillis() - now) + " msec");
    }

    public static PlanarImage jaiConvertTosRGBColorProfile(PlanarImage source, ColorModel colorModel, RenderingHints hints) {
        boolean is_sRGB = source.getColorModel().getColorSpace().isCS_sRGB();
        logger.finer(">>>> planarImage.is_sRGB: " + is_sRGB);
        if (!is_sRGB) {
            logger.finer(">>>> Applying ColorConvertDescriptor");
            RenderedOp result = ColorConvertDescriptor.create((RenderedImage)source, (ColorModel)colorModel, (RenderingHints)hints);
            JAIUtils.logImage((Logger)logger, (String)">>>>>>>>    planarImage", (RenderedImage)result);
            return result;
        }
        return source;
    }

    public static PlanarImage jaiConvertTo8Bits(PlanarImage source, RenderingHints hints) {
        int TARGET_BIT_COUNT = 8;
        int bitsPerPixel = source.getSampleModel().getSampleSize(0);
        logger.finer(">>>> planarImage.bitsPerPixel: " + bitsPerPixel);
        if (bitsPerPixel > 8) {
            byte[] tableData = new byte[1 << bitsPerPixel];
            for (int i = 0; i < tableData.length; ++i) {
                tableData[i] = (byte)(i >> bitsPerPixel - 8);
            }
            logger.finer(">>>> Applying LookupDescriptor");
            LookupTableJAI lut = new LookupTableJAI(tableData);
            RenderedOp result = LookupDescriptor.create((RenderedImage)source, (LookupTableJAI)lut, (RenderingHints)hints);
            JAIUtils.logImage((Logger)logger, (String)">>>>>>>>    planarImage", (RenderedImage)result);
            return result;
        }
        return source;
    }

    public static WritableRaster getRaster(PlanarImage source) {
        assert (source.getNumXTiles() == 1) : "getNumXTiles is " + source.getNumXTiles();
        assert (source.getNumYTiles() == 1) : "getNumYTiles is " + source.getNumYTiles();
        TiledImage tiledImage = new TiledImage((RenderedImage)source, true);
        return tiledImage.getWritableTile(0, 0);
    }

    public static ColorModel getColorModel(PlanarImage planarImage, ICC_Profile colorProfile) {
        ICC_ColorSpace colorSpace = new ICC_ColorSpace(colorProfile);
        return new ComponentColorModel(colorSpace, false, false, 1, planarImage.getSampleModel().getDataType());
    }

    public static PlanarImage getPlanarImage(EditableImage editableImage) {
        return (PlanarImage)editableImage.getImageModel().getImage();
    }

    public static int closestPower2Size(int size) {
        boolean foundFlag = false;
        int index = -1;
        int result = -1;
        for (int i = 0; i < POWER2_SIZES.length && !foundFlag; ++i) {
            if (POWER2_SIZES[i] < size) continue;
            foundFlag = true;
            index = i;
        }
        if (foundFlag) {
            result = POWER2_SIZES[index];
        }
        return result;
    }
}

