/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.Quality;
import it.tidalwave.image.jai.JAIUtils;
import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.OptimizeOp;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizeJAIOp
extends OperationImplementation<OptimizeOp, PlanarImage> {
    private static final String CLASS = OptimizeJAIOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected PlanarImage execute(OptimizeOp operation, PlanarImage planarImage) {
        Java2DUtils.logImage((Logger)logger, (String)">>>> source planarImage", (RenderedImage)planarImage);
        double scale = operation.getScale();
        Quality quality = operation.getQuality();
        Object result = null;
        ICC_ColorSpace sRGBColorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1000));
        GraphicsConfiguration gc = Java2DUtils.getGraphicsConfiguration();
        int width = (int)Math.round(scale * (double)planarImage.getWidth());
        int height = (int)Math.round(scale * (double)planarImage.getHeight());
        BufferedImage targetBufferedImage = gc.createCompatibleImage(width, height);
        Java2DUtils.logImage((Logger)logger, (String)">>>>  targetBufferedImage", (RenderedImage)targetBufferedImage);
        ColorModel colorModel = targetBufferedImage.getColorModel();
        SampleModel sampleModel = targetBufferedImage.getSampleModel();
        ImageLayout imageLayout = new ImageLayout(0, 0, width, height, sampleModel, colorModel);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        PlanarImage pImage = JAIUtils.jaiConvertTo8Bits(planarImage, hints);
        if (scale > 1.0) {
            pImage = JAIUtils.jaiMagnification(pImage, scale, quality, hints);
        } else if (scale < 1.0) {
            pImage = JAIUtils.jaiReduction(pImage, scale, quality, hints);
        }
        pImage = JAIUtils.jaiConvertTosRGBColorProfile(pImage, colorModel, hints);
        planarImage = planarImage.createSnapshot();
        JAIUtils.logImage((Logger)logger, (String)">>>> optimiezeJAIOp() returning", (RenderedImage)planarImage);
        return planarImage;
    }
}

