/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.faceted.search.jsf;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.faceted.search.jsf.localconfiguration.FacetedSearchConfiguration;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="facetedSearchConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class FacetedSearchConfigurationActions
implements Serializable {
    protected Set<String> registeredContentView;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient ContentViewService contentViewService;

    public Set<ContentViewHeader> getSelectedContentViewHeaders() throws Exception {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (!currentDoc.hasFacet("FacetedSearchLocalConfiguration")) {
            return Collections.emptySet();
        }
        List<String> notAllowedContentView = this.getDeniedContentViewNames(currentDoc);
        HashSet<ContentViewHeader> allowedContentView = new HashSet<ContentViewHeader>();
        for (String cvName : this.getRegisteredContentViews()) {
            if (notAllowedContentView.contains(cvName)) continue;
            allowedContentView.add(this.contentViewService.getContentViewHeader(cvName));
        }
        return allowedContentView;
    }

    public Set<ContentViewHeader> getNotSelectedContentViewHeaders() throws Exception {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (!currentDoc.hasFacet("FacetedSearchLocalConfiguration")) {
            return Collections.emptySet();
        }
        return this.getContentViewHeaders(this.getDeniedContentViewNames(currentDoc));
    }

    protected List<String> getDeniedContentViewNames(DocumentModel doc) {
        FacetedSearchConfiguration adapter = (FacetedSearchConfiguration)doc.getAdapter(FacetedSearchConfiguration.class);
        if (adapter == null) {
            return Collections.emptyList();
        }
        return adapter.getDeniedContentViewNames();
    }

    protected Set<ContentViewHeader> getContentViewHeaders(Collection<String> contentViewsNames) throws Exception {
        HashSet<ContentViewHeader> contentViews = new HashSet<ContentViewHeader>();
        for (String name : contentViewsNames) {
            contentViews.add(this.contentViewService.getContentViewHeader(name));
        }
        return contentViews;
    }

    protected Set<String> getRegisteredContentViews() throws Exception {
        if (this.registeredContentView == null) {
            this.registeredContentView = ((ContentViewService)Framework.getService(ContentViewService.class)).getContentViewNames("FACETED_SEARCH");
        }
        return this.registeredContentView;
    }
}

