/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.faceted.search.jsf.localconfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.faceted.search.jsf.localconfiguration.FacetedSearchConfiguration;

public class FacetedSearchConfigurationAdapter
implements FacetedSearchConfiguration {
    protected List<String> allowedContentViews;
    protected List<String> deniedContentViews;
    protected DocumentRef docRef;

    public FacetedSearchConfigurationAdapter(DocumentModel doc) {
        this.docRef = doc.getRef();
        this.allowedContentViews = this.getList(doc, "fsc:allowedContentViews");
        this.deniedContentViews = this.getList(doc, "fsc:deniedContentViews");
    }

    protected List<String> getList(DocumentModel doc, String property) {
        String[] content;
        try {
            content = (String[])doc.getPropertyValue(property);
        }
        catch (ClientException e) {
            return Collections.emptyList();
        }
        if (content != null) {
            return Collections.unmodifiableList(Arrays.asList(content));
        }
        return Collections.emptyList();
    }

    public DocumentRef getDocumentRef() {
        return this.docRef;
    }

    public boolean canMerge() {
        return true;
    }

    public FacetedSearchConfiguration merge(FacetedSearchConfiguration other) {
        if (other == null) {
            return this;
        }
        this.docRef = other.getDocumentRef();
        ArrayList<String> deniedCV = new ArrayList<String>(this.deniedContentViews);
        deniedCV.addAll(other.getDeniedContentViewNames());
        this.deniedContentViews = Collections.unmodifiableList(deniedCV);
        return this;
    }

    @Override
    public List<String> getAllowedContentViewNames() {
        return this.allowedContentViews;
    }

    @Override
    public List<String> getDeniedContentViewNames() {
        return this.deniedContentViews;
    }

    protected boolean isAllowedName(String name) {
        return !this.getDeniedContentViewNames().contains(name) && (this.getAllowedContentViewNames().contains(name) || this.getAllowedContentViewNames().isEmpty());
    }

    @Override
    public Set<String> filterAllowedContentViewNames(Set<String> names) {
        HashSet<String> filtered = new HashSet<String>();
        for (String name : names) {
            if (!this.isAllowedName(name)) continue;
            filtered.add(name);
        }
        return filtered;
    }
}

