/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.HierarchyContext;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;

public class PersistenceContext {
    private static final Log log = LogFactory.getLog(PersistenceContext.class);
    protected final Model model;
    protected final RowMapper mapper;
    private final SessionImpl session;
    public final HierarchyContext hierContext;
    protected final Map<RowId, Fragment> pristine;
    protected final Map<RowId, Fragment> modified;
    private final Set<Serializable> createdIds;

    public PersistenceContext(Model model, RowMapper mapper, SessionImpl session) throws StorageException {
        this.model = model;
        this.mapper = mapper;
        this.session = session;
        this.hierContext = new HierarchyContext(model, mapper, session, this);
        this.pristine = new ReferenceMap(0, 2);
        this.modified = new HashMap<RowId, Fragment>();
        this.createdIds = new LinkedHashSet<Serializable>();
    }

    protected int clearCaches() {
        this.mapper.clearCache();
        this.hierContext.clearCaches();
        int n = this.pristine.size();
        this.pristine.clear();
        this.modified.clear();
        this.createdIds.clear();
        return n;
    }

    protected Serializable generateNewId(Serializable id) {
        if (id == null) {
            id = this.model.generateNewId();
        }
        this.createdIds.add(id);
        return id;
    }

    protected boolean isIdNew(Serializable id) {
        return this.createdIds.contains(id);
    }

    protected RowMapper.RowBatch getSaveBatch() throws StorageException {
        Fragment fragment;
        RowId rowId;
        RowMapper.RowBatch batch = new RowMapper.RowBatch();
        for (Serializable serializable : this.createdIds) {
            rowId = new RowId("hierarchy", serializable);
            fragment = this.modified.remove(rowId);
            if (fragment == null) continue;
            batch.creates.add(fragment.row);
            fragment.clearDirty();
            fragment.setPristine();
            this.pristine.put(rowId, fragment);
        }
        this.createdIds.clear();
        block7: for (Map.Entry entry : this.modified.entrySet()) {
            rowId = (RowId)entry.getKey();
            fragment = (Fragment)entry.getValue();
            switch (fragment.getState()) {
                case CREATED: {
                    batch.creates.add(fragment.row);
                    fragment.clearDirty();
                    fragment.setPristine();
                    this.pristine.put(rowId, fragment);
                    continue block7;
                }
                case MODIFIED: {
                    if (fragment.row.isCollection()) {
                        if (((CollectionFragment)fragment).isDirty()) {
                            batch.updates.add(new RowMapper.RowUpdate(fragment.row, null));
                            fragment.clearDirty();
                        }
                    } else {
                        List<String> keys = ((SimpleFragment)fragment).getDirtyKeys();
                        if (!keys.isEmpty()) {
                            batch.updates.add(new RowMapper.RowUpdate(fragment.row, keys));
                            fragment.clearDirty();
                        }
                    }
                    fragment.setPristine();
                    this.pristine.put(rowId, fragment);
                    continue block7;
                }
                case DELETED: {
                    batch.deletes.add(new RowId(rowId));
                    fragment.setDetached();
                    continue block7;
                }
                case PRISTINE: {
                    log.error((Object)("Found PRISTINE fragment in modified map: " + fragment));
                    continue block7;
                }
            }
            throw new RuntimeException(fragment.toString());
        }
        this.modified.clear();
        this.hierContext.postSave();
        return batch;
    }

    protected Serializable getContainingDocument(Serializable id) throws StorageException {
        return this.hierContext.getContainingDocument(id);
    }

    protected void findDirtyDocuments(Set<Serializable> dirtyStrings, Set<Serializable> dirtyBinaries) throws StorageException {
        block5: for (Fragment fragment : this.modified.values()) {
            Serializable docId = null;
            switch (fragment.getState()) {
                case CREATED: {
                    docId = this.getContainingDocument(fragment.getId());
                    dirtyStrings.add(docId);
                    dirtyBinaries.add(docId);
                    break;
                }
                case MODIFIED: {
                    String tableName = fragment.row.tableName;
                    Collection<Object> keys = this.model.isCollectionFragment(tableName) ? Collections.singleton(null) : ((SimpleFragment)fragment).getDirtyKeys();
                    for (String string : keys) {
                        PropertyType type = this.model.getFulltextFieldType(tableName, string);
                        if (type == null) continue;
                        if (docId == null) {
                            docId = this.getContainingDocument(fragment.getId());
                        }
                        if (type == PropertyType.STRING) {
                            dirtyStrings.add(docId);
                            continue;
                        }
                        if (type != PropertyType.BINARY) continue;
                        dirtyBinaries.add(docId);
                    }
                    continue block5;
                }
                case DELETED: {
                    docId = this.getContainingDocument(fragment.getId());
                    if (this.isDeleted(docId)) break;
                    dirtyStrings.add(docId);
                    dirtyBinaries.add(docId);
                    break;
                }
            }
        }
    }

    protected void markInvalidated(Invalidations invalidations) {
        Fragment fragment;
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                fragment = this.getIfPresent(rowId);
                if (fragment == null) continue;
                this.setFragmentPristine(fragment);
                fragment.setInvalidatedModified();
            }
            this.hierContext.markInvalidated(invalidations.modified);
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                fragment = this.getIfPresent(rowId);
                if (fragment == null) continue;
                this.setFragmentPristine(fragment);
                fragment.setInvalidatedDeleted();
            }
        }
    }

    protected void setFragmentModified(Fragment fragment) {
        Row rowId = fragment.row;
        this.pristine.remove(rowId);
        this.modified.put(rowId, fragment);
    }

    protected void setFragmentPristine(Fragment fragment) {
        Row rowId = fragment.row;
        this.modified.remove(rowId);
        this.pristine.put(rowId, fragment);
    }

    protected void sendInvalidationsToOthers() throws StorageException {
        Invalidations invalidations = new Invalidations();
        this.hierContext.gatherInvalidations(invalidations);
        this.mapper.sendInvalidations(invalidations);
    }

    protected void processReceivedInvalidations() throws StorageException {
        Invalidations.InvalidationsPair invals = this.mapper.receiveInvalidations();
        if (invals == null) {
            return;
        }
        this.processCacheInvalidations(invals.cacheInvalidations);
        this.session.sendInvalidationEvent(invals);
    }

    protected void processCacheInvalidations(Invalidations invalidations) throws StorageException {
        Fragment fragment;
        if (invalidations == null) {
            return;
        }
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                fragment = this.pristine.remove(rowId);
                if (fragment == null) continue;
                fragment.setInvalidatedModified();
            }
            this.hierContext.processReceivedInvalidations(invalidations.modified);
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                fragment = this.pristine.remove(rowId);
                if (fragment == null) continue;
                fragment.setInvalidatedDeleted();
            }
        }
    }

    protected void checkInvalidationsConflict() {
    }

    protected Fragment getIfPresent(RowId rowId) {
        Fragment fragment = this.pristine.get(rowId);
        if (fragment != null) {
            return fragment;
        }
        return this.modified.get(rowId);
    }

    protected Fragment get(RowId rowId, boolean allowAbsent) throws StorageException {
        Fragment fragment = this.getIfPresent(rowId);
        if (fragment == null) {
            fragment = this.getFromMapper(rowId, allowAbsent);
        }
        return fragment;
    }

    protected Fragment getFromMapper(RowId rowId, boolean allowAbsent) throws StorageException {
        List<Fragment> fragments = this.getFromMapper(Collections.singleton(rowId), allowAbsent);
        return fragments.isEmpty() ? null : fragments.get(0);
    }

    protected List<Fragment> getFromMapper(Collection<RowId> rowIds, boolean allowAbsent) throws StorageException {
        ArrayList<Fragment> res = new ArrayList<Fragment>(rowIds.size());
        ArrayList<RowId> todo = new ArrayList<RowId>(rowIds.size());
        for (RowId rowId : rowIds) {
            if (this.isIdNew(rowId.id)) {
                Fragment fragment = this.getFragmentFromFetchedRow(rowId, allowAbsent);
                if (fragment == null) continue;
                res.add(fragment);
                continue;
            }
            todo.add(rowId);
        }
        if (todo.isEmpty()) {
            return res;
        }
        List<? extends RowId> rows = this.mapper.read(todo);
        res.addAll(this.getFragmentsFromFetchedRows(rows, allowAbsent));
        return res;
    }

    protected List<Fragment> getMulti(Collection<RowId> rowIds, boolean allowAbsent) throws StorageException {
        if (rowIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> res = new ArrayList<Fragment>(rowIds.size());
        LinkedList<RowId> todo = new LinkedList<RowId>();
        for (RowId rowId : rowIds) {
            Fragment fragment = this.getIfPresent(rowId);
            if (fragment == null) {
                todo.add(rowId);
                continue;
            }
            if (fragment.getState() == Fragment.State.DELETED) continue;
            res.add(fragment);
        }
        if (todo.isEmpty()) {
            return res;
        }
        List<Fragment> fetched = this.getFromMapper(todo, allowAbsent);
        res.addAll(fetched);
        return res;
    }

    protected List<Fragment> getFragmentsFromFetchedRows(List<? extends RowId> rowIds, boolean allowAbsent) throws StorageException {
        ArrayList<Fragment> fragments = new ArrayList<Fragment>(rowIds.size());
        for (RowId rowId : rowIds) {
            Fragment fragment = this.getFragmentFromFetchedRow(rowId, allowAbsent);
            if (fragment == null) continue;
            fragments.add(fragment);
        }
        return fragments;
    }

    protected Fragment getFragmentFromFetchedRow(RowId rowId, boolean allowAbsent) throws StorageException {
        if (rowId == null) {
            return null;
        }
        Fragment fragment = this.getIfPresent(rowId);
        if (fragment != null) {
            Fragment.State state = fragment.getState();
            if (state == Fragment.State.DELETED) {
                return null;
            }
            if (state == Fragment.State.INVALIDATED_MODIFIED || state == Fragment.State.INVALIDATED_DELETED) {
                throw new IllegalStateException(state.toString());
            }
            return fragment;
        }
        boolean isCollection = this.model.isCollectionFragment(rowId.tableName);
        if (rowId instanceof Row) {
            Row row = (Row)rowId;
            fragment = isCollection ? new CollectionFragment(row, Fragment.State.PRISTINE, this) : new SimpleFragment(row, Fragment.State.PRISTINE, this);
            this.hierContext.recordFragment(fragment);
            return fragment;
        }
        if (allowAbsent) {
            if (isCollection) {
                Serializable[] empty = this.model.getCollectionFragmentType(rowId.tableName).getEmptyArray();
                Row row = new Row(rowId.tableName, rowId.id, empty);
                return new CollectionFragment(row, Fragment.State.ABSENT, this);
            }
            Row row = new Row(rowId.tableName, rowId.id);
            return new SimpleFragment(row, Fragment.State.ABSENT, this);
        }
        return null;
    }

    protected SimpleFragment createSimpleFragment(Row row) throws StorageException {
        if (this.pristine.containsKey(row) || this.modified.containsKey(row)) {
            throw new StorageException("Row already registered: " + row);
        }
        SimpleFragment fragment = new SimpleFragment(row, Fragment.State.CREATED, this);
        this.hierContext.createdSimpleFragment(fragment);
        return fragment;
    }

    protected void removeNode(Fragment hierFragment) throws StorageException {
        this.hierContext.removeNode(hierFragment);
        Serializable id = hierFragment.getId();
        this.session.removeLock(id, null, false);
        LinkedList<Fragment> fragments = new LinkedList<Fragment>();
        for (Fragment fragment : this.pristine.values()) {
            if (!id.equals(fragment.getId())) continue;
            fragments.add(fragment);
        }
        for (Fragment fragment : this.modified.values()) {
            if (!id.equals(fragment.getId()) || fragment.getState() == Fragment.State.DELETED) continue;
            fragments.add(fragment);
        }
        for (Fragment fragment : fragments) {
            this.removeFragment(fragment);
        }
    }

    protected void removeFragment(Fragment fragment) throws StorageException {
        this.hierContext.removeFragment(fragment);
        Row rowId = fragment.row;
        switch (fragment.getState()) {
            case ABSENT: 
            case INVALIDATED_DELETED: {
                this.pristine.remove(rowId);
                break;
            }
            case CREATED: {
                this.modified.remove(rowId);
                break;
            }
            case PRISTINE: 
            case INVALIDATED_MODIFIED: {
                this.pristine.remove(rowId);
                this.modified.put(rowId, fragment);
                break;
            }
            case MODIFIED: {
                break;
            }
        }
        fragment.setDeleted();
    }

    public void recomputeVersionSeries(Serializable versionSeriesId) throws StorageException {
        this.hierContext.recomputeVersionSeries(versionSeriesId);
    }

    protected List<Serializable> getVersionIds(Serializable versionSeriesId) throws StorageException {
        List<Row> rows = this.mapper.getVersionRows(versionSeriesId);
        List<Fragment> fragments = this.getFragmentsFromFetchedRows(rows, false);
        return this.fragmentsIds(fragments);
    }

    protected List<Fragment> getVersionFragments(Serializable versionSeriesId) throws StorageException {
        List<Row> rows = this.mapper.getVersionRows(versionSeriesId);
        return this.getFragmentsFromFetchedRows(rows, false);
    }

    protected List<Serializable> getProxyIds(Serializable searchId, boolean byTarget, Serializable parentId) throws StorageException {
        List<Row> rows = this.mapper.getProxyRows(searchId, byTarget, parentId);
        List<Fragment> fragments = this.getFragmentsFromFetchedRows(rows, false);
        return this.fragmentsIds(fragments);
    }

    private List<Serializable> fragmentsIds(List<Fragment> fragments) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>(fragments.size());
        for (Fragment fragment : fragments) {
            ids.add(fragment.getId());
        }
        return ids;
    }

    protected boolean isDeleted(Serializable id) throws StorageException {
        return this.hierContext.isDeleted(id);
    }

    protected Long getNextPos(Serializable nodeId, boolean complexProp) throws StorageException {
        return this.hierContext.getNextPos(nodeId, complexProp);
    }

    protected void orderBefore(Serializable parentId, Serializable sourceId, Serializable destId) throws StorageException {
        this.hierContext.orderBefore(parentId, sourceId, destId);
    }

    protected SimpleFragment getChildHierByName(Serializable parentId, String name, boolean complexProp) throws StorageException {
        return this.hierContext.getChildHierByName(parentId, name, complexProp);
    }

    protected List<SimpleFragment> getChildren(Serializable parentId, String name, boolean complexProp) throws StorageException {
        return this.hierContext.getChildren(parentId, name, complexProp);
    }

    protected void move(Node source, Serializable parentId, String name) throws StorageException {
        this.hierContext.move(source, parentId, name);
    }

    protected Serializable copy(Node source, Serializable parentId, String name) throws StorageException {
        return this.hierContext.copy(source, parentId, name);
    }

    protected Serializable checkIn(Node node, String label, String checkinComment) throws StorageException {
        return this.hierContext.checkIn(node, label, checkinComment);
    }

    protected void checkOut(Node node) throws StorageException {
        this.hierContext.checkOut(node);
    }

    protected void restoreVersion(Node node, Node version) throws StorageException {
        this.hierContext.restoreVersion(node, version);
    }
}

