/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelFulltext;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class DialectPostgreSQL
extends Dialect {
    private static final Log log = LogFactory.getLog(DialectPostgreSQL.class);
    private static final String DEFAULT_FULLTEXT_ANALYZER = "english";
    private static final String DEFAULT_USERS_SEPARATOR = ",";
    protected final String fulltextAnalyzer;
    protected final boolean supportsWith;
    protected boolean hierarchyCreated;
    protected boolean pathOptimizationsEnabled;
    protected String usersSeparator;

    public DialectPostgreSQL(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, binaryManager, repositoryDescriptor);
        int minor;
        int major;
        this.fulltextAnalyzer = repositoryDescriptor == null ? null : (repositoryDescriptor.fulltextAnalyzer == null ? DEFAULT_FULLTEXT_ANALYZER : repositoryDescriptor.fulltextAnalyzer);
        this.pathOptimizationsEnabled = repositoryDescriptor == null ? false : repositoryDescriptor.pathOptimizationsEnabled;
        try {
            major = metadata.getDatabaseMajorVersion();
            minor = metadata.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
        boolean bl = this.supportsWith = major > 8 || major == 8 && minor >= 4;
        this.usersSeparator = repositoryDescriptor == null ? null : (repositoryDescriptor.usersSeparatorKey == null ? DEFAULT_USERS_SEPARATOR : repositoryDescriptor.usersSeparatorKey);
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return bool ? "true" : "false";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "DEFAULT VALUES";
    }

    @Override
    public String getCascadeDropConstraintsString() {
        return "CASCADE";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectPostgreSQL.jdbcInfo("varchar", 12);
                }
                if (type.isClob()) {
                    return DialectPostgreSQL.jdbcInfo("text", 2005);
                }
                return DialectPostgreSQL.jdbcInfo("varchar(%d)", type.length, 12);
            }
            case BOOLEAN: {
                return DialectPostgreSQL.jdbcInfo("bool", -7);
            }
            case LONG: {
                return DialectPostgreSQL.jdbcInfo("int8", -5);
            }
            case DOUBLE: {
                return DialectPostgreSQL.jdbcInfo("float8", 8);
            }
            case TIMESTAMP: {
                return DialectPostgreSQL.jdbcInfo("timestamp", 93);
            }
            case BLOBID: {
                return DialectPostgreSQL.jdbcInfo("varchar(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                return DialectPostgreSQL.jdbcInfo("varchar(36)", 12);
            }
            case NODEARRAY: {
                return DialectPostgreSQL.jdbcInfo("varchar(36)[]", 2003);
            }
            case SYSNAME: {
                return DialectPostgreSQL.jdbcInfo("varchar(250)", 12);
            }
            case SYSNAMEARRAY: {
                return DialectPostgreSQL.jdbcInfo("varchar(250)[]", 2003);
            }
            case TINYINT: {
                return DialectPostgreSQL.jdbcInfo("int2", 5);
            }
            case INTEGER: {
                return DialectPostgreSQL.jdbcInfo("int4", 4);
            }
            case FTINDEXED: {
                return DialectPostgreSQL.jdbcInfo("tsvector", 1111);
            }
            case FTSTORED: {
                return DialectPostgreSQL.jdbcInfo("tsvector", 1111);
            }
            case CLUSTERNODE: {
                return DialectPostgreSQL.jdbcInfo("int4", 4);
            }
            case CLUSTERFRAGS: {
                return DialectPostgreSQL.jdbcInfo("varchar[]", 2003);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case 5: {
                ps.setInt(index, ((Long)value).intValue());
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
            case 2003: {
                Array array = this.createArrayOf(12, (Object[])value, ps.getConnection());
                ps.setArray(index, array);
                return;
            }
            case 1111: {
                if (column.getType() == ColumnType.FTSTORED) {
                    ps.setString(index, (String)((Object)value));
                    return;
                }
                throw new SQLException("Unhandled type: " + column.getType());
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                return this.getFromResultSetString(rs, index, column);
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -5: 
            case 4: 
            case 5: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
            case 2003: {
                Array array = rs.getArray(index);
                return array == null ? null : (Serializable)array.getArray();
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        return String.format("CREATE INDEX %s ON %s USING GIN(%s)", quotedIndexName.toLowerCase(), table.getQuotedName(), columns.get(0).getQuotedName());
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        Dialect.FulltextQuery ft = DialectPostgreSQL.analyzeFulltextQuery(query = query.replace(" & ", " "));
        if (ft == null) {
            return "";
        }
        if (DialectPostgreSQL.fulltextHasPhrase(ft)) {
            throw new QueryMaker.QueryMakerException("Invalid fulltext query (phrase search): " + query);
        }
        return DialectPostgreSQL.translateFulltext(ft, "|", "&", "& !", "");
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        String indexSuffix = model.getFulltextIndexSuffix(indexName);
        Table ft = database.getTable("fulltext");
        Column ftMain = ft.getColumn("id");
        Column ftColumn = ft.getColumn("fulltext" + indexSuffix);
        String nthSuffix = nthMatch == 1 ? "" : String.valueOf(nthMatch);
        String queryAlias = "_nxquery" + nthSuffix;
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        info.joins = new ArrayList<Join>();
        if (nthMatch == 1) {
            info.joins.add(new Join(1, ft.getQuotedName(), null, null, ftMain.getFullQuotedName(), mainColumn.getFullQuotedName()));
        }
        info.joins.add(new Join(4, String.format("TO_TSQUERY('%s', ?)", this.fulltextAnalyzer), queryAlias, fulltextQuery, null, null));
        info.whereExpr = String.format("(%s @@ %s)", queryAlias, ftColumn.getFullQuotedName());
        info.scoreExpr = String.format("TS_RANK_CD(%s, %s, 32)", ftColumn.getFullQuotedName(), queryAlias);
        info.scoreAlias = "_nxscore" + nthSuffix;
        info.scoreCol = new Column(mainColumn.getTable(), null, ColumnType.DOUBLE, null);
        return info;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 1;
    }

    @Override
    public String getFreeVariableSetterForType(ColumnType type) {
        if (type == ColumnType.FTSTORED) {
            return "NX_TO_TSVECTOR(?)";
        }
        return "?";
    }

    @Override
    public boolean supportsUpdateFrom() {
        return true;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return false;
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    @Override
    public boolean supportsReadAcl() {
        return this.aclOptimizationsEnabled;
    }

    @Override
    public String getReadAclsCheckSql(String idColumnName) {
        return String.format("%s IN (SELECT * FROM nx_get_read_acls_for(?))", idColumnName);
    }

    @Override
    public String getUpdateReadAclsSql() {
        return "SELECT nx_update_read_acls();";
    }

    @Override
    public String getRebuildReadAclsSql() {
        return "SELECT nx_rebuild_read_acls();";
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?)", idColumnName);
    }

    @Override
    public boolean supportsAncestorsTable() {
        return true;
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        if (this.pathOptimizationsEnabled) {
            return String.format("EXISTS(SELECT 1 FROM ancestors WHERE id = %s AND ARRAY[?] <@ ancestors)", idColumnName);
        }
        return String.format("NX_IN_TREE(%s, ?)", idColumnName);
    }

    @Override
    public String getMatchMixinType(Column mixinsColumn, String mixin, boolean positive, String[] returnParam) {
        returnParam[0] = mixin;
        String sql = "ARRAY[?] <@ " + mixinsColumn.getFullQuotedName();
        return positive ? sql : "NOT(" + sql + ")";
    }

    @Override
    public boolean supportsSysNameArray() {
        return true;
    }

    @Override
    public boolean supportsArrays() {
        return true;
    }

    @Override
    public Array createArrayOf(int type, Object[] elements, Connection connection) throws SQLException {
        String typeName;
        if (elements == null || elements.length == 0) {
            return null;
        }
        switch (type) {
            case 12: {
                typeName = "varchar";
                break;
            }
            default: {
                throw new RuntimeException("" + type);
            }
        }
        return new PostgreSQLArray(type, typeName, elements);
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/postgresql.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/postgresql.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("idType", (Serializable)((Object)"varchar(36)"));
        properties.put("aclOptimizationsEnabled", Boolean.valueOf(this.aclOptimizationsEnabled));
        properties.put("pathOptimizationsEnabled", Boolean.valueOf(this.pathOptimizationsEnabled));
        properties.put("fulltextAnalyzer", (Serializable)((Object)this.fulltextAnalyzer));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        if (!this.fulltextDisabled) {
            Table ft = database.getTable("fulltext");
            properties.put("fulltextTable", (Serializable)((Object)ft.getQuotedName()));
            ModelFulltext fti = model.getFulltextInfo();
            ArrayList<String> lines = new ArrayList<String>(fti.indexNames.size());
            for (String indexName : fti.indexNames) {
                String suffix = model.getFulltextIndexSuffix(indexName);
                Column ftft = ft.getColumn("fulltext" + suffix);
                Column ftst = ft.getColumn("simpletext" + suffix);
                Column ftbt = ft.getColumn("binarytext" + suffix);
                String line = String.format("  NEW.%s := COALESCE(NEW.%s, ''::TSVECTOR) || COALESCE(NEW.%s, ''::TSVECTOR);", ftft.getQuotedName(), ftst.getQuotedName(), ftbt.getQuotedName());
                lines.add(line);
            }
            properties.put("fulltextTriggerStatements", (Serializable)((Object)StringUtils.join(lines, (String)"\n")));
        }
        String[] permissions = NXCore.getSecurityService().getPermissionsToCheck("Browse");
        LinkedList<String> permsList = new LinkedList<String>();
        for (String perm : permissions) {
            permsList.add("('" + perm + "')");
        }
        properties.put("readPermissions", (Serializable)((Object)StringUtils.join(permsList, (String)", ")));
        properties.put("usersSeparator", (Serializable)((Object)this.getUsersSeparator()));
        properties.put("everyone", (Serializable)((Object)"Everyone"));
        properties.put("readAclMaxSize", (Serializable)((Object)Integer.toString(this.readAclMaxSize)));
        return properties;
    }

    @Override
    public boolean preCreateTable(Connection connection, Table table, Model model, Database database) throws SQLException {
        String tableKey = table.getKey();
        if ("hierarchy".equals(tableKey)) {
            this.hierarchyCreated = true;
            return true;
        }
        if ("ancestors".equals(tableKey)) {
            if (this.hierarchyCreated) {
                return true;
            }
            String sql = "SELECT COUNT(*) FROM hierarchy WHERE NOT isproperty";
            Statement s = connection.createStatement();
            ResultSet rs = s.executeQuery(sql);
            rs.next();
            long count = rs.getLong(1);
            rs.close();
            s.close();
            if (count > 100000L) {
                this.pathOptimizationsEnabled = false;
                log.error((Object)"Table ANCESTORS not initialized automatically because table HIERARCHY is too big. Upgrade by hand by calling: SELECT nx_init_ancestors()");
            }
            return true;
        }
        return true;
    }

    @Override
    public List<String> getPostCreateTableSqls(Table table, Model model, Database database) {
        if ("ancestors".equals(table.getKey())) {
            ArrayList<String> sqls = new ArrayList<String>();
            if (this.pathOptimizationsEnabled) {
                sqls.add("SELECT nx_init_ancestors()");
            } else {
                log.info((Object)"Path optimizations disabled");
            }
            return sqls;
        }
        return Collections.emptyList();
    }

    @Override
    public void existingTableDetected(Connection connection, Table table, Model model, Database database) throws SQLException {
        if ("ancestors".equals(table.getKey())) {
            if (!this.pathOptimizationsEnabled) {
                log.info((Object)"Path optimizations disabled");
                return;
            }
            String sql = "SELECT id FROM ancestors LIMIT 1";
            Statement s = connection.createStatement();
            ResultSet rs = s.executeQuery(sql);
            boolean empty = !rs.next();
            rs.close();
            s.close();
            if (empty) {
                this.pathOptimizationsEnabled = false;
                log.error((Object)"Table ANCESTORS empty, must be upgraded by hand by calling: SELECT nx_init_ancestors()");
                log.info((Object)"Path optimizations disabled");
            }
        }
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "SELECT NX_CLUSTER_INVAL(?, ?, ?)";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "DELETE FROM cluster_invals WHERE nodeid = pg_backend_pid() RETURNING id, fragments, kind";
    }

    @Override
    public boolean isConnectionClosedException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof SocketException) {
            return true;
        }
        String message = t.getMessage();
        if (message != null && message.contains("FATAL:")) {
            return true;
        }
        return t instanceof SQLException && "08003".equals(((SQLException)t).getSQLState());
    }

    @Override
    public boolean supportsPaging() {
        return true;
    }

    @Override
    public String getPagingClause(long limit, long offset) {
        return String.format("LIMIT %d OFFSET %d", limit, offset);
    }

    @Override
    public boolean supportsWith() {
        return false;
    }

    @Override
    public void performAdditionalStatements(Connection connection) throws SQLException {
        HashSet<String> dbPermissions = new HashSet<String>();
        String sql = "SELECT * FROM aclr_permission";
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery(sql);
        while (rs.next()) {
            dbPermissions.add(rs.getString(1));
        }
        rs.close();
        s.close();
        HashSet<String> confPermissions = new HashSet<String>();
        SecurityService securityService = NXCore.getSecurityService();
        for (String perm : securityService.getPermissionsToCheck("Browse")) {
            confPermissions.add(perm);
        }
        if (!((Object)dbPermissions).equals(confPermissions)) {
            log.error((Object)"Security permission for BROWSE has changed, you need to rebuild the optimized read acls:DROP TABLE aclr_permission; DROP TABLE aclr; then restart.");
        }
    }

    public String getUsersSeparator() {
        if (this.usersSeparator == null) {
            return DEFAULT_USERS_SEPARATOR;
        }
        return this.usersSeparator;
    }

    @Override
    public String getValidationQuery() {
        return "";
    }

    public static class PostgreSQLArray
    implements Array {
        private static final String NOT_SUPPORTED = "Not supported";
        protected final int type;
        protected final String typeName;
        protected final Object[] elements;
        protected final String string;

        public PostgreSQLArray(int type, String typeName, Object[] elements) {
            this.type = type;
            if (type == 12) {
                typeName = "varchar";
            }
            this.typeName = typeName;
            this.elements = elements;
            StringBuilder b = new StringBuilder();
            PostgreSQLArray.appendArray(b, elements);
            this.string = b.toString();
        }

        protected static void appendArray(StringBuilder b, Object[] elements) {
            b.append('{');
            for (int i = 0; i < elements.length; ++i) {
                Object e = elements[i];
                if (i > 0) {
                    b.append(',');
                }
                if (e == null) {
                    b.append("NULL");
                    continue;
                }
                if (e.getClass().isArray()) {
                    PostgreSQLArray.appendArray(b, (Object[])e);
                    continue;
                }
                String s = e.toString();
                b.append('\"');
                for (int j = 0; j < s.length(); ++j) {
                    char c = s.charAt(j);
                    if (c == '\"' || c == '\\') {
                        b.append('\\');
                    }
                    b.append(c);
                }
                b.append('\"');
            }
            b.append('}');
        }

        public String toString() {
            return this.string;
        }

        @Override
        public int getBaseType() {
            return this.type;
        }

        @Override
        public String getBaseTypeName() {
            return this.typeName;
        }

        @Override
        public Object getArray() {
            return this.elements;
        }

        @Override
        public Object getArray(Map<String, Class<?>> map) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public Object getArray(long index, int count) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public ResultSet getResultSet(long index, int count) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public void free() {
        }
    }
}

