/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import javax.naming.InitialContext;
import javax.naming.LimitExceededException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.utils.SIDGenerator;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.EntryAdaptor;
import org.nuxeo.ecm.directory.EntrySource;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPReference;
import org.nuxeo.ecm.directory.ldap.LDAPTreeReference;

public class LDAPSession
extends BaseSession
implements EntrySource {
    protected static final String MISSING_ID_LOWER_CASE = "lower";
    protected static final String MISSING_ID_UPPER_CASE = "upper";
    private static final Log log = LogFactory.getLog(LDAPSession.class);
    protected final String schemaName;
    protected final DirContext dirContext;
    protected final String idAttribute;
    protected final LDAPDirectory directory;
    protected final String searchBaseDn;
    protected final Set<String> emptySet = Collections.emptySet();
    protected final String sid;
    protected final Map<String, Field> schemaFieldMap;
    protected String substringMatchType;
    protected final String rdnAttribute;
    protected final String rdnField;

    public LDAPSession(LDAPDirectory directory, DirContext dirContext) {
        this.directory = directory;
        this.dirContext = dirContext;
        DirectoryFieldMapper fieldMapper = directory.getFieldMapper();
        this.idAttribute = fieldMapper.getBackendField(directory.getConfig().getIdField());
        this.schemaName = directory.getSchema();
        this.schemaFieldMap = directory.getSchemaFieldMap();
        this.sid = String.valueOf(SIDGenerator.next());
        this.searchBaseDn = directory.getConfig().getSearchBaseDn();
        this.substringMatchType = directory.getConfig().getSubstringMatchType();
        this.rdnAttribute = directory.getConfig().getRdnAttribute();
        this.rdnField = directory.getFieldMapper().getDirectoryField(this.rdnAttribute);
    }

    public void setSubStringMatchType(String type) {
        this.substringMatchType = type;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public DirContext getContext() {
        return this.dirContext;
    }

    public DocumentModel createEntry(Map<String, Object> fieldMap) throws DirectoryException {
        if (this.isReadOnly()) {
            return null;
        }
        LinkedList<String> referenceFieldList = new LinkedList<String>();
        try {
            BasicAttribute attr;
            String dn = String.format("%s=%s,%s", this.rdnAttribute, fieldMap.get(this.rdnField), this.directory.getConfig().getCreationBaseDn());
            BasicAttributes attrs = new BasicAttributes();
            List<String> mandatoryAttributes = this.getMandatoryAttributes();
            for (String mandatoryAttribute : mandatoryAttributes) {
                attr = new BasicAttribute(mandatoryAttribute);
                attr.add(" ");
                attrs.put(attr);
            }
            String[] creationClasses = this.directory.getConfig().getCreationClasses();
            if (creationClasses.length != 0) {
                attr = new BasicAttribute("objectclass");
                for (String creationClasse : creationClasses) {
                    attr.add(creationClasse);
                }
                attrs.put(attr);
            }
            for (String fieldId : fieldMap.keySet()) {
                String backendFieldId = this.directory.getFieldMapper().getBackendField(fieldId);
                if (backendFieldId.equals(this.getPasswordField())) {
                    attr = new BasicAttribute(backendFieldId);
                    attr.add(fieldMap.get(fieldId));
                    attrs.put(attr);
                    continue;
                }
                if (this.directory.isReference(fieldId)) {
                    Reference reference = this.directory.getReference(fieldId);
                    if (reference instanceof LDAPReference) {
                        attr = new BasicAttribute(((LDAPReference)reference).getStaticAttributeId());
                        attr.add(this.directory.getConfig().getEmptyRefMarker());
                        attrs.put(attr);
                    }
                    referenceFieldList.add(fieldId);
                    continue;
                }
                if ("dn".equals(backendFieldId)) {
                    log.warn((Object)String.format("field %s is mapped to read only DN field: ignored", fieldId));
                    continue;
                }
                Object value = fieldMap.get(fieldId);
                if (value == null || value.equals("") || ((Object)Collections.emptyList()).equals(value)) continue;
                attrs.put(this.getAttributeValue(fieldId, value));
            }
            if (log.isDebugEnabled()) {
                String idField = this.directory.getConfig().getIdField();
                log.debug((Object)String.format("LDAPSession.createEntry(%s=%s): LDAP bind dn='%s' attrs='%s' [%s]", new Object[]{idField, fieldMap.get(idField), dn, attrs, this}));
            }
            this.dirContext.bind(dn, null, (Attributes)attrs);
            for (String referenceFieldName : referenceFieldList) {
                Reference reference = this.directory.getReference(referenceFieldName);
                List targetIds = (List)fieldMap.get(referenceFieldName);
                reference.addLinks((String)fieldMap.get(this.getIdField()), targetIds);
            }
            String dnFieldName = this.directory.getFieldMapper().getDirectoryField("dn");
            if (this.directory.getSchemaFieldMap().containsKey(dnFieldName)) {
                fieldMap.put(dnFieldName, dn);
            }
            this.directory.invalidateCaches();
            return this.fieldMapToDocumentModel(fieldMap);
        }
        catch (Exception e) {
            throw new DirectoryException("createEntry failed", (Throwable)e);
        }
    }

    public DocumentModel getEntry(String id) throws DirectoryException {
        return this.directory.getCache().getEntry(id, (EntrySource)this);
    }

    public DocumentModel getEntry(String id, boolean fetchReferences) throws DirectoryException {
        return this.directory.getCache().getEntry(id, (EntrySource)this, fetchReferences);
    }

    public DocumentModel getEntryFromSource(String id, boolean fetchReferences) throws DirectoryException {
        try {
            SearchResult result = this.getLdapEntry(id);
            if (result == null) {
                return null;
            }
            return this.ldapResultToDocumentModel(result, id, fetchReferences);
        }
        catch (NamingException e) {
            throw new DirectoryException("getEntry failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasEntry(String id) throws DirectoryException {
        try {
            return this.getLdapEntry(id) != null;
        }
        catch (NamingException e) {
            throw new DirectoryException("hasEntry failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected SearchResult getLdapEntry(String id) throws NamingException, DirectoryException {
        return this.getLdapEntry(id, false);
    }

    protected SearchResult getLdapEntry(String id, boolean fetchAllAttributes) throws NamingException {
        NamingEnumeration<SearchResult> results;
        if (StringUtils.isEmpty((String)id)) {
            log.warn((Object)"the application should not queries for entries with empty id");
            return null;
        }
        String filterExpr = this.directory.getBaseFilter().startsWith("(") ? String.format("(&(%s={0})%s)", this.idAttribute, this.directory.getBaseFilter()) : String.format("(&(%s={0})(%s))", this.idAttribute, this.directory.getBaseFilter());
        Object[] filterArgs = new String[]{id};
        SearchControls scts = this.directory.getSearchControls(fetchAllAttributes);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("LDAPSession.getLdapEntry(%s, %s): LDAP search base='%s' filter='%s'  args='%s' scope='%s' [%s]", new Object[]{id, fetchAllAttributes, this.searchBaseDn, filterExpr, id, scts.getSearchScope(), this}));
        }
        try {
            results = this.dirContext.search(this.searchBaseDn, filterExpr, filterArgs, scts);
        }
        catch (NameNotFoundException nnfe) {
            log.error((Object)("Unexpected response from server while performing query: " + nnfe.getMessage()), (Throwable)nnfe);
            return null;
        }
        if (!results.hasMore()) {
            log.debug((Object)("Entry not found: " + id));
            return null;
        }
        SearchResult result = results.next();
        try {
            String dn = result.getNameInNamespace();
            if (results.hasMore()) {
                result = results.next();
                String dn2 = result.getNameInNamespace();
                String msg = String.format("Unable to fetch entry for '%s': found more than one match, for instance: '%s' and '%s'", id, dn, dn2);
                log.error((Object)msg);
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LDAPSession.getLdapEntry(%s, %s): LDAP search base='%s' filter='%s'  args='%s' scope='%s' => found: %s [%s]", new Object[]{id, fetchAllAttributes, this.searchBaseDn, filterExpr, id, scts.getSearchScope(), dn, this}));
            }
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        return result;
    }

    public DocumentModelList getEntries() throws DirectoryException {
        try {
            SearchControls scts = this.directory.getSearchControls();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LDAPSession.getEntries(): LDAP search base='%s' filter='%s'  args=* scope=%s [%s]", new Object[]{this.searchBaseDn, this.directory.getBaseFilter(), scts.getSearchScope(), this}));
            }
            NamingEnumeration<SearchResult> results = this.dirContext.search(this.searchBaseDn, this.directory.getBaseFilter(), scts);
            return this.ldapResultsToDocumentModels(results, false);
        }
        catch (javax.naming.SizeLimitExceededException e) {
            throw new SizeLimitExceededException((Throwable)e);
        }
        catch (NamingException e) {
            throw new DirectoryException("getEntries failed", (Throwable)e);
        }
    }

    public void updateEntry(DocumentModel docModel) throws DirectoryException {
        if (LDAPSession.isReadOnlyEntry((DocumentModel)docModel)) {
            return;
        }
        ArrayList<String> updateList = new ArrayList<String>();
        LinkedList<String> referenceFieldList = new LinkedList<String>();
        try {
            DataModel dataModel = docModel.getDataModel(this.schemaName);
            for (String fieldName : this.schemaFieldMap.keySet()) {
                if (!dataModel.isDirty(fieldName)) continue;
                if (this.directory.isReference(fieldName)) {
                    referenceFieldList.add(fieldName);
                    continue;
                }
                updateList.add(fieldName);
            }
            if (!LDAPSession.isReadOnlyEntry((DocumentModel)docModel) && !updateList.isEmpty()) {
                BasicAttributes attrs = new BasicAttributes();
                SearchResult ldapEntry = this.getLdapEntry(docModel.getId());
                if (ldapEntry == null) {
                    throw new DirectoryException(docModel.getId() + " not found");
                }
                Attributes oldattrs = ldapEntry.getAttributes();
                String dn = ldapEntry.getNameInNamespace();
                BasicAttributes attrsToDel = new BasicAttributes();
                for (String f : updateList) {
                    Object value = docModel.getProperty(this.schemaName, f);
                    String backendField = this.directory.getFieldMapper().getBackendField(f);
                    if ("dn".equals(backendField)) {
                        log.warn((Object)String.format("field %s is mapped to read only DN field: ignored", f));
                        continue;
                    }
                    if (value == null || value.equals("")) {
                        BasicAttribute attr;
                        if (this.getMandatoryAttributes().contains(backendField)) {
                            attr = new BasicAttribute(backendField);
                            attr.add(" ");
                            attrs.put(attr);
                            continue;
                        }
                        if (oldattrs.get(backendField) == null) continue;
                        attr = new BasicAttribute(backendField);
                        attr.add(oldattrs.get(backendField).get());
                        attrsToDel.put(attr);
                        continue;
                    }
                    attrs.put(this.getAttributeValue(f, value));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("LDAPSession.updateEntry(%s): LDAP modifyAttributes dn='%s' mod_op='REMOVE_ATTRIBUTE' attr='%s' [%s]", new Object[]{docModel, dn, attrsToDel, this}));
                }
                this.dirContext.modifyAttributes(dn, 3, (Attributes)attrsToDel);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("LDAPSession.updateEntry(%s): LDAP modifyAttributes dn='%s' mod_op='REPLACE_ATTRIBUTE' attr='%s' [%s]", new Object[]{docModel, dn, attrs, this}));
                }
                this.dirContext.modifyAttributes(dn, 2, (Attributes)attrs);
            }
            for (String referenceFieldName : referenceFieldList) {
                Reference reference = this.directory.getReference(referenceFieldName);
                List targetIds = (List)docModel.getProperty(this.schemaName, referenceFieldName);
                reference.setTargetIdsForSource(docModel.getId(), targetIds);
            }
        }
        catch (Exception e) {
            throw new DirectoryException("updateEntry failed: " + e.getMessage(), (Throwable)e);
        }
        this.directory.invalidateCaches();
    }

    public void deleteEntry(DocumentModel dm) throws DirectoryException {
        this.deleteEntry(dm.getId());
    }

    public void deleteEntry(String id) throws DirectoryException {
        if (this.isReadOnly()) {
            return;
        }
        try {
            for (String fieldName : this.schemaFieldMap.keySet()) {
                if (!this.directory.isReference(fieldName)) continue;
                Reference reference = this.directory.getReference(fieldName);
                reference.removeLinksForSource(id);
            }
            SearchResult result = this.getLdapEntry(id);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LDAPSession.deleteEntry(%s): LDAP destroySubcontext dn='%s' [%s]", new Object[]{id, result.getNameInNamespace(), this}));
            }
            this.dirContext.destroySubcontext(result.getNameInNamespace());
        }
        catch (Exception e) {
            throw new DirectoryException("deleteEntry failed for: " + id, (Throwable)e);
        }
        this.directory.invalidateCaches();
    }

    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        log.warn((Object)"Calling deleteEntry extended on LDAP directory");
        this.deleteEntry(id);
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, boolean fetchReferences, Map<String, String> orderBy) throws DirectoryException {
        try {
            Object[] filters = new String[filter.size()];
            Object[] filterArgs = new String[filter.size()];
            if (fulltext == null) {
                fulltext = Collections.emptySet();
            }
            int index = 0;
            for (String fieldName : filter.keySet()) {
                if (this.directory.isReference(fieldName)) {
                    log.warn((Object)(fieldName + " is a reference and will be ignored as a query criterion"));
                    continue;
                }
                String backendFieldName = this.directory.getFieldMapper().getBackendField(fieldName);
                Serializable fieldValue = filter.get(fieldName);
                StringBuilder currentFilter = new StringBuilder();
                currentFilter.append("(");
                if (fieldValue == null) {
                    currentFilter.append("!(" + backendFieldName + "=*)");
                } else if ("".equals(fieldValue)) {
                    if (fulltext.contains(fieldName)) {
                        currentFilter.append(backendFieldName + "=*");
                    } else {
                        currentFilter.append("!(" + backendFieldName + "=*)");
                    }
                } else {
                    currentFilter.append(backendFieldName + "=");
                    if (fulltext.contains(fieldName)) {
                        if ("subfinal".equals(this.substringMatchType)) {
                            currentFilter.append("*{" + index + "}");
                        } else if ("subany".equals(this.substringMatchType)) {
                            currentFilter.append("*{" + index + "}*");
                        } else {
                            currentFilter.append("{" + index + "}*");
                        }
                    } else {
                        currentFilter.append("{" + index + "}");
                    }
                }
                currentFilter.append(")");
                filters[index] = currentFilter.toString();
                if (fieldValue != null && !"".equals(fieldValue)) {
                    filterArgs[index] = fieldValue.toString();
                }
                ++index;
            }
            String filterExpr = "(&" + this.directory.getBaseFilter() + StringUtils.join((Object[])filters) + ')';
            SearchControls scts = this.directory.getSearchControls();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LDAPSession.query(...): LDAP search base='%s' filter='%s' args='%s' scope='%s' [%s]", new Object[]{this.searchBaseDn, filterExpr, StringUtils.join((Object[])filterArgs, (String)","), scts.getSearchScope(), this}));
            }
            try {
                NamingEnumeration<SearchResult> results = this.dirContext.search(this.searchBaseDn, filterExpr, filterArgs, scts);
                DocumentModelList entries = this.ldapResultsToDocumentModels(results, fetchReferences);
                if (orderBy != null && !orderBy.isEmpty()) {
                    this.directory.orderEntries((List)entries, orderBy);
                }
                return entries;
            }
            catch (NameNotFoundException nnfe) {
                log.error((Object)("Unexpected response from server while performing query: " + nnfe.getMessage()), (Throwable)nnfe);
                return new DocumentModelListImpl();
            }
        }
        catch (LimitExceededException e) {
            throw new SizeLimitExceededException((Throwable)e);
        }
        catch (NamingException e) {
            throw new DirectoryException("executeQuery failed", (Throwable)e);
        }
    }

    public DocumentModelList query(Map<String, Serializable> filter) throws DirectoryException {
        return this.query(filter, this.emptySet, new HashMap<String, String>());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) throws DirectoryException {
        return this.query(filter, fulltext, false, orderBy);
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) throws DirectoryException {
        return this.query(filter, fulltext, fetchReferences, orderBy);
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext) throws DirectoryException {
        return this.query(filter, fulltext, new HashMap<String, String>());
    }

    public void commit() {
    }

    public void rollback() {
    }

    public void close() throws DirectoryException {
        try {
            this.dirContext.close();
            this.directory.removeSession((Session)this);
        }
        catch (NamingException e) {
            throw new DirectoryException("close failed", (Throwable)e);
        }
    }

    public List<String> getProjection(Map<String, Serializable> filter, String columnName) throws DirectoryException {
        return this.getProjection(filter, this.emptySet, columnName);
    }

    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) throws DirectoryException {
        ArrayList<String> result = new ArrayList<String>();
        DocumentModelList docList = this.query(filter, fulltext);
        String columnNameinDocModel = this.directory.getFieldMapper().getDirectoryField(columnName);
        for (DocumentModel docModel : docList) {
            Object obj;
            try {
                obj = docModel.getProperty(this.schemaName, columnNameinDocModel);
            }
            catch (ClientException e) {
                throw new DirectoryException((Throwable)e);
            }
            String propValue = obj instanceof String ? (String)obj : String.valueOf(obj);
            result.add(propValue);
        }
        return result;
    }

    protected DocumentModel fieldMapToDocumentModel(Map<String, Object> fieldMap) throws DirectoryException {
        String id = String.valueOf(fieldMap.get(this.getIdField()));
        try {
            DocumentModel docModel = BaseSession.createEntryModel((String)this.sid, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
            EntryAdaptor adaptor = this.directory.getConfig().getEntryAdaptor();
            if (adaptor != null) {
                docModel = adaptor.adapt((Directory)this.directory, docModel);
            }
            return docModel;
        }
        catch (PropertyException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    protected Object getFieldValue(Attribute attribute, String fieldName, String entryId, boolean fetchReferences) throws DirectoryException {
        Object value;
        Field field = this.schemaFieldMap.get(fieldName);
        Type type = field.getType();
        Object defaultValue = field.getDefaultValue();
        String typeName = type.getName();
        if (attribute == null) {
            return defaultValue;
        }
        try {
            value = attribute.get();
        }
        catch (NamingException e) {
            throw new DirectoryException("Could not fetch value for " + attribute, (Throwable)e);
        }
        if (value == null) {
            return defaultValue;
        }
        String trimmedValue = value.toString().trim();
        if ("string".equals(typeName)) {
            return trimmedValue;
        }
        if ("integer".equals(typeName) || "long".equals(typeName)) {
            if ("".equals(trimmedValue)) {
                return defaultValue;
            }
            try {
                return Long.valueOf(trimmedValue);
            }
            catch (NumberFormatException e) {
                log.error((Object)String.format("field %s of type %s has non-numeric value found on server: '%s' (ignoring and using default value instead)", fieldName, typeName, trimmedValue));
                return defaultValue;
            }
        }
        if (type.isListType()) {
            LinkedList<String> parsedItems = new LinkedList<String>();
            NamingEnumeration<?> values = null;
            try {
                values = attribute.getAll();
                while (values.hasMore()) {
                    parsedItems.add(values.next().toString().trim());
                }
                return parsedItems;
            }
            catch (NamingException e) {
                log.error((Object)String.format("field %s of type %s has non list value found on server: '%s' (ignoring and using default value instead)", fieldName, typeName, values != null ? values.toString() : trimmedValue));
                return defaultValue;
            }
        }
        if ("date".equals(typeName)) {
            if ("".equals(trimmedValue)) {
                return defaultValue;
            }
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                dateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
                Date date = dateFormat.parse(trimmedValue);
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                return cal;
            }
            catch (ParseException e) {
                log.error((Object)String.format("field %s of type %s has invalid value found on server: '%s' (ignoring and using default value instead)", fieldName, typeName, trimmedValue));
                return defaultValue;
            }
        }
        throw new DirectoryException("Field type not supported in directories: " + typeName);
    }

    protected Attribute getAttributeValue(String fieldName, Object value) throws DirectoryException {
        BasicAttribute attribute = new BasicAttribute(this.directory.getFieldMapper().getBackendField(fieldName));
        Type type = this.schemaFieldMap.get(fieldName).getType();
        String typeName = type.getName();
        if ("string".equals(typeName)) {
            attribute.add(value);
        } else if ("integer".equals(typeName) || "long".equals(typeName)) {
            attribute.add(value.toString());
        } else if (type.isListType()) {
            Collection<String> valueItems;
            if (value instanceof String[]) {
                valueItems = Arrays.asList((String[])value);
            } else if (value instanceof Collection) {
                valueItems = (Collection)value;
            } else {
                throw new DirectoryException(String.format("field %s with value %s does not match type %s", fieldName, value.toString(), type.getName()));
            }
            for (String item : valueItems) {
                attribute.add(item);
            }
        } else if ("date".equals(typeName)) {
            Calendar cal = (Calendar)value;
            Date date = cal.getTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
            attribute.add(dateFormat.format(date));
        } else {
            throw new DirectoryException("Field type not supported in directories: " + typeName);
        }
        return attribute;
    }

    protected DocumentModelList ldapResultsToDocumentModels(NamingEnumeration<SearchResult> results, boolean fetchReferences) throws DirectoryException, NamingException {
        DocumentModelListImpl list = new DocumentModelListImpl();
        while (results.hasMore()) {
            SearchResult result = results.next();
            DocumentModel entry = this.ldapResultToDocumentModel(result, null, fetchReferences);
            if (entry == null) continue;
            list.add((Object)entry);
        }
        log.debug((Object)("LDAP search returned " + list.size() + " results"));
        return list;
    }

    protected DocumentModel ldapResultToDocumentModel(SearchResult result, String entryId, boolean fetchReferences) throws DirectoryException, NamingException {
        Object entry;
        Attributes attributes = result.getAttributes();
        String passwordFieldId = this.getPasswordField();
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        Attribute attribute = attributes.get(this.idAttribute);
        if (attribute != null && (entry = attribute.get()) != null) {
            entryId = entry.toString();
        }
        if (entryId == null) {
            return null;
        }
        for (String fieldName : this.schemaFieldMap.keySet()) {
            Reference reference = this.directory.getReference(fieldName);
            if (reference != null) {
                List<String> referencedIds;
                AbstractReference ldapReference;
                if (!fetchReferences) continue;
                if (reference instanceof LDAPReference) {
                    ldapReference = (LDAPReference)reference;
                    referencedIds = ldapReference.getLdapTargetIds(attributes);
                } else if (reference instanceof LDAPTreeReference) {
                    ldapReference = (LDAPTreeReference)reference;
                    referencedIds = ldapReference.getTargetIdsForSource(entryId);
                } else {
                    try {
                        referencedIds = reference.getTargetIdsForSource(entryId);
                    }
                    catch (ClientException e) {
                        throw new DirectoryException((Throwable)e);
                    }
                }
                fieldMap.put(fieldName, referencedIds);
                continue;
            }
            String attributeId = this.directory.getFieldMapper().getBackendField(fieldName);
            if (attributeId.equals("dn")) {
                try {
                    fieldMap.put(fieldName, result.getNameInNamespace());
                }
                catch (UnsupportedOperationException e) {}
                continue;
            }
            attribute = attributes.get(attributeId);
            if (fieldName.equals(passwordFieldId)) continue;
            fieldMap.put(fieldName, this.getFieldValue(attribute, fieldName, entryId, fetchReferences));
        }
        String fieldId = this.directory.getFieldMapper().getDirectoryField(this.idAttribute);
        Object obj = fieldMap.get(fieldId);
        if (obj == null) {
            fieldMap.put(fieldId, this.changeEntryIdCase(entryId, this.directory.getConfig().missingIdFieldCase));
        } else if (obj instanceof String) {
            fieldMap.put(fieldId, this.changeEntryIdCase((String)obj, this.directory.getConfig().idCase));
        }
        return this.fieldMapToDocumentModel(fieldMap);
    }

    protected String changeEntryIdCase(String id, String idFieldCase) {
        if (MISSING_ID_LOWER_CASE.equals(idFieldCase)) {
            return id.toLowerCase();
        }
        if (MISSING_ID_UPPER_CASE.equals(idFieldCase)) {
            return id.toUpperCase();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password) throws DirectoryException {
        SearchResult entry;
        if (password == null || "".equals(password.trim())) {
            return false;
        }
        try {
            entry = this.getLdapEntry(username);
        }
        catch (NamingException e) {
            throw new DirectoryException("failed to fetch the ldap entry for " + username, (Throwable)e);
        }
        if (entry == null) {
            return false;
        }
        String dn = entry.getNameInNamespace();
        Properties env = (Properties)this.directory.getContextProperties().clone();
        env.put("java.naming.security.principal", dn);
        env.put("java.naming.security.credentials", password);
        InitialContext authenticationDirContext = null;
        try {
            log.debug((Object)String.format("LDAP bind dn='%s'", dn));
            authenticationDirContext = new InitialDirContext(env);
            log.debug((Object)"Bind succeeded, authentication ok");
            boolean bl = true;
            return bl;
        }
        catch (NamingException e) {
            log.debug((Object)("Bind failed: " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (authenticationDirContext != null) {
                    authenticationDirContext.close();
                }
            }
            catch (NamingException e) {
                log.error((Object)("Error closing authentication context when biding dn " + dn), (Throwable)e);
                return false;
            }
        }
    }

    public String getIdField() {
        return this.directory.getConfig().getIdField();
    }

    public String getPasswordField() {
        return this.directory.getConfig().getPasswordField();
    }

    public boolean isAuthenticating() throws DirectoryException {
        String password = this.getPasswordField();
        return this.schemaFieldMap.containsKey(password);
    }

    public boolean isReadOnly() {
        return this.directory.getConfig().getReadOnly();
    }

    public boolean rdnMatchesIdField() {
        return this.directory.getConfig().rdnAttribute.equals(this.idAttribute);
    }

    protected List<String> getMandatoryAttributes() throws DirectoryException {
        try {
            ArrayList<String> mandatoryAttributes = new ArrayList<String>();
            DirContext schema = this.dirContext.getSchema("");
            ArrayList<String> creationClasses = new ArrayList<String>(Arrays.asList(this.directory.getConfig().getCreationClasses()));
            creationClasses.remove("top");
            for (String creationClass : creationClasses) {
                Attributes attributes = schema.getAttributes("ClassDefinition/" + creationClass);
                Attribute attribute = attributes.get("MUST");
                if (attribute == null) continue;
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMore()) {
                    String value = (String)values.next();
                    mandatoryAttributes.add(value);
                }
            }
            return mandatoryAttributes;
        }
        catch (NamingException e) {
            throw new DirectoryException("getMandatoryAttributes failed", (Throwable)e);
        }
    }

    public String toString() {
        return String.format("LDAPSession '%s' for directory %s", this.sid, this.directory.getName());
    }

    public DocumentModel createEntry(DocumentModel entry) throws ClientException {
        Map fieldMap = entry.getProperties(this.directory.getSchema());
        return this.createEntry(fieldMap);
    }
}

