/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.management;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.BinaryManagerStatus;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.RepositoryResolver;
import org.nuxeo.ecm.core.storage.sql.management.RepositoryStatusMBean;
import org.nuxeo.ecm.core.storage.sql.net.MapperClientInfo;

public class RepositoryStatus
implements RepositoryStatusMBean {
    private static final Log log = LogFactory.getLog(RepositoryStatus.class);

    protected List<RepositoryManagement> getRepositories() throws NamingException {
        LinkedList<RepositoryManagement> list = new LinkedList<RepositoryManagement>();
        InitialContext context = new InitialContext();
        for (String prefix : new String[]{"java:NXRepository", "NXRepository"}) {
            NamingEnumeration<Binding> bindings;
            try {
                bindings = context.listBindings(prefix);
            }
            catch (NamingException e) {
                continue;
            }
            NamingEnumeration<Binding> e = bindings;
            while (e.hasMore()) {
                Object object;
                Binding binding = (Binding)e.nextElement();
                String name = binding.getName();
                if (binding.isRelative()) {
                    name = prefix + '/' + name;
                }
                if (!((object = context.lookup(name)) instanceof RepositoryManagement)) continue;
                list.add((RepositoryManagement)object);
            }
        }
        if (list.size() == 0) {
            List repos = RepositoryResolver.getRepositories();
            for (Repository repo : repos) {
                list.add((RepositoryManagement)repo);
            }
        }
        return list;
    }

    @Override
    public String listActiveSessions() {
        List<RepositoryManagement> repositories;
        try {
            repositories = this.getRepositories();
        }
        catch (NamingException e) {
            log.error((Object)"Error getting repositories", (Throwable)e);
            return "Error!";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Actives sessions for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>: ");
            buf.append(repository.getActiveSessionsCount());
            buf.append("<br />");
        }
        return buf.toString();
    }

    @Override
    public int getActiveSessionsCount() {
        List<RepositoryManagement> repositories;
        try {
            repositories = this.getRepositories();
        }
        catch (NamingException e) {
            throw new IllegalStateException("Cannot get repositories", e);
        }
        int count = 0;
        for (RepositoryManagement repository : repositories) {
            count += repository.getActiveSessionsCount();
        }
        return count;
    }

    @Override
    public String clearCaches() {
        List<RepositoryManagement> repositories;
        try {
            repositories = this.getRepositories();
        }
        catch (NamingException e) {
            log.error((Object)"Error getting repositories", (Throwable)e);
            return "Error!";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Cleared cached objects for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>: ");
            buf.append(repository.clearCaches());
            buf.append("<br />");
        }
        return buf.toString();
    }

    @Override
    public String listRemoteSessions() {
        List<RepositoryManagement> repositories;
        try {
            repositories = this.getRepositories();
        }
        catch (NamingException e) {
            log.error((Object)"Error getting repositories", (Throwable)e);
            return "Error!";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Actives remote session for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>");
            if (repository.getServerURL() == null) {
                buf.append(" Server mode not activated");
            } else {
                buf.append(repository.getServerURL()).append("<br/>");
                if (repository.getClientInfos().size() == 0) {
                    buf.append("No client connected").append("<br/>");
                } else {
                    buf.append("<ul>");
                    for (MapperClientInfo info : repository.getClientInfos()) {
                        buf.append("  <li>").append(info.getRemoteUser()).append("  :");
                        buf.append(info.getRemoteIP()).append("  </li>");
                    }
                    buf.append("</ul>");
                }
            }
            buf.append("<br/>");
        }
        return buf.toString();
    }

    @Override
    public BinaryManagerStatus gcBinaries(boolean delete) {
        BinaryGarbageCollector gc;
        List<RepositoryManagement> repositories;
        BinaryManagerStatus status = new BinaryManagerStatus();
        try {
            repositories = this.getRepositories();
        }
        catch (NamingException e) {
            log.error((Object)"Error getting repositories", (Throwable)e);
            status.numBinaries = -1L;
            status.sizeBinaries = -1L;
            return status;
        }
        long start = System.currentTimeMillis();
        LinkedHashMap<String, BinaryGarbageCollector> repogcs = new LinkedHashMap<String, BinaryGarbageCollector>();
        LinkedHashMap<String, BinaryGarbageCollector> gcs = new LinkedHashMap<String, BinaryGarbageCollector>();
        for (RepositoryManagement repository : repositories) {
            String gcid;
            gc = repository.getBinaryGarbageCollector();
            if (gc == null) {
                // empty if block
            }
            if (gcs.containsKey(gcid = gc.getId())) {
                gc = (BinaryGarbageCollector)gcs.get(gcid);
            } else {
                gcs.put(gcid, gc);
                gc.start();
            }
            repogcs.put(repository.getName(), gc);
        }
        for (RepositoryManagement repository : repositories) {
            gc = (BinaryGarbageCollector)repogcs.get(repository.getName());
            repository.markReferencedBinaries(gc);
        }
        for (BinaryGarbageCollector gc2 : gcs.values()) {
            gc2.stop(delete);
            BinaryManagerStatus s = gc2.getStatus();
            status.numBinaries += s.numBinaries;
            status.sizeBinaries += s.sizeBinaries;
            status.numBinariesGC += s.numBinariesGC;
            status.sizeBinariesGC += s.sizeBinariesGC;
        }
        status.gcDuration = System.currentTimeMillis() - start;
        return status;
    }

    @Override
    public boolean isBinariesGCInProgress() {
        try {
            List<RepositoryManagement> repositories = this.getRepositories();
            for (RepositoryManagement repo : repositories) {
                BinaryGarbageCollector gc = repo.getBinaryGarbageCollector();
                if (!(gc != null & gc.isInProgress())) continue;
                return true;
            }
        }
        catch (NamingException e) {
            log.error((Object)"Error getting repositories", (Throwable)e);
        }
        return false;
    }
}

