/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.imagej;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.iptc.IptcDirectory;
import ij.ImagePlus;
import ij.io.Opener;
import it.tidalwave.image.EditableImage;
import it.tidalwave.image.Rational;
import it.tidalwave.image.metadata.EXIFDirectory;
import it.tidalwave.image.op.ReadOp;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.platform.picture.ExifHelper;
import org.nuxeo.ecm.platform.picture.IPTCHelper;
import org.nuxeo.ecm.platform.picture.core.MetadataUtils;
import org.nuxeo.runtime.services.streaming.InputStreamSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class ImageJMetadataUtils
implements MetadataUtils {
    private static final Log log = LogFactory.getLog(ImageJMetadataUtils.class);
    private static final int BUFFER_LIMIT = 32000000;

    @Override
    @Deprecated
    public Map<String, Object> getImageMetadata(InputStream in) {
        BufferedInputStream bin = null;
        if (in != null) {
            bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
            bin.mark(32000000);
        }
        StreamingBlob blob = new StreamingBlob((StreamSource)new InputStreamSource((InputStream)bin));
        return this.getImageMetadata((Blob)blob);
    }

    @Override
    @Deprecated
    public Map<String, Object> getImageMetadata(File file) {
        FileBlob blob = new FileBlob(file);
        return this.getImageMetadata((Blob)blob);
    }

    @Override
    public Map<String, Object> getImageMetadata(Blob blob) {
        HashMap<String, Object> metadata;
        block57: {
            metadata = new HashMap<String, Object>();
            ImagePlus im = null;
            if (blob instanceof FileBlob) {
                Opener op = new Opener();
                im = op.openImage(((FileBlob)blob).getFile().getPath());
            } else {
                try {
                    FileBlob fb = new FileBlob(blob.getStream());
                    String path = fb.getFile().getPath();
                    Opener op = new Opener();
                    im = op.openImage(path);
                }
                catch (IOException e) {
                    log.error((Object)"Failed to get file path", (Throwable)e);
                }
            }
            if (im == null) {
                return metadata;
            }
            metadata.put("width", im.getFileInfo().width);
            metadata.put("height", im.getFileInfo().height);
            try {
                String copyright;
                String equipment;
                String comment;
                String description;
                EditableImage image = EditableImage.create((ReadOp)new ReadOp((Object)blob.getStream(), ReadOp.Type.METADATA));
                EXIFDirectory exif = image.getEXIFDirectory();
                if (exif.isImageDescriptionAvailable() && (description = exif.getImageDescription().trim()).length() > 0) {
                    metadata.put("description", description);
                }
                if (exif.isUserCommentAvailable() && (comment = ExifHelper.decodeUndefined(exif.getUserComment()).trim()).length() > 0) {
                    metadata.put("comment", comment);
                }
                if ((exif.isMakeAvailable() || exif.isModelAvailable()) && (equipment = (exif.getMake() + " " + exif.getModel()).trim()).length() > 0) {
                    metadata.put("equipment", equipment);
                }
                if (exif.isDateTimeOriginalAvailable()) {
                    metadata.put("originalDate", exif.getDateTimeOriginalAsDate());
                }
                if (exif.isXResolutionAvailable() && exif.isYResolutionAvailable()) {
                    metadata.put("horizontalResolution", exif.getXResolution().intValue());
                    metadata.put("verticalResolution", exif.getYResolution().intValue());
                }
                if (exif.isPixelXDimensionAvailable() && exif.isPixelYDimensionAvailable()) {
                    metadata.put("pixelXDimension", exif.getPixelXDimension());
                    metadata.put("pixelYDimension", exif.getPixelYDimension());
                }
                if (exif.isCopyrightAvailable() && (copyright = exif.getCopyright().trim()).length() > 0) {
                    metadata.put("copyright", copyright);
                }
                if (exif.isExposureTimeAvailable()) {
                    Rational exposure = exif.getExposureTime();
                    int n = exposure.getNumerator();
                    int d = exposure.getDenominator();
                    if (d >= n && d % n == 0) {
                        exposure = new Rational(1, d / n);
                    }
                    metadata.put("exposure", exposure.toString());
                }
                if (exif.isISOSpeedRatingsAvailable()) {
                    metadata.put("ISOspeed", "ISO-" + exif.getISOSpeedRatings());
                }
                if (exif.isFocalLengthAvailable()) {
                    metadata.put("focalLength", exif.getFocalLength().doubleValue());
                }
                if (exif.isColorSpaceAvailable()) {
                    metadata.put("colorSpace", exif.getColorSpace().toString());
                }
                if (exif.isWhiteBalanceAvailable()) {
                    metadata.put("whiteBalance", exif.getWhiteBalance().toString().toLowerCase());
                }
                if (exif.isInterColourProfileAvailable()) {
                    metadata.put("iccProfile", exif.getICCProfile());
                }
                if (exif.isOrientationAvailable()) {
                    metadata.put("orientation", exif.getOrientation().toString());
                }
                if (exif.isFNumberAvailable()) {
                    metadata.put("fNumber", exif.getFNumber().doubleValue());
                }
            }
            catch (IOException e) {
                log.error((Object)"Failed to get EXIF metadata", (Throwable)e);
            }
            try {
                Metadata md = null;
                if ("image/jpeg".equals(blob.getMimeType())) {
                    md = JpegMetadataReader.readMetadata((InputStream)blob.getStream());
                }
                if (md == null) break block57;
                Directory iptc = md.getDirectory(IptcDirectory.class);
                if (iptc.containsTag(592)) {
                    metadata.put("byLine", IPTCHelper.cleanupData(iptc.getString(592)));
                }
                if (iptc.containsTag(597)) {
                    metadata.put("byLineTitle", IPTCHelper.cleanupData(iptc.getString(597)));
                }
                if (iptc.containsTag(632)) {
                    metadata.put("caption", IPTCHelper.cleanupData(iptc.getString(632)));
                }
                if (iptc.containsTag(527)) {
                    metadata.put("category", IPTCHelper.cleanupData(iptc.getString(527)));
                }
                if (iptc.containsTag(602)) {
                    metadata.put("city", IPTCHelper.cleanupData(iptc.getString(602)));
                }
                if (iptc.containsTag(628)) {
                    metadata.put("copyrightNotice", IPTCHelper.cleanupData(iptc.getString(628)));
                }
                if (iptc.containsTag(613)) {
                    metadata.put("countryOrPrimaryLocation", IPTCHelper.cleanupData(iptc.getString(613)));
                }
                if (iptc.containsTag(622)) {
                    metadata.put("credit", IPTCHelper.cleanupData(iptc.getString(622)));
                }
                if (iptc.containsTag(567)) {
                    try {
                        metadata.put("dateCreated", iptc.getDate(567));
                    }
                    catch (MetadataException e) {
                        log.error((Object)"Failed to get IPTC - date created", (Throwable)e);
                    }
                }
                if (iptc.containsTag(617)) {
                    metadata.put("headline", IPTCHelper.cleanupData(iptc.getString(617)));
                }
                if (iptc.containsTag(537)) {
                    metadata.put("keywords", IPTCHelper.cleanupData(iptc.getString(537)));
                }
                if (iptc.containsTag(135)) {
                    metadata.put("language", IPTCHelper.cleanupData(iptc.getString(135)));
                }
                if (iptc.containsTag(517)) {
                    metadata.put("objectName", IPTCHelper.cleanupData(iptc.getString(517)));
                }
                if (iptc.containsTag(615)) {
                    metadata.put("originalTransmissionReference", IPTCHelper.cleanupData(iptc.getString(615)));
                }
                if (iptc.containsTag(577)) {
                    metadata.put("originatingProgram", IPTCHelper.cleanupData(iptc.getString(577)));
                }
                if (iptc.containsTag(607)) {
                    metadata.put("provinceOrState", IPTCHelper.cleanupData(iptc.getString(607)));
                }
                if (iptc.containsTag(607)) {
                    metadata.put("provinceOrState", IPTCHelper.cleanupData(iptc.getString(607)));
                }
                if (iptc.containsTag(512)) {
                    metadata.put("recordVersion", IPTCHelper.cleanupData(iptc.getString(512)));
                }
                if (iptc.containsTag(542)) {
                    try {
                        metadata.put("releaseDate", iptc.getDate(542));
                    }
                    catch (MetadataException e) {
                        log.error((Object)"Failed to get IPTC - release date", (Throwable)e);
                    }
                }
                if (iptc.containsTag(547)) {
                    metadata.put("releaseTime", IPTCHelper.cleanupData(iptc.getString(547)));
                }
                if (iptc.containsTag(627)) {
                    metadata.put("source", IPTCHelper.cleanupData(iptc.getString(627)));
                }
                if (iptc.containsTag(552)) {
                    metadata.put("specialInstructions", IPTCHelper.cleanupData(iptc.getString(552)));
                }
                if (iptc.containsTag(532)) {
                    metadata.put("supplementalCategories", IPTCHelper.cleanupData(iptc.getString(532)));
                }
                if (iptc.containsTag(572)) {
                    metadata.put("timeCreated", IPTCHelper.cleanupData(iptc.getString(572)));
                }
                if (iptc.containsTag(522)) {
                    metadata.put("urgency", IPTCHelper.cleanupData(iptc.getString(522)));
                }
                if (iptc.containsTag(634)) {
                    metadata.put("writer", IPTCHelper.cleanupData(iptc.getString(634)));
                }
            }
            catch (IOException e) {
                log.error((Object)"Failed to get IPTC metadata", (Throwable)e);
            }
            catch (JpegProcessingException e) {
                log.error((Object)"Failed to get IPTC metadata", (Throwable)e);
            }
        }
        return metadata;
    }
}

