/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets.library;

import com.sun.facelets.tag.AbstractTagLibrary;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.BuiltinModes;
import org.nuxeo.ecm.platform.forms.layout.api.BuiltinWidgetModes;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRow;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.facelets.DocumentLayoutTagHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.LayoutRowTagHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.LayoutRowWidgetTagHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.LayoutTagHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.SubWidgetTagHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTagHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTypeTagHandler;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.runtime.api.Framework;

public class LayoutTagLibrary
extends AbstractTagLibrary {
    private static final Log log = LogFactory.getLog(LayoutTagLibrary.class);
    public static final String Namespace = "http://nuxeo.org/nxforms/layout";
    public static final LayoutTagLibrary Instance = new LayoutTagLibrary();

    public LayoutTagLibrary() {
        super(Namespace);
        this.addTagHandler("widgetType", WidgetTypeTagHandler.class);
        this.addTagHandler("widget", WidgetTagHandler.class);
        this.addTagHandler("layout", LayoutTagHandler.class);
        this.addTagHandler("layoutRow", LayoutRowTagHandler.class);
        this.addTagHandler("layoutColumn", LayoutRowTagHandler.class);
        this.addTagHandler("layoutRowWidget", LayoutRowWidgetTagHandler.class);
        this.addTagHandler("layoutColumnWidget", LayoutRowWidgetTagHandler.class);
        this.addTagHandler("subWidget", SubWidgetTagHandler.class);
        this.addTagHandler("documentLayout", DocumentLayoutTagHandler.class);
        try {
            this.addFunction("widgetTypeDefinition", LayoutTagLibrary.class.getMethod("getWidgetTypeDefinition", String.class));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            this.addFunction("fieldDefinitionsAsString", LayoutTagLibrary.class.getMethod("getFieldDefinitionsAsString", FieldDefinition[].class));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            Method getSelectedRows = LayoutTagLibrary.class.getMethod("getSelectedRows", Layout.class, List.class, Boolean.TYPE);
            this.addFunction("selectedRows", getSelectedRows);
            this.addFunction("selectedColumns", getSelectedRows);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            Method getNotSelectedRows = LayoutTagLibrary.class.getMethod("getNotSelectedRows", Layout.class, List.class);
            this.addFunction("notSelectedRows", getNotSelectedRows);
            this.addFunction("notSelectedColumns", getNotSelectedRows);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            Method getDefaultSelectedRowNames = LayoutTagLibrary.class.getMethod("getDefaultSelectedRowNames", Layout.class, Boolean.TYPE);
            this.addFunction("defaultSelectedRowNames", getDefaultSelectedRowNames);
            this.addFunction("defaultSelectedColumnNames", getDefaultSelectedRowNames);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            Method isBoundToEditMode = BuiltinModes.class.getMethod("isBoundToEditMode", String.class);
            this.addFunction("isBoundToEditMode", isBoundToEditMode);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            Method isLikePlainMode = BuiltinWidgetModes.class.getMethod("isLikePlainMode", String.class);
            this.addFunction("isLikePlainMode", isLikePlainMode);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            Method isLikeViewMode = BuiltinWidgetModes.class.getMethod("isLikeViewMode", String.class);
            this.addFunction("isLikeViewMode", isLikeViewMode);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static WidgetTypeDefinition getWidgetTypeDefinition(String typeName) {
        WebLayoutManager layoutService;
        try {
            layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        if (layoutService == null) {
            throw new FacesException("Layout service not found");
        }
        return layoutService.getWidgetTypeDefinition(typeName);
    }

    public static String getFieldDefinitionsAsString(FieldDefinition[] defs) {
        StringBuilder buff = new StringBuilder();
        if (defs != null) {
            for (FieldDefinition def : defs) {
                buff.append(def.getPropertyName()).append(" ");
            }
        }
        return buff.toString().trim();
    }

    public static List<LayoutRow> getSelectedRows(Layout layout, List<String> selectedRowNames, boolean showAlwaysSelected) {
        LayoutRow[] rows = layout.getRows();
        ArrayList<LayoutRow> selectedRows = new ArrayList<LayoutRow>();
        if (rows != null) {
            for (LayoutRow row : rows) {
                if (row.isAlwaysSelected() && showAlwaysSelected) {
                    selectedRows.add(row);
                    continue;
                }
                if (selectedRowNames == null && row.isSelectedByDefault() && !row.isAlwaysSelected()) {
                    selectedRows.add(row);
                    continue;
                }
                if (selectedRowNames == null || !selectedRowNames.contains(row.getName())) continue;
                selectedRows.add(row);
            }
        }
        return selectedRows;
    }

    public static List<LayoutRow> getNotSelectedRows(Layout layout, List<String> selectedRowNames) {
        LayoutRow[] rows = layout.getRows();
        ArrayList<LayoutRow> notSelectedRows = new ArrayList<LayoutRow>();
        if (rows != null) {
            for (LayoutRow row : rows) {
                if (selectedRowNames == null && !row.isSelectedByDefault() && !row.isAlwaysSelected()) {
                    notSelectedRows.add(row);
                    continue;
                }
                if (selectedRowNames == null || row.isAlwaysSelected() || selectedRowNames.contains(row.getName())) continue;
                notSelectedRows.add(row);
            }
        }
        return notSelectedRows;
    }

    public static List<String> getDefaultSelectedRowNames(Layout layout, boolean showAlwaysSelected) {
        List<LayoutRow> selectedRows = LayoutTagLibrary.getSelectedRows(layout, null, showAlwaysSelected);
        ArrayList<String> selectedRowNames = null;
        if (selectedRows != null && !selectedRows.isEmpty()) {
            selectedRowNames = new ArrayList<String>();
            for (LayoutRow row : selectedRows) {
                selectedRowNames.add(row.getName());
            }
        }
        return selectedRowNames;
    }
}

