/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc.cache;

import java.util.HashMap;
import java.util.LinkedList;

public class SimpleLRUCache
extends HashMap {
    private final int maxCacheSize;
    private final LinkedList list;

    public SimpleLRUCache(int maxCacheSize) {
        super(maxCacheSize);
        this.maxCacheSize = Math.max(0, maxCacheSize);
        this.list = new LinkedList();
    }

    public synchronized void clear() {
        super.clear();
        this.list.clear();
    }

    public synchronized Object put(Object key, Object value) {
        if (this.maxCacheSize == 0) {
            return null;
        }
        if (!super.containsKey(key) && !this.list.isEmpty() && this.list.size() + 1 > this.maxCacheSize) {
            Object deadKey = this.list.removeLast();
            super.remove(deadKey);
        }
        this.freshenKey(key);
        return super.put(key, value);
    }

    public synchronized Object get(Object key) {
        Object value = super.get(key);
        if (value != null) {
            this.freshenKey(key);
        }
        return value;
    }

    public synchronized Object remove(Object key) {
        this.list.remove(key);
        return super.remove(key);
    }

    private void freshenKey(Object key) {
        this.list.remove(key);
        this.list.addFirst(key);
    }
}

