/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.messagedump;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.messagedump.MessageDumpingFeature;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class MessageDumpingTube
extends AbstractFilterTubeImpl {
    static final String DEFAULT_MSGDUMP_LOGGING_ROOT = "javax.enterprise.resource.webservices.jaxws.messagedump";
    private static final Logger TUBE_LOGGER = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.messagedump");
    private final XMLOutputFactory xmlOutputFactory;
    private final Logger messageLogger;
    private final MessageDumpingFeature messageDumpingFeature;
    private AtomicBoolean logMissingStaxUtilsWarning;

    MessageDumpingTube(Tube next, MessageDumpingFeature feature) {
        super(next);
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        this.logMissingStaxUtilsWarning = new AtomicBoolean(false);
        this.messageLogger = Logger.getLogger(feature.getMessageLoggingRoot());
        this.messageDumpingFeature = feature;
    }

    MessageDumpingTube(MessageDumpingTube that, TubeCloner cloner) {
        super(that, cloner);
        this.xmlOutputFactory = that.xmlOutputFactory;
        this.logMissingStaxUtilsWarning = that.logMissingStaxUtilsWarning;
        this.messageLogger = that.messageLogger;
        this.messageDumpingFeature = that.messageDumpingFeature;
    }

    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new MessageDumpingTube(this, cloner);
    }

    public NextAction processRequest(Packet request) {
        this.dump(request);
        return super.processRequest(request);
    }

    public NextAction processResponse(Packet response) {
        this.dump(response);
        return super.processResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(Packet packet) {
        StringWriter stringOut = new StringWriter();
        if (packet.getMessage() == null) {
            stringOut.write("[null]");
        } else {
            XMLStreamWriter writer = null;
            try {
                writer = this.xmlOutputFactory.createXMLStreamWriter(stringOut);
                writer = this.createIndenter(writer);
                packet.getMessage().copy().writeTo(writer);
            }
            catch (XMLStreamException e) {
                TUBE_LOGGER.log(Level.WARNING, "Unexpected exception occured while dumping message", e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (XMLStreamException ignored) {}
                }
            }
        }
        String message = stringOut.toString();
        if (this.messageDumpingFeature.getMessageLoggingStatus()) {
            this.messageLogger.log(this.messageDumpingFeature.getMessageLoggingLevel(), message);
        }
        this.messageDumpingFeature.offerMessage(message);
    }

    private XMLStreamWriter createIndenter(XMLStreamWriter writer) {
        block2: {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass("javanet.staxutils.IndentingXMLStreamWriter");
                Constructor<?> c = clazz.getConstructor(XMLStreamWriter.class);
                writer = (XMLStreamWriter)c.newInstance(writer);
            }
            catch (Exception ex) {
                if (!this.logMissingStaxUtilsWarning.compareAndSet(false, true)) break block2;
                TUBE_LOGGER.log(Level.WARNING, "Put stax-utils.jar to the classpath to indent the dump output", ex);
            }
        }
        return writer;
    }
}

